/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.member.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.audit.model.AuditActor;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.exception.TechnicalDomainException;
import io.gravitee.apim.core.member.model.MembershipReferenceType;
import io.gravitee.apim.core.member.model.SystemRole;
import io.gravitee.apim.core.member.model.crd.MemberCRD;
import io.gravitee.apim.core.membership.model.Role;
import io.gravitee.apim.core.membership.query_service.RoleQueryService;
import io.gravitee.apim.core.user.domain_service.UserDomainService;
import io.gravitee.apim.core.validation.Validator;
import io.gravitee.rest.api.service.common.ReferenceContext;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DomainService
public class ValidateCRDMembersDomainService
implements Validator<Input> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ValidateCRDMembersDomainService.class);
    private final UserDomainService userDomainService;
    private final RoleQueryService roleQueryService;

    @Override
    public Validator.Result<Input> validateAndSanitize(Input input) {
        HashSet<MemberCRD> sanitizedMembers = input.members == null ? new HashSet<MemberCRD>() : new HashSet<MemberCRD>(input.members);
        ArrayList<Validator.Error> errors = new ArrayList<Validator.Error>();
        this.validateAndSanitizeMemberId(input, sanitizedMembers, errors);
        this.validateMemberRole(input, sanitizedMembers, errors);
        this.validatePrimaryOwner(input, sanitizedMembers, errors);
        return Validator.Result.ofBoth(input.sanitized(sanitizedMembers), errors);
    }

    private void validateAndSanitizeMemberId(Input input, Set<MemberCRD> sanitized, ArrayList<Validator.Error> errors) {
        Iterator<MemberCRD> members = sanitized.iterator();
        while (members.hasNext()) {
            MemberCRD member = members.next();
            this.userDomainService.findBySource(input.auditInfo.organizationId(), member.getSource(), member.getSourceId()).ifPresentOrElse(user -> member.setId(user.getId()), () -> {
                errors.add(Validator.Error.warning("member [%s] of source [%s] could not be found in organization [%s]", member.getSourceId(), member.getSource(), input.auditInfo.organizationId()));
                members.remove();
            });
        }
    }

    private void validateMemberRole(Input input, Set<MemberCRD> sanitized, ArrayList<Validator.Error> errors) {
        for (MemberCRD member : sanitized) {
            this.findRole(input.auditInfo.organizationId(), input.referenceType, member.getRole()).ifPresentOrElse(role -> log.debug("Role {} found for scope {}", (Object)member.getRole(), (Object)input.referenceType), () -> errors.add(Validator.Error.warning("member role [%s] doesn't exist", member.getRole())));
        }
    }

    private Optional<Role> findRole(String organizationId, MembershipReferenceType scope, String role) {
        ReferenceContext context = new ReferenceContext(ReferenceContext.Type.ORGANIZATION, organizationId);
        return switch (scope) {
            case MembershipReferenceType.API -> this.roleQueryService.findApiRole(role, context);
            case MembershipReferenceType.APPLICATION -> this.roleQueryService.findApplicationRole(role, context);
            default -> throw new TechnicalDomainException(String.format("Role scope [%s] is not supported", new Object[]{scope}));
        };
    }

    private void validatePrimaryOwner(Input input, Set<MemberCRD> sanitized, ArrayList<Validator.Error> errors) {
        AuditActor actor = input.auditInfo.actor();
        Iterator<MemberCRD> members = sanitized.iterator();
        while (members.hasNext()) {
            MemberCRD member = members.next();
            log.debug("checking that member {} is not defined as a primary owner", (Object)member.getSourceId());
            if (SystemRole.PRIMARY_OWNER.name().equals(member.getRole())) {
                errors.add(Validator.Error.severe("setting a member with the primary owner role is not allowed", new Object[0]));
                members.remove();
                return;
            }
            log.debug("checking that member {} is not the authenticated user who will be set as a primary owner", (Object)member.getSourceId());
            if (!actor.userId().equals(member.getId())) continue;
            errors.add(Validator.Error.severe("can not change the role of primary owner [%s]", member.getSourceId()));
            members.remove();
        }
    }

    @Generated
    public ValidateCRDMembersDomainService(UserDomainService userDomainService, RoleQueryService roleQueryService) {
        this.userDomainService = userDomainService;
        this.roleQueryService = roleQueryService;
    }

    public record Input(AuditInfo auditInfo, String referenceId, MembershipReferenceType referenceType, Set<MemberCRD> members) implements Validator.Input
    {
        Input sanitized(Set<MemberCRD> sanitizedMembers) {
            return new Input(this.auditInfo, this.referenceId, this.referenceType, sanitizedMembers);
        }
    }
}

