/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.license.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.license.crud_service.LicenseCrudService;
import io.gravitee.node.api.license.License;
import io.gravitee.node.api.license.LicenseManager;
import java.util.Objects;

@DomainService
public class LicenseDomainService {
    private final LicenseCrudService licenseCrudService;
    private final LicenseManager licenseManager;

    public LicenseDomainService(LicenseCrudService licenseCrudService, LicenseManager licenseManager) {
        this.licenseCrudService = licenseCrudService;
        this.licenseManager = licenseManager;
    }

    public boolean isFederationFeatureAllowed(String organizationId) {
        License license = this.licenseManager.getOrganizationLicenseOrPlatform(organizationId);
        return !Objects.equals(license.getTier(), "oss");
    }

    public void createOrUpdateOrganizationLicense(String organizationId, String license) {
        this.licenseCrudService.getOrganizationLicense(organizationId).ifPresentOrElse(l -> {
            if (!Objects.equals(l.getLicense(), license)) {
                this.licenseCrudService.updateOrganizationLicense(organizationId, license);
            }
        }, () -> {
            if (Objects.nonNull(license)) {
                this.licenseCrudService.createOrganizationLicense(organizationId, license);
            }
        });
    }
}

