/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.api.exception.DuplicatedHostException;
import io.gravitee.apim.core.api.exception.HostAlreadyExistsException;
import io.gravitee.apim.core.api.exception.InvalidHostException;
import io.gravitee.apim.core.api.model.ApiFieldFilter;
import io.gravitee.apim.core.api.model.ApiSearchCriteria;
import io.gravitee.apim.core.api.query_service.ApiQueryService;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.v4.ApiType;
import io.gravitee.definition.model.v4.listener.tcp.TcpListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DomainService
public class VerifyApiHostsDomainService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VerifyApiHostsDomainService.class);
    private static final Pattern HOST_PATTERN = Pattern.compile("^([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-_]{0,61}[a-zA-Z0-9])(\\.([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-_]{0,61}[a-zA-Z0-9]))*$");
    private final ApiQueryService apiQueryService;

    public boolean checkApiHosts(String environmentId, String apiId, List<String> hosts) {
        VerifyApiHostsDomainService.checkHostsListIsNotEmpty(hosts);
        VerifyApiHostsDomainService.checkHostsAreNotBlank(hosts);
        VerifyApiHostsDomainService.checkHostsAreNotLongerThan255(hosts);
        VerifyApiHostsDomainService.checkHostsAreRfc1123Compliant(hosts);
        this.checkNoDuplicate(hosts);
        this.checkHostsAreAvailable(environmentId, apiId, hosts);
        return true;
    }

    private static void checkHostsListIsNotEmpty(List<String> hosts) {
        if (hosts == null || hosts.isEmpty()) {
            throw new InvalidHostException("At least one host is required for the TCP listener.");
        }
    }

    private static void checkHostsAreNotBlank(List<String> hosts) {
        if (hosts.stream().anyMatch(host -> host == null || host.isBlank())) {
            throw new InvalidHostException("The hosts should not be null or blank.");
        }
    }

    private static void checkHostsAreNotLongerThan255(List<String> hosts) {
        if (hosts.stream().anyMatch(host -> host.length() > 255)) {
            throw new InvalidHostException("The hosts should not be greater than 255 characters.");
        }
    }

    private static void checkHostsAreRfc1123Compliant(List<String> hosts) {
        if (hosts.stream().anyMatch(host -> !HOST_PATTERN.matcher((CharSequence)host).lookingAt())) {
            throw new InvalidHostException("The hosts should be valid.");
        }
    }

    private void checkNoDuplicate(List<String> hosts) throws DuplicatedHostException {
        HashSet set = new HashSet();
        List<String> duplicates = hosts.stream().filter(n -> !set.add(n)).toList();
        if (!duplicates.isEmpty()) {
            throw new DuplicatedHostException(String.join((CharSequence)", ", duplicates));
        }
    }

    private void checkHostsAreAvailable(String environmentId, String apiId, List<String> hosts) {
        Set<String> existingHosts = this.listHostsByEnvironmentId(environmentId, apiId);
        List<String> duplicates = hosts.stream().filter(existingHosts::contains).toList();
        if (!duplicates.isEmpty()) {
            throw new HostAlreadyExistsException(String.join((CharSequence)", ", duplicates));
        }
    }

    private Set<String> listHostsByEnvironmentId(String environmentId, String apiId) {
        return this.apiQueryService.search(ApiSearchCriteria.builder().environmentId(environmentId).build(), null, ApiFieldFilter.builder().pictureExcluded(true).build()).filter(api -> !api.getId().equals(apiId) && ApiType.PROXY.equals((Object)api.getType()) && DefinitionVersion.V4.equals((Object)api.getDefinitionVersion()) && null != api.getApiDefinitionV4()).flatMap(api -> api.getApiDefinitionV4().getListeners().stream()).filter(TcpListener.class::isInstance).map(TcpListener.class::cast).map(TcpListener::getHosts).filter(extractedHosts -> !extractedHosts.isEmpty()).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Generated
    public VerifyApiHostsDomainService(ApiQueryService apiQueryService) {
        this.apiQueryService = apiQueryService;
    }
}

