/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.installation.query_service.InstallationAccessQueryService;
import io.gravitee.apim.core.subscription.domain_service.AcceptSubscriptionDomainService;
import io.gravitee.apim.core.subscription.domain_service.RejectSubscriptionDomainService;
import io.gravitee.apim.core.subscription.model.SubscriptionEntity;
import io.gravitee.apim.infra.adapter.SubscriptionAdapter;
import io.gravitee.common.data.domain.Page;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.v4.listener.ListenerType;
import io.gravitee.definition.model.v4.plan.PlanMode;
import io.gravitee.definition.model.v4.plan.PlanSecurity;
import io.gravitee.definition.model.v4.plan.PlanStatus;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.SubscriptionRepository;
import io.gravitee.repository.management.api.search.Order;
import io.gravitee.repository.management.api.search.SubscriptionCriteria;
import io.gravitee.repository.management.api.search.builder.PageableBuilder;
import io.gravitee.repository.management.model.ApplicationStatus;
import io.gravitee.repository.management.model.ApplicationType;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.Subscription;
import io.gravitee.rest.api.model.ApiKeyEntity;
import io.gravitee.rest.api.model.ApiKeyMode;
import io.gravitee.rest.api.model.ApplicationEntity;
import io.gravitee.rest.api.model.Identifiable;
import io.gravitee.rest.api.model.NewSubscriptionEntity;
import io.gravitee.rest.api.model.PageEntity;
import io.gravitee.rest.api.model.PrimaryOwnerEntity;
import io.gravitee.rest.api.model.ProcessSubscriptionEntity;
import io.gravitee.rest.api.model.SubscriptionConfigurationEntity;
import io.gravitee.rest.api.model.SubscriptionConsumerStatus;
import io.gravitee.rest.api.model.SubscriptionStatus;
import io.gravitee.rest.api.model.TransferSubscriptionEntity;
import io.gravitee.rest.api.model.UpdateSubscriptionConfigurationEntity;
import io.gravitee.rest.api.model.UpdateSubscriptionEntity;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.api.ApiEntrypointEntity;
import io.gravitee.rest.api.model.application.ApplicationListItem;
import io.gravitee.rest.api.model.application.ApplicationSettings;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.pagedresult.Metadata;
import io.gravitee.rest.api.model.subscription.SubscriptionMetadataQuery;
import io.gravitee.rest.api.model.subscription.SubscriptionQuery;
import io.gravitee.rest.api.model.v4.api.ApiModel;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.model.v4.api.GenericApiModel;
import io.gravitee.rest.api.model.v4.plan.GenericPlanEntity;
import io.gravitee.rest.api.model.v4.plan.PlanSecurityType;
import io.gravitee.rest.api.model.v4.plan.PlanValidationType;
import io.gravitee.rest.api.service.ApiKeyService;
import io.gravitee.rest.api.service.ApplicationService;
import io.gravitee.rest.api.service.AuditService;
import io.gravitee.rest.api.service.GroupService;
import io.gravitee.rest.api.service.NotifierService;
import io.gravitee.rest.api.service.PageService;
import io.gravitee.rest.api.service.SubscriptionService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.exceptions.ApplicationArchivedException;
import io.gravitee.rest.api.service.exceptions.PlanAlreadyClosedException;
import io.gravitee.rest.api.service.exceptions.PlanAlreadySubscribedException;
import io.gravitee.rest.api.service.exceptions.PlanGeneralConditionAcceptedException;
import io.gravitee.rest.api.service.exceptions.PlanGeneralConditionRevisionException;
import io.gravitee.rest.api.service.exceptions.PlanMtlsAlreadySubscribedException;
import io.gravitee.rest.api.service.exceptions.PlanNotSubscribableException;
import io.gravitee.rest.api.service.exceptions.PlanNotSubscribableWithSharedApiKeyException;
import io.gravitee.rest.api.service.exceptions.PlanNotSubscribableWithoutClientCertificateException;
import io.gravitee.rest.api.service.exceptions.PlanNotYetPublishedException;
import io.gravitee.rest.api.service.exceptions.PlanOAuth2OrJWTAlreadySubscribedException;
import io.gravitee.rest.api.service.exceptions.PlanRestrictedException;
import io.gravitee.rest.api.service.exceptions.SubscriptionConsumerStatusNotUpdatableException;
import io.gravitee.rest.api.service.exceptions.SubscriptionFailureException;
import io.gravitee.rest.api.service.exceptions.SubscriptionMismatchEnvironmentException;
import io.gravitee.rest.api.service.exceptions.SubscriptionNotClosedException;
import io.gravitee.rest.api.service.exceptions.SubscriptionNotFoundException;
import io.gravitee.rest.api.service.exceptions.SubscriptionNotPausableException;
import io.gravitee.rest.api.service.exceptions.SubscriptionNotPausedException;
import io.gravitee.rest.api.service.exceptions.SubscriptionNotUpdatableException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.exceptions.TransferNotAllowedException;
import io.gravitee.rest.api.service.impl.AbstractService;
import io.gravitee.rest.api.service.notification.ApiHook;
import io.gravitee.rest.api.service.notification.ApplicationHook;
import io.gravitee.rest.api.service.notification.NotificationParamsBuilder;
import io.gravitee.rest.api.service.v4.ApiEntrypointService;
import io.gravitee.rest.api.service.v4.ApiSearchService;
import io.gravitee.rest.api.service.v4.ApiTemplateService;
import io.gravitee.rest.api.service.v4.PlanSearchService;
import io.gravitee.rest.api.service.v4.validation.SubscriptionValidationService;
import java.io.IOException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class SubscriptionServiceImpl
extends AbstractService
implements SubscriptionService {
    private static final String SUBSCRIPTION_SYSTEM_VALIDATOR = "system";
    private static final String RFC_3339_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static final FastDateFormat dateFormatter = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private static final String separator = ";";
    private final Logger logger = LoggerFactory.getLogger(SubscriptionServiceImpl.class);
    @Lazy
    @Autowired
    private PlanSearchService planSearchService;
    @Lazy
    @Autowired
    private SubscriptionRepository subscriptionRepository;
    @Autowired
    private ApiKeyService apiKeyService;
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private ApiSearchService apiSearchService;
    @Autowired
    private AuditService auditService;
    @Autowired
    private NotifierService notifierService;
    @Autowired
    private GroupService groupService;
    @Autowired
    private InstallationAccessQueryService installationAccessQueryService;
    @Autowired
    private UserService userService;
    @Autowired
    private PageService pageService;
    @Autowired
    private ApiEntrypointService apiEntrypointService;
    @Autowired
    private ApiTemplateService apiTemplateService;
    @Autowired
    private SubscriptionValidationService subscriptionValidationService;
    @Autowired
    private AcceptSubscriptionDomainService acceptSubscriptionDomainService;
    @Autowired
    private RejectSubscriptionDomainService rejectSubscriptionDomainService;
    @Autowired
    private SubscriptionAdapter subscriptionAdapter;
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    public io.gravitee.rest.api.model.SubscriptionEntity findById(String subscriptionId) {
        try {
            this.logger.debug("Find subscription by id : {}", (Object)subscriptionId);
            return this.subscriptionRepository.findById((Object)subscriptionId).map(this::convert).orElseThrow(() -> new SubscriptionNotFoundException(subscriptionId));
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to find a subscription using its ID: {}", (Object)subscriptionId, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to find a subscription using its ID: %s", subscriptionId), ex);
        }
    }

    @Override
    public Set<io.gravitee.rest.api.model.SubscriptionEntity> findByIdIn(Collection<String> subscriptionIds) {
        try {
            return this.subscriptionRepository.findByIdIn(subscriptionIds).stream().map(this::convert).collect(Collectors.toSet());
        }
        catch (TechnicalException e) {
            this.logger.error("An error occurs while trying to find subscriptions using IDs [{}]", subscriptionIds, (Object)e);
            throw new TechnicalManagementException(String.format("An error occurs while trying to find subscriptions using IDs [%s]", subscriptionIds), e);
        }
    }

    @Override
    public Collection<io.gravitee.rest.api.model.SubscriptionEntity> findByApplicationAndPlan(ExecutionContext executionContext, String application, String plan) {
        this.logger.debug("Find subscriptions by application {} and plan {}", (Object)application, (Object)plan);
        SubscriptionQuery query = new SubscriptionQuery();
        if (plan != null) {
            query.setPlan(plan);
        }
        if (application != null && !application.trim().isEmpty()) {
            query.setApplication(application);
        } else if (this.isAuthenticated()) {
            Set<ApplicationListItem> applications = this.applicationService.findByUser(executionContext, this.getAuthenticatedUsername());
            query.setApplications((Collection)applications.stream().map(ApplicationListItem::getId).collect(Collectors.toList()));
        }
        return this.search(executionContext, query);
    }

    @Override
    public Collection<io.gravitee.rest.api.model.SubscriptionEntity> findByApi(ExecutionContext executionContext, String api) {
        this.logger.debug("Find subscriptions by api {}", (Object)api);
        SubscriptionQuery query = new SubscriptionQuery();
        query.setApi(api);
        return this.search(executionContext, query);
    }

    @Override
    public Collection<io.gravitee.rest.api.model.SubscriptionEntity> findByPlan(ExecutionContext executionContext, String plan) {
        this.logger.debug("Find subscriptions by plan {}", (Object)plan);
        SubscriptionQuery query = new SubscriptionQuery();
        query.setPlan(plan);
        return this.search(executionContext, query);
    }

    @Override
    public io.gravitee.rest.api.model.SubscriptionEntity create(ExecutionContext executionContext, NewSubscriptionEntity newSubscriptionEntity) {
        return this.create(executionContext, newSubscriptionEntity, null);
    }

    @Override
    public io.gravitee.rest.api.model.SubscriptionEntity create(ExecutionContext executionContext, NewSubscriptionEntity newSubscriptionEntity, String customApiKey) {
        String plan = newSubscriptionEntity.getPlan();
        String application = newSubscriptionEntity.getApplication();
        try {
            boolean userAuthorizedToAccessApiData;
            PlanSecurity planSecurity;
            this.logger.debug("Create a new subscription for plan {} and application {}", (Object)plan, (Object)application);
            GenericPlanEntity genericPlanEntity = this.planSearchService.findById(executionContext, plan);
            this.subscriptionValidationService.validateAndSanitize(genericPlanEntity, newSubscriptionEntity);
            if (genericPlanEntity.getPlanStatus() == PlanStatus.DEPRECATED) {
                throw new PlanNotSubscribableException(plan);
            }
            if (genericPlanEntity.getPlanStatus() == PlanStatus.CLOSED) {
                throw new PlanAlreadyClosedException(plan);
            }
            if (genericPlanEntity.getPlanStatus() == PlanStatus.STAGING) {
                throw new PlanNotYetPublishedException(plan);
            }
            PlanMode planMode = genericPlanEntity.getPlanMode();
            PlanSecurityType planSecurityType = null;
            if (planMode == PlanMode.STANDARD && (planSecurityType = PlanSecurityType.valueOfLabel((String)(planSecurity = genericPlanEntity.getPlanSecurity()).getType())) == PlanSecurityType.KEY_LESS) {
                throw new PlanNotSubscribableException("A keyless plan is not subscribable!");
            }
            if (!(genericPlanEntity.getExcludedGroups() == null || genericPlanEntity.getExcludedGroups().isEmpty() || (userAuthorizedToAccessApiData = this.groupService.isUserAuthorizedToAccessApiData(this.apiSearchService.findGenericById(executionContext, genericPlanEntity.getApiId()), genericPlanEntity.getExcludedGroups(), this.getAuthenticatedUsername())) || this.isEnvironmentAdmin())) {
                throw new PlanRestrictedException(plan);
            }
            if (genericPlanEntity.getGeneralConditions() != null && !genericPlanEntity.getGeneralConditions().isEmpty()) {
                if (Boolean.FALSE.equals(newSubscriptionEntity.getGeneralConditionsAccepted()) || newSubscriptionEntity.getGeneralConditionsContentRevision() == null) {
                    throw new PlanGeneralConditionAcceptedException(genericPlanEntity.getName());
                }
                PageEntity generalConditions = this.pageService.findById(genericPlanEntity.getGeneralConditions());
                if (!generalConditions.getContentRevisionId().equals((Object)newSubscriptionEntity.getGeneralConditionsContentRevision())) {
                    throw new PlanGeneralConditionRevisionException(genericPlanEntity.getName());
                }
            }
            ApplicationEntity applicationEntity = this.applicationService.findById(executionContext, application);
            if (ApplicationStatus.ARCHIVED.name().equals(applicationEntity.getStatus())) {
                throw new ApplicationArchivedException(applicationEntity.getName());
            }
            if (!executionContext.getEnvironmentId().equals(applicationEntity.getEnvironmentId()) && !executionContext.getEnvironmentId().equals(genericPlanEntity.getEnvironmentId())) {
                throw new SubscriptionMismatchEnvironmentException(applicationEntity.getId(), genericPlanEntity.getId());
            }
            List subscriptions = this.subscriptionRepository.search(SubscriptionCriteria.builder().applications(Collections.singleton(application)).apis(Collections.singleton(genericPlanEntity.getApiId())).build());
            if (!subscriptions.isEmpty()) {
                long count;
                Predicate<Subscription> onlyValidSubs = subscription -> subscription.getStatus() != Subscription.Status.REJECTED && subscription.getStatus() != Subscription.Status.CLOSED;
                long subscriptionCount = subscriptions.stream().filter(onlyValidSubs).filter(subscription -> subscription.getPlan().equals(plan)).filter(subscription -> {
                    if (planMode == PlanMode.PUSH) {
                        if (subscription.getConfiguration() == null && newSubscriptionEntity.getConfiguration() == null) {
                            return true;
                        }
                        if (subscription.getConfiguration() != null && newSubscriptionEntity.getConfiguration() != null) {
                            try {
                                SubscriptionConfigurationEntity configuration = (SubscriptionConfigurationEntity)this.objectMapper.readValue(subscription.getConfiguration(), SubscriptionConfigurationEntity.class);
                                String subscriptionChannel = configuration.getChannel();
                                String newSubscriptionChannel = newSubscriptionEntity.getConfiguration().getChannel();
                                return subscriptionChannel == null && newSubscriptionChannel == null || subscriptionChannel != null && subscriptionChannel.equals(newSubscriptionChannel);
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        return false;
                    }
                    return true;
                }).count();
                if (subscriptionCount > 0L) {
                    throw new PlanAlreadySubscribedException(plan);
                }
                if (planSecurityType == PlanSecurityType.MTLS && (count = this.countSubscriptionMatchingPredicate(executionContext, subscriptions, onlyValidSubs, subPlanSecurityType -> subPlanSecurityType == PlanSecurityType.MTLS)) > 0L) {
                    throw new PlanMtlsAlreadySubscribedException("An other mTLS plan is already subscribed by the same application.");
                }
                if ((planSecurityType == PlanSecurityType.OAUTH2 || planSecurityType == PlanSecurityType.JWT) && (count = this.countSubscriptionMatchingPredicate(executionContext, subscriptions, onlyValidSubs, subPlanSecurityType -> subPlanSecurityType == PlanSecurityType.OAUTH2 || subPlanSecurityType == PlanSecurityType.JWT)) > 0L) {
                    throw new PlanOAuth2OrJWTAlreadySubscribedException("An other OAuth2 or JWT plan is already subscribed by the same application.");
                }
                if (planSecurityType == PlanSecurityType.API_KEY && applicationEntity.hasApiKeySharedMode() && (count = this.countSubscriptionMatchingPredicate(executionContext, subscriptions, onlyValidSubs, subPlanSecurityType -> subPlanSecurityType == PlanSecurityType.API_KEY)) > 0L) {
                    throw new PlanNotSubscribableWithSharedApiKeyException();
                }
            }
            String clientId = null;
            if (planSecurityType == PlanSecurityType.OAUTH2 || planSecurityType == PlanSecurityType.JWT) {
                if (ApplicationType.SIMPLE.name().equals(applicationEntity.getType())) {
                    clientId = applicationEntity.getSettings() != null && applicationEntity.getSettings().getApp() != null ? applicationEntity.getSettings().getApp().getClientId() : null;
                } else {
                    String string = clientId = applicationEntity.getSettings() != null && applicationEntity.getSettings().getOauth() != null ? applicationEntity.getSettings().getOauth().getClientId() : null;
                }
                if (clientId == null || clientId.trim().isEmpty()) {
                    throw new PlanNotSubscribableException("A client_id is required to subscribe to an OAuth2 or JWT plan.");
                }
            }
            String clientCertificate = null;
            if (planSecurityType == PlanSecurityType.MTLS) {
                clientCertificate = this.extractAndEncodeClientCertificate(applicationEntity).orElseThrow(PlanNotSubscribableWithoutClientCertificateException::new);
            }
            this.updateApplicationApiKeyMode(executionContext, planSecurityType, applicationEntity, newSubscriptionEntity.getApiKeyMode());
            Subscription subscription2 = new Subscription();
            subscription2.setPlan(plan);
            subscription2.setId(UuidString.generateRandom());
            subscription2.setApplication(application);
            subscription2.setEnvironmentId(executionContext.getEnvironmentId());
            subscription2.setCreatedAt(new Date());
            subscription2.setUpdatedAt(subscription2.getCreatedAt());
            subscription2.setStatus(Subscription.Status.PENDING);
            subscription2.setRequest(newSubscriptionEntity.getRequest());
            subscription2.setSubscribedBy(this.getAuthenticatedUser().getUsername());
            subscription2.setClientId(clientId);
            subscription2.setClientCertificate(clientCertificate);
            subscription2.setMetadata(newSubscriptionEntity.getMetadata());
            this.setSubscriptionConfig(newSubscriptionEntity.getConfiguration(), subscription2);
            String apiId = genericPlanEntity.getApiId();
            subscription2.setApi(apiId);
            subscription2.setGeneralConditionsAccepted(newSubscriptionEntity.getGeneralConditionsAccepted());
            if (newSubscriptionEntity.getGeneralConditionsContentRevision() != null) {
                subscription2.setGeneralConditionsContentRevision(Integer.valueOf(newSubscriptionEntity.getGeneralConditionsContentRevision().getRevision()));
                subscription2.setGeneralConditionsContentPageId(newSubscriptionEntity.getGeneralConditionsContentRevision().getPageId());
            }
            if (planMode == PlanMode.PUSH) {
                subscription2.setType(Subscription.Type.PUSH);
            } else {
                subscription2.setType(Subscription.Type.STANDARD);
            }
            subscription2 = (Subscription)this.subscriptionRepository.create((Object)subscription2);
            this.createAudit(executionContext, apiId, application, (Audit.AuditEvent)Subscription.AuditEvent.SUBSCRIPTION_CREATED, subscription2.getCreatedAt(), null, subscription2);
            GenericApiModel api = this.apiTemplateService.findByIdForTemplates(executionContext, apiId);
            PrimaryOwnerEntity apiOwner = api.getPrimaryOwner();
            String managementURL = this.installationAccessQueryService.getConsoleUrl(executionContext.getOrganizationId());
            Object subscriptionsUrl = "";
            if (!StringUtils.isEmpty((CharSequence)managementURL)) {
                if (managementURL.endsWith("/")) {
                    managementURL = managementURL.substring(0, managementURL.length() - 1);
                }
                subscriptionsUrl = managementURL + "/#!/" + executionContext.getEnvironmentId() + "/apis/" + api.getId() + "/subscriptions/" + subscription2.getId();
            }
            Map<String, Object> params = new NotificationParamsBuilder().api(api).plan(genericPlanEntity).application(applicationEntity).owner(apiOwner).subscription(this.convert(subscription2)).subscriptionsUrl((String)subscriptionsUrl).build();
            if (PlanValidationType.AUTO == genericPlanEntity.getPlanValidation()) {
                ProcessSubscriptionEntity process = new ProcessSubscriptionEntity();
                process.setId(subscription2.getId());
                process.setAccepted(true);
                process.setStartingAt(new Date());
                process.setCustomApiKey(customApiKey);
                return this.process(executionContext, process, SUBSCRIPTION_SYSTEM_VALIDATOR);
            }
            this.notifierService.trigger(executionContext, ApiHook.SUBSCRIPTION_NEW, apiId, params);
            this.notifierService.trigger(executionContext, ApplicationHook.SUBSCRIPTION_NEW, application, params);
            return this.convert(subscription2);
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to subscribe to the plan {}", (Object)plan, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to subscribe to the plan %s", plan), ex);
        }
    }

    private Optional<String> extractAndEncodeClientCertificate(ApplicationEntity applicationEntity) {
        ApplicationSettings settings = applicationEntity.getSettings();
        if (settings == null || settings.getTls() == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(Base64.getEncoder().encodeToString(settings.getTls().getClientCertificate().getBytes()));
    }

    private long countSubscriptionMatchingPredicate(ExecutionContext executionContext, List<Subscription> subscriptions, Predicate<Subscription> onlyValidSubs, Predicate<PlanSecurityType> subscriptionPlanSecurityTypePredicate) {
        return subscriptions.stream().filter(onlyValidSubs).map(Subscription::getPlan).distinct().map(plan -> this.planSearchService.findById(executionContext, (String)plan)).filter(subPlan -> subPlan.getPlanMode() == PlanMode.STANDARD).filter(subPlan -> {
            PlanSecurity subPlanSecurity = subPlan.getPlanSecurity();
            PlanSecurityType subPlanSecurityType = PlanSecurityType.valueOfLabel((String)subPlanSecurity.getType());
            return subscriptionPlanSecurityTypePredicate.test(subPlanSecurityType);
        }).count();
    }

    private void updateApplicationApiKeyMode(ExecutionContext executionContext, PlanSecurityType planSecurityType, ApplicationEntity application, ApiKeyMode apiKeyModeSelected) {
        if (planSecurityType != PlanSecurityType.API_KEY) {
            return;
        }
        if (application.getApiKeyMode() != ApiKeyMode.UNSPECIFIED) {
            return;
        }
        long apiKeySubscriptions = this.countApiKeySubscriptions(executionContext, application);
        if (apiKeyModeSelected == ApiKeyMode.SHARED && apiKeySubscriptions == 0L) {
            this.logger.debug("Do not set application {} Api Key mode to SHARED, as there is no subscription", (Object)application.getId());
            return;
        }
        if (apiKeyModeSelected == ApiKeyMode.SHARED && apiKeySubscriptions > 1L) {
            this.logger.debug("Force application {} API Key mode to EXCLUSIVE, as there is more than one subscription", (Object)application.getId());
            apiKeyModeSelected = ApiKeyMode.EXCLUSIVE;
        }
        if (apiKeyModeSelected == null && apiKeySubscriptions > 0L) {
            apiKeyModeSelected = ApiKeyMode.EXCLUSIVE;
        }
        if (apiKeyModeSelected != null) {
            this.applicationService.updateApiKeyMode(executionContext, application.getId(), apiKeyModeSelected);
        }
    }

    @Override
    public io.gravitee.rest.api.model.SubscriptionEntity update(ExecutionContext executionContext, UpdateSubscriptionEntity updateSubscription) {
        return this.update(executionContext, updateSubscription, s -> {});
    }

    @Override
    public io.gravitee.rest.api.model.SubscriptionEntity update(ExecutionContext executionContext, UpdateSubscriptionConfigurationEntity subscriptionConfigEntity) {
        try {
            Subscription subscription = (Subscription)this.subscriptionRepository.findById((Object)subscriptionConfigEntity.getSubscriptionId()).orElseThrow(() -> new SubscriptionNotFoundException(subscriptionConfigEntity.getSubscriptionId()));
            if (subscription.getStatus() == Subscription.Status.CLOSED) {
                throw new SubscriptionNotUpdatableException(subscriptionConfigEntity.getSubscriptionId());
            }
            GenericPlanEntity planEntity = this.planSearchService.findById(executionContext, subscription.getPlan());
            this.subscriptionValidationService.validateAndSanitize(planEntity, subscriptionConfigEntity);
            Subscription.Status newSubscriptionStatus = planEntity.getPlanValidation() == PlanValidationType.MANUAL ? Subscription.Status.PENDING : subscription.getStatus();
            Subscription previousSubscription = new Subscription(subscription);
            subscription.setUpdatedAt(new Date());
            subscription.setStatus(newSubscriptionStatus);
            subscription.setConsumerStatus(previousSubscription.getConsumerStatus().equals((Object)Subscription.ConsumerStatus.FAILURE) ? Subscription.ConsumerStatus.STARTED : previousSubscription.getConsumerStatus());
            subscription.setFailureCause(null);
            this.setSubscriptionConfig(subscriptionConfigEntity.getConfiguration(), subscription);
            subscription.setMetadata(subscriptionConfigEntity.getMetadata());
            subscription = (Subscription)this.subscriptionRepository.update((Object)subscription);
            this.createAudit(executionContext, planEntity.getApiId(), subscription.getApplication(), (Audit.AuditEvent)Subscription.AuditEvent.SUBSCRIPTION_UPDATED, subscription.getUpdatedAt(), previousSubscription, subscription);
            return this.convert(subscription);
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to update subscription {} configuration", (Object)subscriptionConfigEntity.getSubscriptionId(), (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to update subscription %s configuration", subscriptionConfigEntity.getSubscriptionId()), ex);
        }
    }

    private void setSubscriptionConfig(SubscriptionConfigurationEntity subscriptionConfigEntity, Subscription subscription) {
        if (subscriptionConfigEntity != null) {
            try {
                subscription.setConfiguration(this.objectMapper.writeValueAsString((Object)subscriptionConfigEntity));
            }
            catch (IOException ioe) {
                this.logger.error("Unexpected error while generating subscription configuration", (Throwable)ioe);
            }
        }
    }

    @Override
    public io.gravitee.rest.api.model.SubscriptionEntity updateDaysToExpirationOnLastNotification(String subscriptionId, Integer value) {
        try {
            return this.subscriptionRepository.findById((Object)subscriptionId).map(subscription -> {
                subscription.setDaysToExpirationOnLastNotification(value);
                try {
                    return (Subscription)this.subscriptionRepository.update(subscription);
                }
                catch (TechnicalException ex) {
                    this.logger.error("An error occurs while trying to update subscription {}", (Object)subscriptionId, (Object)ex);
                    throw new TechnicalManagementException(String.format("An error occurs while trying to update subscription %s", subscriptionId), ex);
                }
            }).map(this::convert).orElseThrow(() -> new SubscriptionNotFoundException(subscriptionId));
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to update subscription {}", (Object)subscriptionId, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to update subscription %s", subscriptionId), ex);
        }
    }

    @Override
    public io.gravitee.rest.api.model.SubscriptionEntity update(ExecutionContext executionContext, UpdateSubscriptionEntity updateSubscription, Consumer<Subscription> subscriptionTransformer) {
        try {
            this.logger.debug("Update subscription {}", (Object)updateSubscription.getId());
            Subscription subscription = (Subscription)this.subscriptionRepository.findById((Object)updateSubscription.getId()).orElseThrow(() -> new SubscriptionNotFoundException(updateSubscription.getId()));
            if (subscription.getStatus() == Subscription.Status.ACCEPTED || subscription.getStatus() == Subscription.Status.PENDING || subscription.getStatus() == Subscription.Status.PAUSED) {
                GenericPlanEntity genericPlanEntity = this.planSearchService.findById(executionContext, subscription.getPlan());
                this.subscriptionValidationService.validateAndSanitize(genericPlanEntity, updateSubscription);
                Subscription previousSubscription = new Subscription(subscription);
                this.setSubscriptionConfig(updateSubscription.getConfiguration(), subscription);
                subscription.setMetadata(updateSubscription.getMetadata());
                subscription.setUpdatedAt(new Date());
                subscription.setStartingAt(updateSubscription.getStartingAt());
                subscription.setEndingAt(updateSubscription.getEndingAt());
                subscription.setDaysToExpirationOnLastNotification(null);
                subscriptionTransformer.accept(subscription);
                subscription = (Subscription)this.subscriptionRepository.update((Object)subscription);
                this.createAudit(executionContext, genericPlanEntity.getApiId(), subscription.getApplication(), (Audit.AuditEvent)Subscription.AuditEvent.SUBSCRIPTION_UPDATED, subscription.getUpdatedAt(), previousSubscription, subscription);
                PlanSecurity planSecurity = genericPlanEntity.getPlanSecurity();
                if (planSecurity != null) {
                    Date endingAt = subscription.getEndingAt();
                    PlanSecurityType planSecurityType = PlanSecurityType.valueOfLabel((String)planSecurity.getType());
                    if (planSecurityType == PlanSecurityType.API_KEY && endingAt != null) {
                        this.streamActiveApiKeys(executionContext, subscription.getId()).filter(apiKey -> !apiKey.getApplication().hasApiKeySharedMode()).forEach(apiKey -> {
                            apiKey.setExpireAt(endingAt);
                            this.apiKeyService.update(executionContext, (ApiKeyEntity)apiKey);
                        });
                    }
                }
                return this.convert(subscription);
            }
            throw new SubscriptionNotUpdatableException(updateSubscription.getId());
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to update subscription {}", (Object)updateSubscription.getId(), (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to update subscription %s", updateSubscription.getId()), ex);
        }
    }

    io.gravitee.rest.api.model.SubscriptionEntity process(ExecutionContext executionContext, ProcessSubscriptionEntity processSubscription, String userId) {
        this.logger.debug("Subscription {} processed by {}", (Object)processSubscription.getId(), (Object)userId);
        AuditInfo auditInfo = AuditInfo.builder().organizationId(executionContext.getOrganizationId()).environmentId(executionContext.getEnvironmentId()).actor(this.getAuthenticatedUserAsAuditActor()).build();
        SubscriptionEntity result = processSubscription.isAccepted() ? this.acceptSubscriptionDomainService.autoAccept(processSubscription.getId(), processSubscription.getStartingAt() != null ? processSubscription.getStartingAt().toInstant().atZone(ZoneId.systemDefault()) : null, processSubscription.getEndingAt() != null ? processSubscription.getEndingAt().toInstant().atZone(ZoneId.systemDefault()) : null, processSubscription.getReason(), processSubscription.getCustomApiKey(), auditInfo) : this.rejectSubscriptionDomainService.reject(processSubscription.getId(), processSubscription.getReason(), auditInfo);
        return this.subscriptionAdapter.map(result);
    }

    @Override
    public io.gravitee.rest.api.model.SubscriptionEntity fail(String subscriptionId, String failureCause) {
        try {
            this.logger.debug("Fail subscription {}", (Object)subscriptionId);
            Subscription subscription = (Subscription)this.subscriptionRepository.findById((Object)subscriptionId).orElseThrow(() -> new SubscriptionNotFoundException(subscriptionId));
            Date now = new Date();
            subscription.setUpdatedAt(now);
            subscription.setConsumerPausedAt(null);
            subscription.setConsumerStatus(Subscription.ConsumerStatus.FAILURE);
            subscription.setFailureCause(failureCause);
            subscription = (Subscription)this.subscriptionRepository.update((Object)subscription);
            return this.convert(subscription);
        }
        catch (TechnicalException ex) {
            throw new TechnicalManagementException(String.format("An error occurs while trying to fail subscription %s", subscriptionId), ex);
        }
    }

    @Override
    public io.gravitee.rest.api.model.SubscriptionEntity pauseConsumer(ExecutionContext executionContext, String subscriptionId) {
        try {
            this.logger.debug("Pause subscription {} by consumer", (Object)subscriptionId);
            Subscription subscription = (Subscription)this.subscriptionRepository.findById((Object)subscriptionId).orElseThrow(() -> new SubscriptionNotFoundException(subscriptionId));
            ApplicationEntity application = this.applicationService.findById(executionContext, subscription.getApplication());
            GenericPlanEntity genericPlanEntity = this.planSearchService.findById(executionContext, subscription.getPlan());
            String apiId = genericPlanEntity.getApiId();
            GenericApiModel genericApiModel = this.apiTemplateService.findByIdForTemplates(executionContext, apiId);
            SubscriptionServiceImpl.validateConsumerStatus(subscription, genericApiModel);
            if (subscription.canBeStoppedByConsumer()) {
                Subscription previousSubscription = new Subscription(subscription);
                Date now = new Date();
                subscription.setUpdatedAt(now);
                subscription.setConsumerPausedAt(now);
                subscription.setConsumerStatus(Subscription.ConsumerStatus.STOPPED);
                subscription = (Subscription)this.subscriptionRepository.update((Object)subscription);
                this.createAudit(executionContext, apiId, subscription.getApplication(), (Audit.AuditEvent)Subscription.AuditEvent.SUBSCRIPTION_PAUSED_BY_CONSUMER, subscription.getUpdatedAt(), previousSubscription, subscription);
                this.pauseNonSharedApiKeys(executionContext, subscription, application);
                return this.convert(subscription);
            }
            throw new SubscriptionNotPausableException(subscription);
        }
        catch (TechnicalException ex) {
            throw new TechnicalManagementException(String.format("An error occurs while trying to pause subscription %s by consumer", subscriptionId), ex);
        }
    }

    private void pauseNonSharedApiKeys(ExecutionContext executionContext, Subscription subscription, ApplicationEntity application) {
        this.streamActiveApiKeys(executionContext, subscription.getId()).forEach(apiKey -> {
            if (!application.hasApiKeySharedMode()) {
                apiKey.setPaused(true);
            }
            this.apiKeyService.update(executionContext, (ApiKeyEntity)apiKey);
        });
    }

    @Override
    public io.gravitee.rest.api.model.SubscriptionEntity pause(ExecutionContext executionContext, String subscriptionId) {
        try {
            this.logger.debug("Pause subscription {}", (Object)subscriptionId);
            Subscription subscription = (Subscription)this.subscriptionRepository.findById((Object)subscriptionId).orElseThrow(() -> new SubscriptionNotFoundException(subscriptionId));
            if (subscription.getStatus() == Subscription.Status.ACCEPTED) {
                Subscription previousSubscription = new Subscription(subscription);
                Date now = new Date();
                subscription.setUpdatedAt(now);
                subscription.setPausedAt(now);
                subscription.setStatus(Subscription.Status.PAUSED);
                subscription = (Subscription)this.subscriptionRepository.update((Object)subscription);
                ApplicationEntity application = this.applicationService.findById(executionContext, subscription.getApplication());
                GenericPlanEntity genericPlanEntity = this.planSearchService.findById(executionContext, subscription.getPlan());
                String apiId = genericPlanEntity.getApiId();
                GenericApiModel genericApiModel = this.apiTemplateService.findByIdForTemplates(executionContext, apiId);
                PrimaryOwnerEntity owner = application.getPrimaryOwner();
                Map<String, Object> params = new NotificationParamsBuilder().owner(owner).api(genericApiModel).plan(genericPlanEntity).application(application).build();
                this.notifierService.trigger(executionContext, ApiHook.SUBSCRIPTION_PAUSED, apiId, params);
                this.notifierService.trigger(executionContext, ApplicationHook.SUBSCRIPTION_PAUSED, application.getId(), params);
                this.createAudit(executionContext, apiId, subscription.getApplication(), (Audit.AuditEvent)Subscription.AuditEvent.SUBSCRIPTION_PAUSED, subscription.getUpdatedAt(), previousSubscription, subscription);
                this.pauseNonSharedApiKeys(executionContext, subscription, application);
                return this.convert(subscription);
            }
            throw new SubscriptionNotPausableException(subscription);
        }
        catch (TechnicalException ex) {
            throw new TechnicalManagementException(String.format("An error occurs while trying to pause subscription %s", subscriptionId), ex);
        }
    }

    @Override
    public io.gravitee.rest.api.model.SubscriptionEntity resumeConsumer(ExecutionContext executionContext, String subscriptionId) {
        try {
            this.logger.debug("Resume subscription by {} by consumer", (Object)subscriptionId);
            Subscription subscription = (Subscription)this.subscriptionRepository.findById((Object)subscriptionId).orElseThrow(() -> new SubscriptionNotFoundException(subscriptionId));
            GenericPlanEntity genericPlanEntity = this.planSearchService.findById(executionContext, subscription.getPlan());
            String apiId = genericPlanEntity.getApiId();
            GenericApiModel genericApiModel = this.apiTemplateService.findByIdForTemplates(executionContext, apiId);
            SubscriptionServiceImpl.validateConsumerStatus(subscription, genericApiModel);
            if (subscription.canBeStartedByConsumer()) {
                Subscription previousSubscription = new Subscription(subscription);
                Date now = new Date();
                subscription.setUpdatedAt(now);
                subscription.setConsumerPausedAt(null);
                subscription.setConsumerStatus(Subscription.ConsumerStatus.STARTED);
                subscription = (Subscription)this.subscriptionRepository.update((Object)subscription);
                this.createAudit(executionContext, apiId, subscription.getApplication(), (Audit.AuditEvent)Subscription.AuditEvent.SUBSCRIPTION_RESUMED_BY_CONSUMER, subscription.getUpdatedAt(), previousSubscription, subscription);
                this.resumeApiKeys(executionContext, subscription);
                return this.convert(subscription);
            }
            throw new SubscriptionNotPausedException(subscription);
        }
        catch (TechnicalException ex) {
            throw new TechnicalManagementException(String.format("An error occurs while trying to resume subscription %s", subscriptionId), ex);
        }
    }

    private void resumeApiKeys(ExecutionContext executionContext, Subscription subscription) {
        this.streamActiveApiKeys(executionContext, subscription.getId()).forEach(apiKey -> {
            apiKey.setPaused(false);
            this.apiKeyService.update(executionContext, (ApiKeyEntity)apiKey);
        });
    }

    private static void validateConsumerStatus(Subscription subscription, GenericApiModel genericApiModel) {
        if (subscription.getConsumerStatus() == Subscription.ConsumerStatus.FAILURE) {
            throw new SubscriptionFailureException(subscription);
        }
        if (!DefinitionVersion.V4.equals((Object)genericApiModel.getDefinitionVersion())) {
            throw new SubscriptionConsumerStatusNotUpdatableException(subscription, SubscriptionConsumerStatusNotUpdatableException.Cause.DEFINITION_NOT_V4);
        }
        ApiModel v4ApiModel = (ApiModel)genericApiModel;
        if (v4ApiModel.getListeners() == null || v4ApiModel.getListeners().stream().noneMatch(l -> l.getType().equals((Object)ListenerType.SUBSCRIPTION))) {
            throw new SubscriptionConsumerStatusNotUpdatableException(subscription, SubscriptionConsumerStatusNotUpdatableException.Cause.NO_SUBSCRIPTION_LISTENER);
        }
    }

    @Override
    public io.gravitee.rest.api.model.SubscriptionEntity resume(ExecutionContext executionContext, String subscriptionId) {
        try {
            this.logger.debug("Resume subscription {}", (Object)subscriptionId);
            Subscription subscription = (Subscription)this.subscriptionRepository.findById((Object)subscriptionId).orElseThrow(() -> new SubscriptionNotFoundException(subscriptionId));
            if (subscription.getStatus() == Subscription.Status.PAUSED) {
                Subscription previousSubscription = new Subscription(subscription);
                Date now = new Date();
                subscription.setUpdatedAt(now);
                subscription.setPausedAt(null);
                subscription.setStatus(Subscription.Status.ACCEPTED);
                subscription = (Subscription)this.subscriptionRepository.update((Object)subscription);
                ApplicationEntity application = this.applicationService.findById(executionContext, subscription.getApplication());
                GenericPlanEntity genericPlanEntity = this.planSearchService.findById(executionContext, subscription.getPlan());
                String apiId = genericPlanEntity.getApiId();
                GenericApiModel genericApiModel = this.apiTemplateService.findByIdForTemplates(executionContext, apiId);
                PrimaryOwnerEntity owner = application.getPrimaryOwner();
                Map<String, Object> params = new NotificationParamsBuilder().owner(owner).api(genericApiModel).plan(genericPlanEntity).application(application).build();
                this.notifierService.trigger(executionContext, ApiHook.SUBSCRIPTION_RESUMED, apiId, params);
                this.notifierService.trigger(executionContext, ApplicationHook.SUBSCRIPTION_RESUMED, application.getId(), params);
                this.createAudit(executionContext, apiId, subscription.getApplication(), (Audit.AuditEvent)Subscription.AuditEvent.SUBSCRIPTION_RESUMED, subscription.getUpdatedAt(), previousSubscription, subscription);
                this.resumeApiKeys(executionContext, subscription);
                return this.convert(subscription);
            }
            throw new SubscriptionNotPausedException(subscription);
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to resume subscription {}", (Object)subscriptionId, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to resume subscription %s", subscriptionId), ex);
        }
    }

    @Override
    public io.gravitee.rest.api.model.SubscriptionEntity restore(ExecutionContext executionContext, String subscriptionId) {
        try {
            this.logger.debug("Restore subscription {}", (Object)subscriptionId);
            Subscription subscription = (Subscription)this.subscriptionRepository.findById((Object)subscriptionId).orElseThrow(() -> new SubscriptionNotFoundException(subscriptionId));
            if (subscription.getStatus() == Subscription.Status.CLOSED || subscription.getStatus() == Subscription.Status.REJECTED) {
                Subscription previousSubscription = new Subscription(subscription);
                Date now = new Date();
                subscription.setUpdatedAt(now);
                subscription.setPausedAt(null);
                subscription.setStatus(Subscription.Status.PENDING);
                subscription = (Subscription)this.subscriptionRepository.update((Object)subscription);
                this.createAudit(executionContext, subscription.getApi(), subscription.getApplication(), (Audit.AuditEvent)Subscription.AuditEvent.SUBSCRIPTION_RESUMED, subscription.getUpdatedAt(), previousSubscription, subscription);
                this.streamActiveApiKeys(executionContext, subscription.getId()).forEach(apiKey -> {
                    apiKey.setPaused(false);
                    this.apiKeyService.update(executionContext, (ApiKeyEntity)apiKey);
                });
                return this.convert(subscription);
            }
            throw new SubscriptionNotClosedException(subscriptionId);
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to restore subscription {}", (Object)subscriptionId, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to restore subscription %s", subscriptionId), ex);
        }
    }

    @Override
    public void delete(ExecutionContext executionContext, String subscriptionId) {
        try {
            this.logger.debug("Delete subscription {}", (Object)subscriptionId);
            Subscription subscription = (Subscription)this.subscriptionRepository.findById((Object)subscriptionId).orElseThrow(() -> new SubscriptionNotFoundException(subscriptionId));
            this.apiKeyService.findBySubscription(executionContext, subscriptionId).forEach(apiKey -> this.apiKeyService.delete(apiKey.getKey()));
            this.subscriptionRepository.delete((Object)subscriptionId);
            this.createAudit(executionContext, subscription.getApi(), subscription.getApplication(), (Audit.AuditEvent)Subscription.AuditEvent.SUBSCRIPTION_DELETED, subscription.getUpdatedAt(), subscription, null);
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to delete subscription: {}", (Object)subscriptionId, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to delete subscription: %s", subscriptionId), ex);
        }
    }

    @Override
    public Collection<io.gravitee.rest.api.model.SubscriptionEntity> search(ExecutionContext executionContext, SubscriptionQuery query) {
        try {
            this.logger.debug("Search subscriptions {}", (Object)query);
            SubscriptionCriteria.SubscriptionCriteriaBuilder builder = this.toSubscriptionCriteriaBuilder(query);
            Set subscriptionsIds = null;
            if (query.getApiKey() != null && !query.getApiKey().isEmpty()) {
                if (query.getApis() != null && query.getApis().size() == 1) {
                    ApiKeyEntity apiKey = this.apiKeyService.findByKeyAndApi(executionContext, query.getApiKey(), (String)query.getApis().iterator().next());
                    if (apiKey != null) {
                        subscriptionsIds = apiKey.getSubscriptions().stream().map(io.gravitee.rest.api.model.SubscriptionEntity::getId).collect(Collectors.toSet());
                    }
                } else {
                    List<ApiKeyEntity> apiKeys = this.apiKeyService.findByKey(executionContext, query.getApiKey());
                    if (apiKeys != null) {
                        subscriptionsIds = apiKeys.stream().flatMap(apiKeyEntity -> apiKeyEntity.getSubscriptions().stream()).map(io.gravitee.rest.api.model.SubscriptionEntity::getId).collect(Collectors.toSet());
                    }
                }
            }
            builder.ids(subscriptionsIds);
            Stream<io.gravitee.rest.api.model.SubscriptionEntity> subscriptionsStream = this.subscriptionRepository.search(builder.build()).stream().map(this::convert);
            return subscriptionsStream.collect(Collectors.toList());
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to search for subscriptions: {}", (Object)query, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to search for subscriptions: %s", query), ex);
        }
    }

    @Override
    public Page<io.gravitee.rest.api.model.SubscriptionEntity> search(ExecutionContext executionContext, SubscriptionQuery query, Pageable pageable) {
        return this.search(executionContext, query, pageable, false, false);
    }

    @Override
    public Page<io.gravitee.rest.api.model.SubscriptionEntity> search(ExecutionContext executionContext, SubscriptionQuery query, Pageable pageable, boolean fillApiKey, boolean fillPlanSecurityType) {
        try {
            this.logger.debug("Search pageable subscriptions {}", (Object)query);
            if (query.getApiKey() != null && !query.getApiKey().isEmpty()) {
                List filteredSubscriptions = this.apiKeyService.findByKey(executionContext, query.getApiKey()).stream().flatMap(apiKey -> this.findByIdIn(apiKey.getSubscriptionIds()).stream()).filter(subscription -> query.matchesApi(subscription.getApi()) && query.matchesApplication(subscription.getApplication()) && query.matchesPlan(subscription.getPlan()) && query.matchesStatus(subscription.getStatus())).collect(Collectors.toList());
                return new Page(filteredSubscriptions, 1, filteredSubscriptions.size(), (long)filteredSubscriptions.size());
            }
            SubscriptionCriteria.SubscriptionCriteriaBuilder builder = this.toSubscriptionCriteriaBuilder(query);
            Page pageSubscription = this.subscriptionRepository.search(builder.build(), null, new PageableBuilder().pageNumber(pageable.getPageNumber() - 1).pageSize(pageable.getPageSize()).build()).map(this::convert);
            List subscriptions = pageSubscription.getContent();
            if (fillPlanSecurityType) {
                this.fillPlanSecurityType(executionContext, subscriptions);
            }
            if (fillApiKey) {
                this.fillApiKeys(executionContext, subscriptions);
            }
            return new Page(subscriptions, pageSubscription.getPageNumber() + 1, (int)pageSubscription.getPageElements(), pageSubscription.getTotalElements());
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to search for pageable subscriptions: {}", (Object)query, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to search for pageable subscriptions: %s", query), ex);
        }
    }

    private void fillPlanSecurityType(ExecutionContext executionContext, List<io.gravitee.rest.api.model.SubscriptionEntity> subscriptions) {
        Map<String, List<io.gravitee.rest.api.model.SubscriptionEntity>> subscriptionsByPlan = subscriptions.stream().filter(subscription -> subscription.getPlan() != null).collect(Collectors.groupingBy(io.gravitee.rest.api.model.SubscriptionEntity::getPlan));
        this.planSearchService.findByIdIn(executionContext, subscriptionsByPlan.keySet()).forEach(plan -> {
            PlanSecurity planSecurity = plan.getPlanSecurity();
            if (planSecurity != null) {
                PlanSecurityType planSecurityType = PlanSecurityType.valueOfLabel((String)planSecurity.getType());
                ((List)subscriptionsByPlan.get(plan.getId())).forEach(subscription -> subscription.setSecurity(planSecurityType.name()));
            }
        });
    }

    private void fillApiKeys(ExecutionContext executionContext, List<io.gravitee.rest.api.model.SubscriptionEntity> subscriptions) {
        subscriptions.forEach(subscriptionEntity -> {
            List keys = this.streamActiveApiKeys(executionContext, subscriptionEntity.getId()).map(ApiKeyEntity::getKey).collect(Collectors.toList());
            subscriptionEntity.setKeys(keys);
        });
    }

    private SubscriptionCriteria.SubscriptionCriteriaBuilder toSubscriptionCriteriaBuilder(SubscriptionQuery query) {
        SubscriptionCriteria.SubscriptionCriteriaBuilder builder = SubscriptionCriteria.builder().apis(query.getApis()).applications(query.getApplications()).plans(query.getPlans()).from(query.getFrom()).to(query.getTo()).endingAtAfter(query.getEndingAtAfter()).endingAtBefore(query.getEndingAtBefore()).includeWithoutEnd(query.isIncludeWithoutEnd()).excludedApis(query.getExcludedApis());
        if (query.getStatuses() != null) {
            builder.statuses((Collection)query.getStatuses().stream().map(Enum::name).collect(Collectors.toSet()));
        }
        if (query.getPlanSecurityTypes() != null) {
            builder.planSecurityTypes(query.getPlanSecurityTypes());
        }
        return builder;
    }

    @Override
    public io.gravitee.rest.api.model.SubscriptionEntity transfer(ExecutionContext executionContext, TransferSubscriptionEntity transferSubscription, String userId) {
        try {
            this.logger.debug("Subscription {} transferred by {}", (Object)transferSubscription.getId(), (Object)userId);
            GenericPlanEntity transferGenericPlanEntity = this.planSearchService.findById(executionContext, transferSubscription.getPlan());
            Subscription subscription = (Subscription)this.subscriptionRepository.findById((Object)transferSubscription.getId()).orElseThrow(() -> new SubscriptionNotFoundException(transferSubscription.getId()));
            GenericPlanEntity subscriptionGenericPlanEntity = this.planSearchService.findById(executionContext, subscription.getPlan());
            if (!transferGenericPlanEntity.getApiId().equals(subscription.getApi()) || transferGenericPlanEntity.getPlanStatus() != PlanStatus.PUBLISHED || transferGenericPlanEntity.getPlanSecurity() == null && subscriptionGenericPlanEntity.getPlanSecurity() != null || transferGenericPlanEntity.getPlanSecurity() != null && subscriptionGenericPlanEntity.getPlanSecurity() == null || transferGenericPlanEntity.getPlanSecurity() != null && !transferGenericPlanEntity.getPlanSecurity().getType().equals(subscriptionGenericPlanEntity.getPlanSecurity().getType()) || transferGenericPlanEntity.getGeneralConditions() != null && !transferGenericPlanEntity.getGeneralConditions().isEmpty()) {
                throw new TransferNotAllowedException(transferGenericPlanEntity.getId());
            }
            Subscription previousSubscription = new Subscription(subscription);
            subscription.setUpdatedAt(new Date());
            subscription.setPlan(transferSubscription.getPlan());
            subscription = (Subscription)this.subscriptionRepository.update((Object)subscription);
            ApplicationEntity application = this.applicationService.findById(executionContext, subscription.getApplication());
            String apiId = subscriptionGenericPlanEntity.getApiId();
            GenericApiModel genericApiModel = this.apiTemplateService.findByIdForTemplates(executionContext, apiId);
            PrimaryOwnerEntity owner = application.getPrimaryOwner();
            this.createAudit(executionContext, apiId, subscription.getApplication(), (Audit.AuditEvent)Subscription.AuditEvent.SUBSCRIPTION_UPDATED, subscription.getUpdatedAt(), previousSubscription, subscription);
            io.gravitee.rest.api.model.SubscriptionEntity subscriptionEntity = this.convert(subscription);
            Map<String, Object> params = new NotificationParamsBuilder().owner(owner).application(application).api(genericApiModel).plan(subscriptionGenericPlanEntity).subscription(subscriptionEntity).build();
            this.notifierService.trigger(executionContext, ApiHook.SUBSCRIPTION_TRANSFERRED, apiId, params);
            this.notifierService.trigger(executionContext, ApplicationHook.SUBSCRIPTION_TRANSFERRED, application.getId(), params);
            return subscriptionEntity;
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to transfer subscription {} by {}", new Object[]{transferSubscription.getId(), userId, ex});
            throw new TechnicalManagementException(String.format("An error occurs while trying to transfer subscription %s by %s", transferSubscription.getId(), userId), ex);
        }
    }

    @Override
    public String exportAsCsv(Collection<io.gravitee.rest.api.model.SubscriptionEntity> subscriptions, Map<String, Map<String, Object>> metadata) {
        StringBuilder sb = new StringBuilder();
        this.prepareSubscriptionCsvHeaders(sb);
        if (subscriptions == null || subscriptions.isEmpty()) {
            return sb.toString();
        }
        this.prepareSubscriptionCsvRows(subscriptions, metadata, sb);
        return sb.toString();
    }

    private void prepareSubscriptionCsvRows(Collection<io.gravitee.rest.api.model.SubscriptionEntity> subscriptions, Map<String, Map<String, Object>> metadata, StringBuilder sb) {
        for (io.gravitee.rest.api.model.SubscriptionEntity subscription : subscriptions) {
            Map<String, Object> plan = metadata.get(subscription.getPlan());
            ArrayList<String> cells = new ArrayList<String>();
            cells.add(this.getName(plan));
            Map<String, Object> application = metadata.get(subscription.getApplication());
            cells.add(this.getName(application));
            this.prepareDateCell(subscription.getCreatedAt(), cells);
            this.prepareDateCell(subscription.getProcessedAt(), cells);
            this.prepareDateCell(subscription.getStartingAt(), cells);
            this.prepareDateCell(subscription.getEndingAt(), cells);
            cells.add(subscription.getStatus().name());
            sb.append(String.join((CharSequence)separator, cells)).append(System.lineSeparator());
        }
    }

    private void prepareDateCell(Date date, Collection<String> cells) {
        if (date != null) {
            cells.add(dateFormatter.format(date));
        } else {
            cells.add("");
        }
    }

    private void prepareSubscriptionCsvHeaders(StringBuilder sb) {
        sb.append("Plan");
        sb.append(separator);
        sb.append("Application");
        sb.append(separator);
        sb.append("Creation date");
        sb.append(separator);
        sb.append("Process date");
        sb.append(separator);
        sb.append("Start date");
        sb.append(separator);
        sb.append("End date date");
        sb.append(separator);
        sb.append("Status");
        sb.append(System.lineSeparator());
    }

    @Override
    public Set<String> findReferenceIdsOrderByNumberOfSubscriptions(SubscriptionQuery query, Order order) {
        try {
            return this.subscriptionRepository.findReferenceIdsOrderByNumberOfSubscriptions(this.toSubscriptionCriteriaBuilder(query).build(), order);
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to findReferenceIdsOrderByNumberOfSubscriptions for subscriptions: {}", (Object)query, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to findReferenceIdsOrderByNumberOfSubscriptions for subscriptions: %s", query), ex);
        }
    }

    private String getName(Object map) {
        return map == null ? "" : ((Map)map).get("name").toString();
    }

    @Override
    public Metadata getMetadata(ExecutionContext executionContext, SubscriptionMetadataQuery query) {
        Metadata metadata = new Metadata();
        Collection subscriptions = query.getSubscriptions();
        Optional<Map> applicationsById = query.ifApplications().map(withApplications -> {
            Set<String> appIds = subscriptions.stream().map(io.gravitee.rest.api.model.SubscriptionEntity::getApplication).collect(Collectors.toSet());
            return this.applicationService.findByIds(new ExecutionContext(query.getOrganization(), query.getEnvironment()), appIds).stream().collect(Collectors.toMap(ApplicationListItem::getId, Function.identity()));
        });
        Optional<Map> apisById = query.ifApis().map(withApis -> {
            Set<String> apiIds = subscriptions.stream().map(io.gravitee.rest.api.model.SubscriptionEntity::getApi).collect(Collectors.toSet());
            return this.apiSearchService.findGenericByEnvironmentAndIdIn(executionContext, apiIds).stream().collect(Collectors.toMap(Identifiable::getId, Function.identity()));
        });
        Optional<Map> plansById = query.ifPlans().map(withPlans -> {
            Set<String> planIds = subscriptions.stream().map(io.gravitee.rest.api.model.SubscriptionEntity::getPlan).collect(Collectors.toSet());
            return this.planSearchService.findByIdIn(executionContext, planIds).stream().collect(Collectors.toMap(Identifiable::getId, Function.identity()));
        });
        Optional<Map> subscribersById = query.ifSubscribers().map(withSubscribers -> {
            Set<String> subscriberIds = subscriptions.stream().map(io.gravitee.rest.api.model.SubscriptionEntity::getSubscribedBy).collect(Collectors.toSet());
            return this.userService.findByIds(executionContext, subscriberIds).stream().collect(Collectors.toMap(UserEntity::getId, Function.identity()));
        });
        subscriptions.forEach(subscription -> {
            applicationsById.ifPresent(byId -> this.fillApplicationMetadata((Map<String, ApplicationListItem>)byId, metadata, (io.gravitee.rest.api.model.SubscriptionEntity)subscription));
            apisById.ifPresent(byId -> this.fillApiMetadata(executionContext, (Map<String, GenericApiEntity>)byId, metadata, (io.gravitee.rest.api.model.SubscriptionEntity)subscription, query));
            plansById.ifPresent(byId -> this.fillPlanMetadata((Map<String, GenericPlanEntity>)byId, metadata, (io.gravitee.rest.api.model.SubscriptionEntity)subscription));
            subscribersById.ifPresent(byId -> this.fillSubscribersMetadata((Map<String, UserEntity>)byId, metadata, (io.gravitee.rest.api.model.SubscriptionEntity)subscription));
        });
        return metadata;
    }

    private Metadata fillApplicationMetadata(Map<String, ApplicationListItem> applications, Metadata metadata, io.gravitee.rest.api.model.SubscriptionEntity subscription) {
        if (applications.containsKey(subscription.getApplication())) {
            ApplicationListItem application = applications.get(subscription.getApplication());
            metadata.put(application.getId(), "name", (Object)application.getName());
        }
        return metadata;
    }

    private Metadata fillPlanMetadata(Map<String, GenericPlanEntity> plans, Metadata metadata, io.gravitee.rest.api.model.SubscriptionEntity subscription) {
        if (plans.containsKey(subscription.getPlan())) {
            GenericPlanEntity plan = plans.get(subscription.getPlan());
            metadata.put(plan.getId(), "name", (Object)plan.getName());
            metadata.put(plan.getId(), "planMode", (Object)plan.getPlanMode().name());
            if (plan.getPlanSecurity() != null) {
                metadata.put(plan.getId(), "securityType", (Object)PlanSecurityType.valueOfLabel((String)plan.getPlanSecurity().getType()).name());
            }
        }
        return metadata;
    }

    private Metadata fillApiMetadata(ExecutionContext executionContext, Map<String, GenericApiEntity> apis, Metadata metadata, io.gravitee.rest.api.model.SubscriptionEntity subscription, SubscriptionMetadataQuery query) {
        if (apis.containsKey(subscription.getApi())) {
            GenericApiEntity api = apis.get(subscription.getApi());
            metadata.put(api.getId(), "name", (Object)api.getName());
            metadata.put(api.getId(), "definitionVersion", (Object)api.getDefinitionVersion());
            metadata.put(api.getId(), "apiVersion", (Object)api.getApiVersion());
            if (query.hasDetails()) {
                metadata.put(api.getId(), "state", (Object)api.getLifecycleState());
                metadata.put(api.getId(), "version", (Object)api.getApiVersion());
                List<ApiEntrypointEntity> apiEntrypoints = this.apiEntrypointService.getApiEntrypoints(executionContext, api);
                metadata.put(api.getId(), "entrypoints", apiEntrypoints);
            }
            query.getApiDelegate().forEach(delegate -> delegate.apply(metadata, api));
        }
        return metadata;
    }

    private Metadata fillSubscribersMetadata(Map<String, UserEntity> users, Metadata metadata, io.gravitee.rest.api.model.SubscriptionEntity subscription) {
        if (users.containsKey(subscription.getSubscribedBy())) {
            UserEntity user = users.get(subscription.getSubscribedBy());
            metadata.put(user.getId(), "name", (Object)user.getDisplayName());
        }
        return metadata;
    }

    private io.gravitee.rest.api.model.SubscriptionEntity convert(Subscription subscription) {
        io.gravitee.rest.api.model.SubscriptionEntity entity = new io.gravitee.rest.api.model.SubscriptionEntity();
        entity.setId(subscription.getId());
        entity.setApi(subscription.getApi());
        entity.setPlan(subscription.getPlan());
        entity.setProcessedAt(subscription.getProcessedAt());
        entity.setStatus(SubscriptionStatus.valueOf((String)subscription.getStatus().name()));
        if (subscription.getConsumerStatus() != null) {
            entity.setConsumerStatus(SubscriptionConsumerStatus.valueOf((String)subscription.getConsumerStatus().name()));
        }
        entity.setProcessedBy(subscription.getProcessedBy());
        entity.setRequest(subscription.getRequest());
        entity.setReason(subscription.getReason());
        entity.setApplication(subscription.getApplication());
        entity.setStartingAt(subscription.getStartingAt());
        entity.setEndingAt(subscription.getEndingAt());
        entity.setCreatedAt(subscription.getCreatedAt());
        entity.setUpdatedAt(subscription.getUpdatedAt());
        entity.setSubscribedBy(subscription.getSubscribedBy());
        entity.setClosedAt(subscription.getClosedAt());
        entity.setClientId(subscription.getClientId());
        if (subscription.getClientCertificate() != null) {
            entity.setClientCertificate(new String(Base64.getDecoder().decode(subscription.getClientCertificate())));
        }
        entity.setPausedAt(subscription.getPausedAt());
        entity.setConsumerPausedAt(subscription.getConsumerPausedAt());
        entity.setDaysToExpirationOnLastNotification(subscription.getDaysToExpirationOnLastNotification());
        if (subscription.getConfiguration() != null) {
            try {
                SubscriptionConfigurationEntity configuration = (SubscriptionConfigurationEntity)this.objectMapper.readValue(subscription.getConfiguration(), SubscriptionConfigurationEntity.class);
                entity.setConfiguration(configuration);
            }
            catch (IOException ioe) {
                this.logger.error("Unexpected error while generating API definition", (Throwable)ioe);
            }
        }
        entity.setMetadata(subscription.getMetadata());
        entity.setFailureCause(subscription.getFailureCause());
        return entity;
    }

    private void createAudit(ExecutionContext executionContext, String apiId, String applicationId, Audit.AuditEvent event, Date createdAt, Subscription oldValue, Subscription newValue) {
        this.auditService.createApiAuditLog(executionContext, apiId, Collections.singletonMap(Audit.AuditProperties.APPLICATION, applicationId), event, createdAt, oldValue, newValue);
        this.auditService.createApplicationAuditLog(executionContext, applicationId, Collections.singletonMap(Audit.AuditProperties.API, apiId), event, createdAt, oldValue, newValue);
    }

    private long countApiKeySubscriptions(ExecutionContext executionContext, ApplicationEntity application) {
        SubscriptionQuery subscriptionQuery = new SubscriptionQuery();
        subscriptionQuery.setApplication(application.getId());
        subscriptionQuery.setStatuses(Set.of(SubscriptionStatus.ACCEPTED, SubscriptionStatus.PAUSED, SubscriptionStatus.PENDING));
        return this.search(executionContext, subscriptionQuery).stream().filter(subscription -> {
            GenericPlanEntity genericPlanEntity = this.planSearchService.findById(executionContext, subscription.getPlan());
            if (genericPlanEntity.getPlanMode() != PlanMode.STANDARD) {
                return false;
            }
            PlanSecurityType planSecurityType = PlanSecurityType.valueOfLabel((String)genericPlanEntity.getPlanSecurity().getType());
            return planSecurityType == PlanSecurityType.API_KEY;
        }).count();
    }

    private Stream<ApiKeyEntity> streamActiveApiKeys(ExecutionContext executionContext, String subscriptionId) {
        return this.apiKeyService.findBySubscription(executionContext, subscriptionId).stream().filter(apiKey -> !apiKey.isRevoked() && !apiKey.isExpired());
    }
}

