/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.common.data.domain.Page;
import io.gravitee.rest.api.model.EventEntity;
import io.gravitee.rest.api.model.EventQuery;
import io.gravitee.rest.api.model.EventType;
import io.gravitee.rest.api.model.InstanceEntity;
import io.gravitee.rest.api.model.InstanceListItem;
import io.gravitee.rest.api.model.InstanceQuery;
import io.gravitee.rest.api.model.InstanceState;
import io.gravitee.rest.api.model.PluginEntity;
import io.gravitee.rest.api.service.EventService;
import io.gravitee.rest.api.service.InstanceService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.exceptions.EventNotFoundException;
import io.gravitee.rest.api.service.exceptions.InstanceNotFoundException;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class InstanceServiceImpl
implements InstanceService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InstanceServiceImpl.class);
    private static final String REDACTED = "REDACTED";
    private final EventService eventService;
    private final ObjectMapper objectMapper;
    private final long unknownExpireAfterInSec;
    private static final List<EventType> instancesAllState = List.of(EventType.GATEWAY_STARTED, EventType.GATEWAY_STOPPED);
    private static final List<EventType> instancesRunningOnly = List.of(EventType.GATEWAY_STARTED);

    public InstanceServiceImpl(EventService eventService, ObjectMapper objectMapper, @Value(value="${gateway.unknown-expire-after:604800}") long unknownExpireAfterInSec) {
        this.eventService = eventService;
        this.objectMapper = objectMapper;
        this.unknownExpireAfterInSec = unknownExpireAfterInSec;
    }

    @Override
    public Page<InstanceListItem> search(ExecutionContext executionContext, InstanceQuery query) {
        List<EventType> types = query.isIncludeStopped() ? instancesAllState : instancesRunningOnly;
        ExpiredPredicate filter = new ExpiredPredicate(Duration.ofSeconds(this.unknownExpireAfterInSec));
        long from = query.getFrom() > 0L ? query.getFrom() : Instant.now().minus(this.unknownExpireAfterInSec, ChronoUnit.SECONDS).toEpochMilli();
        Page<EventEntity> eventEntitiesPage = this.eventService.search(executionContext, types, query.getProperties(), from, query.getTo(), query.getPage(), query.getSize(), Collections.singletonList(executionContext.getEnvironmentId()));
        List result = eventEntitiesPage.getContent().stream().map(eventEntity -> {
            InstanceEntity instanceEntity = this.convert((EventEntity)eventEntity);
            InstanceListItem item = new InstanceListItem();
            item.setId(instanceEntity.getId());
            item.setEvent(instanceEntity.getEvent());
            item.setHostname(instanceEntity.getHostname());
            item.setIp(instanceEntity.getIp());
            item.setPort(instanceEntity.getPort());
            item.setLastHeartbeatAt(instanceEntity.getLastHeartbeatAt());
            item.setStartedAt(instanceEntity.getStartedAt());
            item.setStoppedAt(instanceEntity.getStoppedAt());
            item.setVersion(instanceEntity.getVersion());
            item.setTags(instanceEntity.getTags());
            item.setTenant(instanceEntity.getTenant());
            item.setOperatingSystemName(instanceEntity.getSystemProperties() != null ? (String)instanceEntity.getSystemProperties().get("os.name") : "");
            item.setState(instanceEntity.getState());
            return item;
        }).filter(filter).collect(Collectors.toList());
        return new Page(result, eventEntitiesPage.getPageNumber(), result.size(), eventEntitiesPage.getTotalElements());
    }

    @Override
    public InstanceEntity findById(ExecutionContext executionContext, String instanceId) {
        EventQuery query = new EventQuery();
        query.setId(instanceId);
        query.setTypes(instancesAllState);
        Collection<EventEntity> events = this.eventService.search(executionContext, query);
        if (events == null || events.isEmpty()) {
            throw new InstanceNotFoundException(instanceId);
        }
        return this.convert(events.iterator().next());
    }

    @Override
    public InstanceEntity findByEvent(ExecutionContext executionContext, String eventId) {
        try {
            log.debug("Find instance by event ID: {}", (Object)eventId);
            EventEntity event = this.eventService.findById(executionContext, eventId);
            return this.convert(event);
        }
        catch (EventNotFoundException enfe) {
            throw new InstanceNotFoundException(eventId);
        }
    }

    @Override
    public List<InstanceEntity> findAllStarted(ExecutionContext executionContext) {
        log.debug("Find started instances by event");
        EventQuery query = new EventQuery();
        query.setTypes(instancesRunningOnly);
        Collection<EventEntity> events = this.eventService.search(executionContext, query);
        return events.stream().map(this::convert).collect(Collectors.toList());
    }

    private InstanceEntity convert(EventEntity event) {
        Instant nowMinusXMinutes = Instant.now().minus(5L, ChronoUnit.MINUTES);
        Map props = event.getProperties();
        InstanceEntity instance = new InstanceEntity((String)props.get("id"));
        instance.setEvent(event.getId());
        if (!StringUtils.isBlank((CharSequence)((CharSequence)props.get("last_heartbeat_at")))) {
            instance.setLastHeartbeatAt(new Date(Long.parseLong((String)props.get("last_heartbeat_at"))));
        }
        if (!StringUtils.isBlank((CharSequence)((CharSequence)props.get("started_at")))) {
            instance.setStartedAt(new Date(Long.parseLong((String)props.get("started_at"))));
        }
        instance.setEnvironments(event.getEnvironments());
        if (event.getPayload() != null) {
            try {
                InstanceInfo info = (InstanceInfo)this.objectMapper.readValue(event.getPayload(), InstanceInfo.class);
                instance.setHostname(info.getHostname());
                instance.setIp(info.getIp());
                instance.setPort(info.getPort());
                instance.setTenant(info.getTenant());
                instance.setVersion(info.getVersion());
                instance.setTags(info.getTags());
                instance.setSystemProperties(info.getSystemProperties() == null ? Collections.emptyMap() : info.getSystemProperties().entrySet().stream().map(e -> {
                    if (((String)e.getKey()).toLowerCase().contains("password")) {
                        return Map.entry((String)e.getKey(), REDACTED);
                    }
                    return e;
                }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
                instance.setPlugins(info.getPlugins());
                instance.setClusterId(info.getClusterId());
            }
            catch (IOException ioe) {
                log.error("Unexpected error while getting instance data from event payload", (Throwable)ioe);
            }
        }
        if (!StringUtils.isBlank((CharSequence)((CharSequence)props.get("cluster_primary_node")))) {
            instance.setClusterPrimaryNode(Boolean.parseBoolean((String)props.get("cluster_primary_node")));
        }
        if (event.getType() == EventType.GATEWAY_STARTED) {
            if (instance.getLastHeartbeatAt() == null || Instant.ofEpochMilli(instance.getLastHeartbeatAt().getTime()).isBefore(nowMinusXMinutes)) {
                instance.setState(InstanceState.UNKNOWN);
            } else {
                instance.setState(InstanceState.STARTED);
            }
        } else {
            instance.setState(InstanceState.STOPPED);
            if (!StringUtils.isBlank((CharSequence)((CharSequence)props.get("stopped_at")))) {
                instance.setStoppedAt(new Date(Long.parseLong((String)props.get("stopped_at"))));
            }
        }
        return instance;
    }

    public static final class ExpiredPredicate
    implements Predicate<InstanceListItem> {
        private final Duration threshold;

        public ExpiredPredicate(Duration threshold) {
            this.threshold = threshold;
        }

        @Override
        public boolean test(InstanceListItem instance) {
            boolean result = true;
            if (instance.getState().equals((Object)InstanceState.UNKNOWN)) {
                Instant now = Instant.now();
                result = now.toEpochMilli() - instance.getLastHeartbeatAt().getTime() <= this.threshold.toMillis();
            }
            return result;
        }
    }

    private static class InstanceInfo {
        private String id;
        private String version;
        private List<String> tags;
        private Set<PluginEntity> plugins;
        private String hostname;
        private String ip;
        private String port;
        private String tenant;
        private Map<String, String> systemProperties;
        private String clusterId;

        private InstanceInfo() {
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public String getVersion() {
            return this.version;
        }

        @Generated
        public List<String> getTags() {
            return this.tags;
        }

        @Generated
        public Set<PluginEntity> getPlugins() {
            return this.plugins;
        }

        @Generated
        public String getHostname() {
            return this.hostname;
        }

        @Generated
        public String getIp() {
            return this.ip;
        }

        @Generated
        public String getPort() {
            return this.port;
        }

        @Generated
        public String getTenant() {
            return this.tenant;
        }

        @Generated
        public Map<String, String> getSystemProperties() {
            return this.systemProperties;
        }

        @Generated
        public String getClusterId() {
            return this.clusterId;
        }

        @Generated
        public void setId(String id) {
            this.id = id;
        }

        @Generated
        public void setVersion(String version) {
            this.version = version;
        }

        @Generated
        public void setTags(List<String> tags) {
            this.tags = tags;
        }

        @Generated
        public void setPlugins(Set<PluginEntity> plugins) {
            this.plugins = plugins;
        }

        @Generated
        public void setHostname(String hostname) {
            this.hostname = hostname;
        }

        @Generated
        public void setIp(String ip) {
            this.ip = ip;
        }

        @Generated
        public void setPort(String port) {
            this.port = port;
        }

        @Generated
        public void setTenant(String tenant) {
            this.tenant = tenant;
        }

        @Generated
        public void setSystemProperties(Map<String, String> systemProperties) {
            this.systemProperties = systemProperties;
        }

        @Generated
        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }
    }
}

