/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.query_service.scoring;

import io.gravitee.apim.core.scoring.model.ScoringReport;
import io.gravitee.apim.core.scoring.query_service.ScoringReportQueryService;
import io.gravitee.apim.infra.adapter.ScoringReportAdapter;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ScoringReportRepository;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class ScoringReportQueryServiceImpl
implements ScoringReportQueryService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScoringReportQueryServiceImpl.class);
    private final ScoringReportRepository scoringReportRepository;

    public ScoringReportQueryServiceImpl(@Lazy ScoringReportRepository scoringReportRepository) {
        this.scoringReportRepository = scoringReportRepository;
    }

    @Override
    public Optional<ScoringReport> findLatestByApiId(String apiId) {
        try {
            return this.scoringReportRepository.findLatestFor(apiId).map(ScoringReportAdapter.INSTANCE::toEntity);
        }
        catch (TechnicalException e) {
            log.error("An error occurred while finding Scoring Report by API id", (Throwable)e);
            throw new TechnicalManagementException("An error occurred while finding Scoring Report of API: " + apiId, e);
        }
    }
}

