/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.notification.internal;

import io.gravitee.apim.core.api.domain_service.ApiMetadataDecoderDomainService;
import io.gravitee.apim.core.documentation.model.PrimaryOwnerApiTemplateData;
import io.gravitee.apim.core.membership.domain_service.ApiPrimaryOwnerDomainService;
import io.gravitee.apim.core.membership.domain_service.ApplicationPrimaryOwnerDomainService;
import io.gravitee.apim.core.membership.model.PrimaryOwnerEntity;
import io.gravitee.apim.core.notification.model.ApiNotificationTemplateData;
import io.gravitee.apim.core.notification.model.ApplicationNotificationTemplateData;
import io.gravitee.apim.core.notification.model.IntegrationNotificationTemplateData;
import io.gravitee.apim.core.notification.model.PlanNotificationTemplateData;
import io.gravitee.apim.core.notification.model.PrimaryOwnerNotificationTemplateData;
import io.gravitee.apim.core.notification.model.SubscriptionNotificationTemplateData;
import io.gravitee.apim.core.notification.model.hook.HookContext;
import io.gravitee.apim.core.notification.model.hook.HookContextEntry;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.ApplicationRepository;
import io.gravitee.repository.management.api.IntegrationRepository;
import io.gravitee.repository.management.api.PlanRepository;
import io.gravitee.repository.management.api.SubscriptionRepository;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class TemplateDataFetcher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TemplateDataFetcher.class);
    private final ApiRepository apiRepository;
    private final ApplicationRepository applicationRepository;
    private final PlanRepository planRepository;
    private final SubscriptionRepository subscriptionRepository;
    private final IntegrationRepository integrationRepository;
    private final ApiPrimaryOwnerDomainService apiPrimaryOwnerDomainService;
    private final ApplicationPrimaryOwnerDomainService applicationPrimaryOwnerDomainService;
    private final ApiMetadataDecoderDomainService apiMetadataDecoderDomainService;

    public TemplateDataFetcher(@Lazy ApiRepository apiRepository, @Lazy ApplicationRepository applicationRepository, @Lazy PlanRepository planRepository, @Lazy SubscriptionRepository subscriptionRepository, @Lazy IntegrationRepository integrationRepository, ApiPrimaryOwnerDomainService apiPrimaryOwnerDomainService, ApplicationPrimaryOwnerDomainService applicationPrimaryOwnerDomainService, ApiMetadataDecoderDomainService apiMetadataDecoderDomainService) {
        this.apiRepository = apiRepository;
        this.applicationRepository = applicationRepository;
        this.planRepository = planRepository;
        this.subscriptionRepository = subscriptionRepository;
        this.integrationRepository = integrationRepository;
        this.apiPrimaryOwnerDomainService = apiPrimaryOwnerDomainService;
        this.applicationPrimaryOwnerDomainService = applicationPrimaryOwnerDomainService;
        this.apiMetadataDecoderDomainService = apiMetadataDecoderDomainService;
    }

    public Map<String, Object> fetchData(String organizationId, HookContext hookContext) {
        return hookContext.getProperties().entrySet().stream().map(entry -> {
            String string = this.keyFor((HookContextEntry)((Object)((Object)entry.getKey())));
            return Map.entry(string, switch ((HookContextEntry)((Object)((Object)entry.getKey()))) {
                default -> throw new IncompatibleClassChangeError();
                case HookContextEntry.API_ID -> this.buildApiNotificationTemplateData(organizationId, (String)entry.getValue());
                case HookContextEntry.APPLICATION_ID -> this.buildApplicationNotificationTemplateData(organizationId, (String)entry.getValue());
                case HookContextEntry.PLAN_ID -> this.buildPlanNotificationTemplateData((String)entry.getValue());
                case HookContextEntry.SUBSCRIPTION_ID -> this.buildSubscriptionNotificationTemplateData((String)entry.getValue());
                case HookContextEntry.INTEGRATION_ID -> this.buildIntegrationNotificationTemplateData((String)entry.getValue());
                case HookContextEntry.API_KEY -> Optional.of((String)entry.getValue());
            });
        }).filter(entry -> ((Optional)entry.getValue()).isPresent()).map(entry -> Map.entry((String)entry.getKey(), ((Optional)entry.getValue()).get())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private String keyFor(HookContextEntry entry) {
        return switch (entry) {
            default -> throw new IncompatibleClassChangeError();
            case HookContextEntry.API_ID -> "api";
            case HookContextEntry.APPLICATION_ID -> "application";
            case HookContextEntry.PLAN_ID -> "plan";
            case HookContextEntry.SUBSCRIPTION_ID -> "subscription";
            case HookContextEntry.INTEGRATION_ID -> "integration";
            case HookContextEntry.API_KEY -> "apiKey";
        };
    }

    private Optional<ApiNotificationTemplateData> buildApiNotificationTemplateData(String organizationId, String apiId) {
        try {
            return this.apiRepository.findById((Object)apiId).map(api -> {
                PrimaryOwnerEntity apiPrimaryOwner = this.apiPrimaryOwnerDomainService.getApiPrimaryOwner(organizationId, apiId);
                Map<String, String> metadata = this.apiMetadataDecoderDomainService.decodeMetadata(apiId, (ApiMetadataDecoderDomainService.ApiMetadataDecodeContext)((ApiMetadataDecoderDomainService.ApiMetadataDecodeContext.ApiMetadataDecodeContextBuilder)((ApiMetadataDecoderDomainService.ApiMetadataDecodeContext.ApiMetadataDecodeContextBuilder)((ApiMetadataDecoderDomainService.ApiMetadataDecodeContext.ApiMetadataDecodeContextBuilder)((ApiMetadataDecoderDomainService.ApiMetadataDecodeContext.ApiMetadataDecodeContextBuilder)((ApiMetadataDecoderDomainService.ApiMetadataDecodeContext.ApiMetadataDecodeContextBuilder)ApiMetadataDecoderDomainService.ApiMetadataDecodeContext.builder().name(api.getName())).description(api.getDescription())).createdAt(api.getCreatedAt())).updatedAt(api.getUpdatedAt())).primaryOwner(new PrimaryOwnerApiTemplateData(apiPrimaryOwner.id(), apiPrimaryOwner.displayName(), apiPrimaryOwner.email(), apiPrimaryOwner.type().name()))).build());
                return ApiNotificationTemplateData.builder().id(api.getId()).name(api.getName()).apiVersion(api.getVersion()).description(api.getDescription()).definitionVersion(api.getDefinitionVersion()).createdAt(api.getCreatedAt()).updatedAt(api.getUpdatedAt()).deployedAt(api.getDeployedAt()).primaryOwner(PrimaryOwnerNotificationTemplateData.from(apiPrimaryOwner)).metadata(metadata).build();
            });
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException(e);
        }
    }

    private Optional<ApplicationNotificationTemplateData> buildApplicationNotificationTemplateData(String organizationId, String applicationId) {
        try {
            return this.applicationRepository.findById((Object)applicationId).map(application -> {
                PrimaryOwnerEntity primaryOwner = this.applicationPrimaryOwnerDomainService.getApplicationPrimaryOwner(organizationId, applicationId);
                return ApplicationNotificationTemplateData.builder().name(application.getName()).type(application.getType().name()).description(application.getDescription()).status(application.getStatus().name()).primaryOwner(PrimaryOwnerNotificationTemplateData.from(primaryOwner)).createdAt(application.getCreatedAt()).updatedAt(application.getUpdatedAt()).apiKeyMode(application.getApiKeyMode().name()).build();
            });
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException(e);
        }
    }

    private Optional<PlanNotificationTemplateData> buildPlanNotificationTemplateData(String planId) {
        try {
            return this.planRepository.findById((Object)planId).map(plan -> PlanNotificationTemplateData.builder().id(plan.getId()).name(plan.getName()).description(plan.getDescription()).order(plan.getOrder()).createdAt(plan.getCreatedAt()).updatedAt(plan.getUpdatedAt()).publishedAt(plan.getPublishedAt()).closedAt(plan.getClosedAt()).commentMessage(plan.getCommentMessage()).security(plan.getSecurity() != null ? plan.getSecurity().name() : null).validation(plan.getValidation().name()).build());
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException(e);
        }
    }

    private Optional<SubscriptionNotificationTemplateData> buildSubscriptionNotificationTemplateData(String subscriptionId) {
        try {
            return this.subscriptionRepository.findById((Object)subscriptionId).map(subscription -> SubscriptionNotificationTemplateData.builder().id(subscription.getId()).reason(subscription.getReason()).request(subscription.getRequest()).build());
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException(e);
        }
    }

    private Optional<IntegrationNotificationTemplateData> buildIntegrationNotificationTemplateData(String integrationId) {
        try {
            return this.integrationRepository.findById((Object)integrationId).map(subscription -> IntegrationNotificationTemplateData.builder().id(subscription.getId()).name(subscription.getName()).provider(subscription.getProvider()).build());
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException(e);
        }
    }
}

