/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.domain_service.documentation;

import io.gravitee.apim.core.documentation.domain_service.ValidatePageSourceDomainService;
import io.gravitee.apim.core.documentation.model.PageSource;
import io.gravitee.apim.core.utils.CollectionUtils;
import io.gravitee.apim.core.utils.StringUtils;
import io.gravitee.apim.core.validation.Validator;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.support.CronExpression;
import org.springframework.stereotype.Service;

@Service
public class ValidatePageSourceDomainServiceImpl
implements ValidatePageSourceDomainService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ValidatePageSourceDomainServiceImpl.class);
    private static final String GITHUB_SOURCE_TYPE = "github-fetcher";
    private static final String HTTP_SOURCE_TYPE = "http-fetcher";
    private static final String GITHUB_URL_PROPERTY = "githubUrl";
    private static final String FETCH_CRON_PROPERTY = "fetchCron";
    private static final String DEFAULT_GITHUB_API_URL = "https://api.github.com";
    private static final Set<String> REQUIRED_GITHUB_PROPERTIES = Set.of("owner", "repository", "filepath", "username", "personalAccessToken");
    private static final Set<String> OPTIONAL_GITHUB_PROPERTIES = Set.of("githubUrl", "fetchCron", "branchOrTag", "autoFetch", "useSystemProxy");
    private static final String HTTP_URL_PROPERTY = "url";
    private static final Set<String> REQUIRED_HTTP_PROPERTIES = Set.of("url");
    private static final Set<String> OPTIONAL_HTTP_PROPERTIES = Set.of("fetchCron", "autoFetch", "useSystemProxy");

    @Override
    public Validator.Result<ValidatePageSourceDomainService.Input> validateAndSanitize(ValidatePageSourceDomainService.Input input) {
        if (input.source() == null) {
            log.debug("Returning empty result as there is no source to validate");
            return Validator.Result.empty();
        }
        return switch (input.source().getType()) {
            case HTTP_SOURCE_TYPE -> this.validateAndSanitizeHTTPSource(input);
            case GITHUB_SOURCE_TYPE -> this.validateAndSanitizeGithubSource(input);
            default -> this.bypassValidation(input);
        };
    }

    private Validator.Result<ValidatePageSourceDomainService.Input> validateAndSanitizeGithubSource(ValidatePageSourceDomainService.Input input) {
        PageSource.PageSourceBuilder sanitizedBuilder = input.source().toBuilder();
        ArrayList<Validator.Error> errors = new ArrayList<Validator.Error>();
        HashMap<String, Object> config = new HashMap<String, Object>(input.source().getConfigurationMap());
        config.putIfAbsent(GITHUB_URL_PROPERTY, DEFAULT_GITHUB_API_URL);
        this.validateAndSanitizeSchema(input.pageName(), config, GITHUB_SOURCE_TYPE, REQUIRED_GITHUB_PROPERTIES, OPTIONAL_GITHUB_PROPERTIES).peek(sanitizedBuilder::configurationMap, errors::addAll);
        this.validateURLProperty(input.pageName(), GITHUB_URL_PROPERTY, GITHUB_SOURCE_TYPE, config).errors().ifPresent(errors::addAll);
        this.validateFetchCronProperty(input.pageName(), GITHUB_SOURCE_TYPE, config).errors().ifPresent(errors::addAll);
        return Validator.Result.ofBoth(input.sanitized(sanitizedBuilder.build()), errors);
    }

    private Validator.Result<ValidatePageSourceDomainService.Input> validateAndSanitizeHTTPSource(ValidatePageSourceDomainService.Input input) {
        PageSource.PageSourceBuilder sanitizedBuilder = input.source().toBuilder();
        ArrayList<Validator.Error> errors = new ArrayList<Validator.Error>();
        HashMap<String, Object> config = new HashMap<String, Object>(input.source().getConfigurationMap());
        this.validateAndSanitizeSchema(input.pageName(), config, HTTP_SOURCE_TYPE, REQUIRED_HTTP_PROPERTIES, OPTIONAL_HTTP_PROPERTIES).peek(sanitizedBuilder::configurationMap, errors::addAll);
        this.validateURLProperty(input.pageName(), HTTP_URL_PROPERTY, HTTP_SOURCE_TYPE, config).errors().ifPresent(errors::addAll);
        this.validateFetchCronProperty(input.pageName(), HTTP_SOURCE_TYPE, config).errors().ifPresent(errors::addAll);
        return Validator.Result.ofBoth(input.sanitized(sanitizedBuilder.build()), errors);
    }

    private Validator.Result<ValidatePageSourceDomainService.Input> bypassValidation(ValidatePageSourceDomainService.Input input) {
        log.debug("Bypassing validation for source {} as it has not been implemented", (Object)input.source().getType());
        return Validator.Result.ofValue(input);
    }

    private Validator.Result<String> validateURLProperty(String pageName, String propertyName, String sourceType, Map<String, Object> config) {
        try {
            String property = (String)config.get(propertyName);
            return Validator.Result.ofValue(URI.create(property).toURL().toString());
        }
        catch (Exception e) {
            return Validator.Result.withError(Validator.Error.severe("property [%s] of source [%s] must be a valid URL for page [%s]", propertyName, sourceType, pageName));
        }
    }

    private Validator.Result<String> validateFetchCronProperty(String pageName, String sourceType, Map<String, Object> config) {
        String cronExpression = (String)config.get(FETCH_CRON_PROPERTY);
        if (StringUtils.isEmpty(cronExpression)) {
            return Validator.Result.empty();
        }
        return CronExpression.isValidExpression((String)cronExpression) ? Validator.Result.ofValue(cronExpression) : Validator.Result.withError(Validator.Error.severe("property [fetchCron] of source [%s] must be a valid cron expression for page [%s]", sourceType, pageName));
    }

    private Validator.Result<Map<String, Object>> validateAndSanitizeSchema(String pageName, Map<String, Object> config, String sourceType, Set<String> required, Set<String> optional) {
        ArrayList<Validator.Error> errors = new ArrayList<Validator.Error>();
        HashMap<String, Object> sanitized = new HashMap<String, Object>(config);
        HashMap<String, Object> givenFields = new HashMap<String, Object>(sanitized);
        HashSet<String> requiredFields = new HashSet<String>(required);
        requiredFields.removeAll(givenFields.keySet());
        if (CollectionUtils.isNotEmpty(requiredFields)) {
            errors.add(Validator.Error.severe("property [%s] is required in [%s] configuration for page [%s]", requiredFields.iterator().next(), sourceType, pageName));
        }
        givenFields.keySet().removeAll(required);
        givenFields.keySet().removeAll(optional);
        for (String field : givenFields.keySet()) {
            errors.add(Validator.Error.warning("page [%s] contains unknown configuration property [%s] for [%s] source", pageName, field, sourceType));
            sanitized.remove(field);
        }
        return Validator.Result.ofBoth(sanitized, errors);
    }
}

