/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.core.scoring.model.ScoringAssetType;
import io.gravitee.apim.core.scoring.model.ScoringReport;
import io.gravitee.apim.infra.adapter.ScoringReportAdapter;
import io.gravitee.repository.management.model.ScoringReport;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class ScoringReportAdapterImpl
implements ScoringReportAdapter {
    @Override
    public io.gravitee.apim.core.scoring.model.ScoringReport toEntity(ScoringReport source) {
        if (source == null) {
            return null;
        }
        ScoringReport.ScoringReportBuilder scoringReport = io.gravitee.apim.core.scoring.model.ScoringReport.builder();
        scoringReport.id(source.getId());
        scoringReport.apiId(source.getApiId());
        if (source.getCreatedAt() != null) {
            scoringReport.createdAt(ZonedDateTime.ofInstant(source.getCreatedAt().toInstant(), ZoneId.systemDefault()));
        }
        scoringReport.assets(this.assetListToAssetList(source.getAssets()));
        return scoringReport.build();
    }

    @Override
    public ScoringReport toRepository(io.gravitee.apim.core.scoring.model.ScoringReport source) {
        if (source == null) {
            return null;
        }
        ScoringReport.ScoringReportBuilder scoringReport = ScoringReport.builder();
        scoringReport.id(source.id());
        scoringReport.apiId(source.apiId());
        if (source.createdAt() != null) {
            scoringReport.createdAt(Date.from(source.createdAt().toInstant()));
        }
        scoringReport.assets(this.assetListToAssetCollection(source.assets()));
        return scoringReport.build();
    }

    protected ScoringReport.Position positionToPosition(ScoringReport.Position position) {
        if (position == null) {
            return null;
        }
        int line = 0;
        int character = 0;
        line = position.line();
        character = position.character();
        ScoringReport.Position position1 = new ScoringReport.Position(line, character);
        return position1;
    }

    protected ScoringReport.Range rangeToRange(ScoringReport.Range range) {
        if (range == null) {
            return null;
        }
        ScoringReport.Position start = null;
        ScoringReport.Position end = null;
        start = this.positionToPosition(range.start());
        end = this.positionToPosition(range.end());
        ScoringReport.Range range1 = new ScoringReport.Range(start, end);
        return range1;
    }

    protected ScoringReport.Diagnostic diagnosticToDiagnostic(ScoringReport.Diagnostic diagnostic) {
        if (diagnostic == null) {
            return null;
        }
        ScoringReport.Severity severity = null;
        ScoringReport.Range range = null;
        String rule = null;
        String message = null;
        String path = null;
        if (diagnostic.severity() != null) {
            severity = Enum.valueOf(ScoringReport.Severity.class, diagnostic.severity());
        }
        range = this.rangeToRange(diagnostic.range());
        rule = diagnostic.rule();
        message = diagnostic.message();
        path = diagnostic.path();
        ScoringReport.Diagnostic diagnostic1 = new ScoringReport.Diagnostic(severity, range, rule, message, path);
        return diagnostic1;
    }

    protected List<ScoringReport.Diagnostic> diagnosticListToDiagnosticList(List<ScoringReport.Diagnostic> list) {
        if (list == null) {
            return null;
        }
        ArrayList<ScoringReport.Diagnostic> list1 = new ArrayList<ScoringReport.Diagnostic>(list.size());
        for (ScoringReport.Diagnostic diagnostic : list) {
            list1.add(this.diagnosticToDiagnostic(diagnostic));
        }
        return list1;
    }

    protected ScoringReport.Asset assetToAsset(ScoringReport.Asset asset) {
        if (asset == null) {
            return null;
        }
        String pageId = null;
        ScoringAssetType type = null;
        List<ScoringReport.Diagnostic> diagnostics = null;
        pageId = asset.pageId();
        if (asset.type() != null) {
            type = Enum.valueOf(ScoringAssetType.class, asset.type());
        }
        diagnostics = this.diagnosticListToDiagnosticList(asset.diagnostics());
        ScoringReport.Asset asset1 = new ScoringReport.Asset(pageId, type, diagnostics);
        return asset1;
    }

    protected List<ScoringReport.Asset> assetListToAssetList(List<ScoringReport.Asset> list) {
        if (list == null) {
            return null;
        }
        ArrayList<ScoringReport.Asset> list1 = new ArrayList<ScoringReport.Asset>(list.size());
        for (ScoringReport.Asset asset : list) {
            list1.add(this.assetToAsset(asset));
        }
        return list1;
    }

    protected ScoringReport.Position positionToPosition1(ScoringReport.Position position) {
        if (position == null) {
            return null;
        }
        int line = 0;
        int character = 0;
        line = position.line();
        character = position.character();
        ScoringReport.Position position1 = new ScoringReport.Position(line, character);
        return position1;
    }

    protected ScoringReport.Range rangeToRange1(ScoringReport.Range range) {
        if (range == null) {
            return null;
        }
        ScoringReport.Position start = null;
        ScoringReport.Position end = null;
        start = this.positionToPosition1(range.start());
        end = this.positionToPosition1(range.end());
        ScoringReport.Range range1 = new ScoringReport.Range(start, end);
        return range1;
    }

    protected ScoringReport.Diagnostic diagnosticToDiagnostic1(ScoringReport.Diagnostic diagnostic) {
        if (diagnostic == null) {
            return null;
        }
        String severity = null;
        ScoringReport.Range range = null;
        String rule = null;
        String message = null;
        String path = null;
        if (diagnostic.severity() != null) {
            severity = diagnostic.severity().name();
        }
        range = this.rangeToRange1(diagnostic.range());
        rule = diagnostic.rule();
        message = diagnostic.message();
        path = diagnostic.path();
        ScoringReport.Diagnostic diagnostic1 = new ScoringReport.Diagnostic(severity, range, rule, message, path);
        return diagnostic1;
    }

    protected List<ScoringReport.Diagnostic> diagnosticListToDiagnosticList1(List<ScoringReport.Diagnostic> list) {
        if (list == null) {
            return null;
        }
        ArrayList<ScoringReport.Diagnostic> list1 = new ArrayList<ScoringReport.Diagnostic>(list.size());
        for (ScoringReport.Diagnostic diagnostic : list) {
            list1.add(this.diagnosticToDiagnostic1(diagnostic));
        }
        return list1;
    }

    protected ScoringReport.Asset assetToAsset1(ScoringReport.Asset asset) {
        if (asset == null) {
            return null;
        }
        String pageId = null;
        String type = null;
        List<ScoringReport.Diagnostic> diagnostics = null;
        pageId = asset.pageId();
        if (asset.type() != null) {
            type = asset.type().name();
        }
        diagnostics = this.diagnosticListToDiagnosticList1(asset.diagnostics());
        ScoringReport.Asset asset1 = new ScoringReport.Asset(pageId, type, diagnostics);
        return asset1;
    }

    protected Collection<ScoringReport.Asset> assetListToAssetCollection(List<ScoringReport.Asset> list) {
        if (list == null) {
            return null;
        }
        ArrayList<ScoringReport.Asset> collection = new ArrayList<ScoringReport.Asset>(list.size());
        for (ScoringReport.Asset asset : list) {
            collection.add(this.assetToAsset1(asset));
        }
        return collection;
    }
}

