/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import com.fasterxml.jackson.databind.JsonNode;
import io.gravitee.apim.core.api.model.crd.PageCRD;
import io.gravitee.apim.core.member.model.crd.MemberCRD;
import io.gravitee.apim.infra.adapter.GraviteeJacksonMapper;
import io.gravitee.rest.api.model.PageSourceEntity;
import io.gravitee.rest.api.model.api.ApiCRDEntity;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mapstruct.Builder;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.factory.Mappers;

@Mapper(builder=@Builder(disableBuilder=true))
public interface ApiCRDEntityAdapter {
    public static final ApiCRDEntityAdapter INSTANCE = (ApiCRDEntityAdapter)Mappers.getMapper(ApiCRDEntityAdapter.class);

    public MemberCRD map(ApiCRDEntity.Member var1);

    public ApiCRDEntity.Member map(MemberCRD var1);

    @Mapping(target="configuration", expression="java(convertToJsonNode(crd.getConfiguration()))")
    public PageSourceEntity map(PageCRD.PageSource var1);

    @Mapping(target="configurationMap", expression="java(deserializeSourceConfiguration(source))")
    public PageCRD.PageSource map(PageSourceEntity var1);

    public PageCRD map(ApiCRDEntity.PageCRD var1);

    public ApiCRDEntity.PageCRD map(PageCRD var1);

    public Set<MemberCRD> toMemberCRDs(List<ApiCRDEntity.Member> var1);

    public List<ApiCRDEntity.Member> toApiCRDMembers(Set<MemberCRD> var1);

    public Map<String, PageCRD> toCoreApiCRDPages(Map<String, ApiCRDEntity.PageCRD> var1);

    public Map<String, ApiCRDEntity.PageCRD> toRestApiCRDPages(Map<String, PageCRD> var1);

    default public JsonNode convertToJsonNode(String configuration) {
        if (configuration == null) {
            return null;
        }
        try {
            return GraviteeJacksonMapper.getInstance().readTree(configuration);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unexpected error while converting the configuration to JSON Node", ioe);
        }
    }

    default public Map<String, Object> deserializeSourceConfiguration(PageSourceEntity source) {
        if (source.getConfiguration() == null) {
            return Map.of();
        }
        try {
            return (Map)GraviteeJacksonMapper.getInstance().readValue(source.getConfiguration(), Map.class);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unexpected error while converting the configuration to JSON Node", ioe);
        }
    }
}

