/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.subscription.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.api_key.domain_service.GenerateApiKeyDomainService;
import io.gravitee.apim.core.application.crud_service.ApplicationCrudService;
import io.gravitee.apim.core.audit.domain_service.AuditDomainService;
import io.gravitee.apim.core.audit.model.ApiAuditLogEntity;
import io.gravitee.apim.core.audit.model.ApplicationAuditLogEntity;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.audit.model.AuditProperties;
import io.gravitee.apim.core.audit.model.event.SubscriptionAuditEvent;
import io.gravitee.apim.core.integration.model.IntegrationSubscription;
import io.gravitee.apim.core.integration.service_provider.IntegrationAgent;
import io.gravitee.apim.core.notification.domain_service.TriggerNotificationDomainService;
import io.gravitee.apim.core.notification.model.Recipient;
import io.gravitee.apim.core.notification.model.hook.SubscriptionAcceptedApiHookContext;
import io.gravitee.apim.core.notification.model.hook.SubscriptionAcceptedApplicationHookContext;
import io.gravitee.apim.core.plan.crud_service.PlanCrudService;
import io.gravitee.apim.core.plan.model.Plan;
import io.gravitee.apim.core.subscription.crud_service.SubscriptionCrudService;
import io.gravitee.apim.core.subscription.model.SubscriptionEntity;
import io.gravitee.apim.core.user.crud_service.UserCrudService;
import io.gravitee.apim.core.user.model.BaseUserEntity;
import io.gravitee.common.utils.TimeProvider;
import io.gravitee.definition.model.federation.FederatedPlan;
import io.gravitee.definition.model.federation.SubscriptionParameter;
import io.gravitee.rest.api.model.BaseApplicationEntity;
import io.gravitee.rest.api.model.context.OriginContext;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DomainService
public class AcceptSubscriptionDomainService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AcceptSubscriptionDomainService.class);
    public static final String REJECT_BY_TECHNICAL_ERROR_MESSAGE = "A technical error prevented your subscription from being created. Please contact the API administrator for more information.";
    private final SubscriptionCrudService subscriptionCrudService;
    private final AuditDomainService auditDomainService;
    private final ApiCrudService apiCrudService;
    private final ApplicationCrudService applicationCrudService;
    private final PlanCrudService planCrudService;
    private final GenerateApiKeyDomainService generateApiKeyDomainService;
    private final IntegrationAgent integrationAgent;
    private final TriggerNotificationDomainService triggerNotificationDomainService;
    private final UserCrudService userCrudService;

    public SubscriptionEntity autoAccept(String subscriptionId, ZonedDateTime startingAt, ZonedDateTime endingAt, String reason, String customKey, AuditInfo auditInfo) {
        log.debug("Auto accepting subscription {}", (Object)subscriptionId);
        SubscriptionEntity subscription = this.subscriptionCrudService.get(subscriptionId);
        Plan plan = this.planCrudService.getById(subscription.getPlanId());
        return this.accept(subscription, plan, startingAt, endingAt, reason, customKey, auditInfo);
    }

    public SubscriptionEntity accept(SubscriptionEntity subscription, Plan plan, ZonedDateTime startingAt, ZonedDateTime endingAt, String reason, String customKey, AuditInfo auditInfo) {
        if (subscription == null) {
            throw new IllegalArgumentException("Subscription should not be null");
        }
        if (plan.isFederated()) {
            SubscriptionParameter subscriptionParams;
            String integrationId;
            Api api = this.apiCrudService.get(subscription.getApiId());
            BaseApplicationEntity application = this.applicationCrudService.findById(subscription.getApplicationId(), api.getEnvironmentId());
            OriginContext originContext = api.getOriginContext();
            if (originContext instanceof OriginContext.Integration) {
                OriginContext.Integration inte = (OriginContext.Integration)originContext;
                v0 = inte.integrationId();
            } else {
                v0 = integrationId = null;
            }
            if (plan.isApiKey()) {
                subscriptionParams = SubscriptionParameter.apiKey((FederatedPlan)plan.getFederatedPlanDefinition());
            } else if (plan.getFederatedPlanDefinition().isOAuth()) {
                subscriptionParams = SubscriptionParameter.oAuth((String)subscription.getClientId(), (FederatedPlan)plan.getFederatedPlanDefinition());
            } else {
                throw new IllegalArgumentException("Only OAuth and API KEY plans are supported");
            }
            return (SubscriptionEntity)this.integrationAgent.subscribe(integrationId, api.getFederatedApiDefinition(), subscriptionParams, subscription.getId(), application).map(integrationSubscription -> this.acceptByIntegration(subscription.getId(), (IntegrationSubscription)integrationSubscription, auditInfo)).onErrorReturn(throwable -> this.rejectByIntegration(integrationId, subscription.getId(), auditInfo, throwable.getMessage())).blockingGet();
        }
        SubscriptionEntity acceptedSubscription = subscription.acceptBy(auditInfo.actor().userId(), startingAt, endingAt, reason);
        if (plan.isApiKey()) {
            this.generateApiKeyDomainService.generate(acceptedSubscription, auditInfo, customKey);
        }
        this.subscriptionCrudService.update(acceptedSubscription);
        this.createAudit(subscription, acceptedSubscription, auditInfo);
        this.triggerNotifications(auditInfo.organizationId(), acceptedSubscription);
        return acceptedSubscription;
    }

    private SubscriptionEntity acceptByIntegration(String subscriptionId, IntegrationSubscription integrationSubscription, AuditInfo auditInfo) {
        log.debug("Integration accepted subscription {}", (Object)subscriptionId);
        SubscriptionEntity subscription = this.subscriptionCrudService.get(subscriptionId);
        SubscriptionEntity acceptedSubscription = subscription.acceptBy(auditInfo.actor().userId(), TimeProvider.now(), null, subscription.getReasonMessage(), integrationSubscription.metadata());
        this.subscriptionCrudService.update(acceptedSubscription);
        if (integrationSubscription.apiKey() != null && !integrationSubscription.apiKey().isBlank()) {
            this.generateApiKeyDomainService.generateForFederated(acceptedSubscription, auditInfo, integrationSubscription.apiKey());
        }
        this.createAudit(subscription, acceptedSubscription, auditInfo);
        this.triggerNotifications(auditInfo.organizationId(), acceptedSubscription);
        return acceptedSubscription;
    }

    private SubscriptionEntity rejectByIntegration(String integrationId, String subscriptionId, AuditInfo auditInfo, String errorMessage) {
        log.warn("Subscription fail to be processed by Integration [integrationId={}] [subscriptionId={}]: {}", new Object[]{integrationId, subscriptionId, errorMessage});
        SubscriptionEntity subscription = this.subscriptionCrudService.get(subscriptionId);
        SubscriptionEntity rejected = subscription.rejectBy("system", REJECT_BY_TECHNICAL_ERROR_MESSAGE);
        this.subscriptionCrudService.update(rejected);
        this.createAudit(subscription, rejected, auditInfo);
        this.triggerNotifications(auditInfo.organizationId(), rejected);
        return rejected;
    }

    private void createAudit(SubscriptionEntity subscriptionEntity, SubscriptionEntity acceptedSubscriptionEntity, AuditInfo auditInfo) {
        this.auditDomainService.createApiAuditLog(ApiAuditLogEntity.builder().actor(auditInfo.actor()).organizationId(auditInfo.organizationId()).environmentId(auditInfo.environmentId()).apiId(subscriptionEntity.getApiId()).event(SubscriptionAuditEvent.SUBSCRIPTION_UPDATED).oldValue(subscriptionEntity).newValue(acceptedSubscriptionEntity).createdAt(acceptedSubscriptionEntity.getProcessedAt()).properties(Collections.singletonMap(AuditProperties.APPLICATION, subscriptionEntity.getApplicationId())).build());
        this.auditDomainService.createApplicationAuditLog(ApplicationAuditLogEntity.builder().actor(auditInfo.actor()).organizationId(auditInfo.organizationId()).environmentId(auditInfo.environmentId()).applicationId(subscriptionEntity.getApplicationId()).event(SubscriptionAuditEvent.SUBSCRIPTION_UPDATED).oldValue(subscriptionEntity).newValue(acceptedSubscriptionEntity).createdAt(acceptedSubscriptionEntity.getProcessedAt()).properties(Collections.singletonMap(AuditProperties.API, subscriptionEntity.getApiId())).build());
    }

    private void triggerNotifications(String organizationId, SubscriptionEntity acceptedSubscription) {
        Optional<Recipient> subscriberEmail = this.userCrudService.findBaseUserById(acceptedSubscription.getSubscribedBy()).map(BaseUserEntity::getEmail).filter(email -> !email.isEmpty()).map(email -> new Recipient("EMAIL", (String)email));
        List<Recipient> additionalRecipients = subscriberEmail.map(List::of).orElse(Collections.emptyList());
        this.triggerNotificationDomainService.triggerApiNotification(organizationId, new SubscriptionAcceptedApiHookContext(acceptedSubscription.getApiId(), acceptedSubscription.getApplicationId(), acceptedSubscription.getPlanId(), acceptedSubscription.getId()));
        this.triggerNotificationDomainService.triggerApplicationNotification(organizationId, new SubscriptionAcceptedApplicationHookContext(acceptedSubscription.getApplicationId(), acceptedSubscription.getApiId(), acceptedSubscription.getPlanId(), acceptedSubscription.getId()), additionalRecipients);
    }

    @Generated
    public AcceptSubscriptionDomainService(SubscriptionCrudService subscriptionCrudService, AuditDomainService auditDomainService, ApiCrudService apiCrudService, ApplicationCrudService applicationCrudService, PlanCrudService planCrudService, GenerateApiKeyDomainService generateApiKeyDomainService, IntegrationAgent integrationAgent, TriggerNotificationDomainService triggerNotificationDomainService, UserCrudService userCrudService) {
        this.subscriptionCrudService = subscriptionCrudService;
        this.auditDomainService = auditDomainService;
        this.apiCrudService = apiCrudService;
        this.applicationCrudService = applicationCrudService;
        this.planCrudService = planCrudService;
        this.generateApiKeyDomainService = generateApiKeyDomainService;
        this.integrationAgent = integrationAgent;
        this.triggerNotificationDomainService = triggerNotificationDomainService;
        this.userCrudService = userCrudService;
    }
}

