/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.shared_policy_group.use_case;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.audit.domain_service.AuditDomainService;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.audit.model.AuditProperties;
import io.gravitee.apim.core.audit.model.EnvironmentAuditLogEntity;
import io.gravitee.apim.core.shared_policy_group.crud_service.SharedPolicyGroupCrudService;
import io.gravitee.apim.core.shared_policy_group.model.SharedPolicyGroup;
import io.gravitee.apim.core.shared_policy_group.model.SharedPolicyGroupAuditEvent;
import io.gravitee.common.utils.TimeProvider;
import java.util.Map;
import lombok.Generated;

@DomainService
public class DeleteSharedPolicyGroupUseCase {
    private final SharedPolicyGroupCrudService sharedPolicyGroupCrudService;
    private final AuditDomainService auditService;

    public Output execute(Input input) {
        SharedPolicyGroup sharedPolicyGroupToDelete = this.sharedPolicyGroupCrudService.getByEnvironmentId(input.auditInfo().environmentId(), input.sharedPolicyGroupId());
        this.sharedPolicyGroupCrudService.delete(sharedPolicyGroupToDelete.getId());
        this.createAuditLog(sharedPolicyGroupToDelete, input.auditInfo());
        return new Output();
    }

    private void createAuditLog(SharedPolicyGroup sharedPolicyGroup, AuditInfo auditInfo) {
        this.auditService.createEnvironmentAuditLog(EnvironmentAuditLogEntity.builder().organizationId(auditInfo.organizationId()).environmentId(auditInfo.environmentId()).event(SharedPolicyGroupAuditEvent.SHARED_POLICY_GROUP_DELETED).actor(auditInfo.actor()).oldValue(sharedPolicyGroup).newValue(null).createdAt(TimeProvider.now()).properties(Map.of(AuditProperties.SHARED_POLICY_GROUP, sharedPolicyGroup.getId())).build());
    }

    @Generated
    public DeleteSharedPolicyGroupUseCase(SharedPolicyGroupCrudService sharedPolicyGroupCrudService, AuditDomainService auditService) {
        this.sharedPolicyGroupCrudService = sharedPolicyGroupCrudService;
        this.auditService = auditService;
    }

    public record Input(String sharedPolicyGroupId, AuditInfo auditInfo) {
        @Generated
        public static InputBuilder builder() {
            return new InputBuilder();
        }

        @Generated
        public static class InputBuilder {
            @Generated
            private String sharedPolicyGroupId;
            @Generated
            private AuditInfo auditInfo;

            @Generated
            InputBuilder() {
            }

            @Generated
            public InputBuilder sharedPolicyGroupId(String sharedPolicyGroupId) {
                this.sharedPolicyGroupId = sharedPolicyGroupId;
                return this;
            }

            @Generated
            public InputBuilder auditInfo(AuditInfo auditInfo) {
                this.auditInfo = auditInfo;
                return this;
            }

            @Generated
            public Input build() {
                return new Input(this.sharedPolicyGroupId, this.auditInfo);
            }

            @Generated
            public String toString() {
                return "DeleteSharedPolicyGroupUseCase.Input.InputBuilder(sharedPolicyGroupId=" + this.sharedPolicyGroupId + ", auditInfo=" + this.auditInfo + ")";
            }
        }
    }

    public record Output() {
    }
}

