/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.scoring.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.apim.core.api.exception.ApiNotFoundException;
import io.gravitee.apim.core.async_job.crud_service.AsyncJobCrudService;
import io.gravitee.apim.core.async_job.model.AsyncJob;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.documentation.domain_service.ApiDocumentationDomainService;
import io.gravitee.apim.core.scoring.model.ScoreRequest;
import io.gravitee.apim.core.scoring.model.ScoringAssetType;
import io.gravitee.apim.core.scoring.service_provider.ScoringProvider;
import io.gravitee.common.utils.TimeProvider;
import io.gravitee.rest.api.service.common.UuidString;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import java.time.ZonedDateTime;
import java.util.List;

@UseCase
public class ScoreApiRequestUseCase {
    private final ApiCrudService apiCrudService;
    private final ApiDocumentationDomainService apiDocumentationDomainService;
    private final ScoringProvider scoringProvider;
    private final AsyncJobCrudService asyncJobCrudService;

    public ScoreApiRequestUseCase(ApiCrudService apiCrudService, ApiDocumentationDomainService apiDocumentationDomainService, ScoringProvider scoringProvider, AsyncJobCrudService asyncJobCrudService) {
        this.apiCrudService = apiCrudService;
        this.apiDocumentationDomainService = apiDocumentationDomainService;
        this.scoringProvider = scoringProvider;
        this.asyncJobCrudService = asyncJobCrudService;
    }

    public Completable execute(Input input) {
        return Maybe.fromOptional(this.apiCrudService.findById(input.apiId())).switchIfEmpty((SingleSource)Single.error((Throwable)new ApiNotFoundException(input.apiId()))).flatMap(api -> Flowable.fromIterable(this.apiDocumentationDomainService.getApiPages(api.getId(), null)).filter(page -> page.isAsyncApi() || page.isSwagger()).map(page -> new ScoreRequest.AssetToScore(page.getId(), ScoringAssetType.fromPageType(page.getType()), page.getName(), page.getContent())).toList()).flatMapCompletable(assets -> {
            if (assets.isEmpty()) {
                return Completable.complete();
            }
            AsyncJob job = this.newScoringJob(UuidString.generateRandom(), input.auditInfo, input.apiId);
            return this.scoringProvider.requestScore(new ScoreRequest(job.getId(), input.auditInfo.organizationId(), input.auditInfo.environmentId(), input.apiId, (List<ScoreRequest.AssetToScore>)assets)).doOnComplete(() -> this.asyncJobCrudService.create(job));
        });
    }

    public AsyncJob newScoringJob(String id, AuditInfo auditInfo, String apiId) {
        ZonedDateTime now = TimeProvider.now();
        return AsyncJob.builder().id(id).sourceId(apiId).environmentId(auditInfo.environmentId()).initiatorId(auditInfo.actor().userId()).type(AsyncJob.Type.SCORING_REQUEST).status(AsyncJob.Status.PENDING).upperLimit(1L).createdAt(now).updatedAt(now).build();
    }

    public record Input(String apiId, AuditInfo auditInfo) {
    }
}

