/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.scoring.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.async_job.crud_service.AsyncJobCrudService;
import io.gravitee.apim.core.scoring.crud_service.ScoringReportCrudService;
import io.gravitee.apim.core.scoring.model.ScoringReport;
import io.gravitee.common.utils.TimeProvider;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UseCase
public class SaveScoringResponseUseCase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SaveScoringResponseUseCase.class);
    private final AsyncJobCrudService asyncJobCrudService;
    private final ScoringReportCrudService scoringReportCrudService;

    public SaveScoringResponseUseCase(AsyncJobCrudService asyncJobCrudService, ScoringReportCrudService scoringReportCrudService) {
        this.asyncJobCrudService = asyncJobCrudService;
        this.scoringReportCrudService = scoringReportCrudService;
    }

    public Completable execute(Input input) {
        return Maybe.defer(() -> Maybe.fromOptional(this.asyncJobCrudService.findById(input.jobId))).subscribeOn(Schedulers.computation()).flatMapCompletable(job -> {
            String apiId = job.getSourceId();
            ScoringReport report = ScoringReport.builder().id(job.getId()).apiId(apiId).createdAt(TimeProvider.now()).assets(input.analyzedAssets).build();
            return Completable.fromRunnable(() -> this.scoringReportCrudService.deleteByApi(apiId)).andThen((CompletableSource)Completable.fromRunnable(() -> this.scoringReportCrudService.create(report))).doOnComplete(() -> this.asyncJobCrudService.update(job.complete())).doOnError(throwable -> log.error("Fail to save scoring report for API [{}]", (Object)apiId, throwable));
        }).onErrorComplete();
    }

    public record Input(String jobId, List<ScoringReport.Asset> analyzedAssets) {
    }
}

