/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.scoring.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.documentation.crud_service.PageCrudService;
import io.gravitee.apim.core.documentation.model.Page;
import io.gravitee.apim.core.scoring.model.ScoringReport;
import io.gravitee.apim.core.scoring.model.ScoringReportView;
import io.gravitee.apim.core.scoring.query_service.ScoringReportQueryService;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

@UseCase
public class GetLatestReportUseCase {
    private final ScoringReportQueryService scoringReportQueryService;
    private final PageCrudService pageCrudService;

    public Output execute(Input input) {
        ScoringReport report = this.scoringReportQueryService.findLatestByApiId(input.apiId).orElse(null);
        if (report == null) {
            return new Output(null);
        }
        List<ScoringReportView.AssetView> assets = report.assets().stream().map(asset -> {
            String pageName = this.pageCrudService.findById(asset.pageId()).map(Page::getName).orElse(null);
            return new ScoringReportView.AssetView(pageName, asset.type(), asset.diagnostics());
        }).toList();
        Map<ScoringReport.Severity, Long> summary = report.assets().stream().flatMap(asset -> asset.diagnostics().stream()).collect(Collectors.groupingBy(ScoringReport.Diagnostic::severity, Collectors.counting()));
        return new Output(new ScoringReportView(report.id(), report.apiId(), report.createdAt(), assets, new ScoringReportView.Summary(summary.getOrDefault((Object)ScoringReport.Severity.ERROR, 0L), summary.getOrDefault((Object)ScoringReport.Severity.WARN, 0L), summary.getOrDefault((Object)ScoringReport.Severity.INFO, 0L), summary.getOrDefault((Object)ScoringReport.Severity.HINT, 0L))));
    }

    @Generated
    public GetLatestReportUseCase(ScoringReportQueryService scoringReportQueryService, PageCrudService pageCrudService) {
        this.scoringReportQueryService = scoringReportQueryService;
        this.pageCrudService = pageCrudService;
    }

    public record Input(String apiId) {
    }

    public record Output(ScoringReportView report) {
    }
}

