/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.member.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.member.exception.UnsupportedMembershipReferencer;
import io.gravitee.apim.core.member.model.MembershipReferenceType;
import io.gravitee.apim.core.member.model.SystemRole;
import io.gravitee.apim.core.member.model.crd.MemberCRD;
import io.gravitee.apim.core.membership.model.Membership;
import io.gravitee.apim.core.membership.model.Role;
import io.gravitee.apim.core.membership.query_service.MembershipQueryService;
import io.gravitee.apim.core.membership.query_service.RoleQueryService;
import io.gravitee.apim.core.user.domain_service.UserDomainService;
import io.gravitee.apim.core.validation.Validator;
import io.gravitee.rest.api.service.common.ReferenceContext;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;

@DomainService
public class ValidateCRDMembersDomainService
implements Validator<Input> {
    private final UserDomainService userDomainService;
    private final RoleQueryService roleQueryService;
    private final MembershipQueryService membershipQueryService;

    @Override
    public Validator.Result<Input> validateAndSanitize(Input input) {
        HashSet<MemberCRD> sanitizedMembers = input.members == null ? Set.of() : new HashSet<MemberCRD>(input.members);
        ArrayList<Validator.Error> errors = new ArrayList<Validator.Error>();
        this.validateAndSanitizeMemberId(input, sanitizedMembers, errors);
        this.validateMemberRole(input, sanitizedMembers, errors);
        this.validatePrimaryOwner(input, sanitizedMembers, errors);
        return Validator.Result.ofBoth(input.sanitized(sanitizedMembers), errors);
    }

    private void validateAndSanitizeMemberId(Input input, Set<MemberCRD> sanitized, ArrayList<Validator.Error> errors) {
        Iterator<MemberCRD> members = sanitized.iterator();
        while (members.hasNext()) {
            MemberCRD member = members.next();
            this.userDomainService.findBySource(input.organizationId, member.getSource(), member.getSourceId()).ifPresentOrElse(user -> member.setId(user.getId()), () -> {
                errors.add(Validator.Error.warning("member [%s] of source [%s] could not be found in organization [%s]", member.getSourceId(), member.getSource(), input.organizationId()));
                members.remove();
            });
        }
    }

    private void validateMemberRole(Input input, Set<MemberCRD> sanitized, ArrayList<Validator.Error> errors) {
        for (MemberCRD member : sanitized) {
            Role role = null;
            switch (input.referenceType) {
                case APPLICATION: {
                    Optional<Role> applicationRole = this.roleQueryService.findApplicationRole(member.getRole(), new ReferenceContext(ReferenceContext.Type.ORGANIZATION, input.organizationId()));
                    if (!applicationRole.isPresent()) break;
                    role = applicationRole.get();
                    break;
                }
                case API: {
                    Optional<Role> apiRole = this.roleQueryService.findApiRole(member.getRole(), new ReferenceContext(ReferenceContext.Type.ORGANIZATION, input.organizationId()));
                    if (!apiRole.isPresent()) break;
                    role = apiRole.get();
                    break;
                }
                default: {
                    throw new UnsupportedMembershipReferencer(String.format("membership reference is not supported [%s]", new Object[]{input.referenceType}));
                }
            }
            if (role != null) continue;
            errors.add(Validator.Error.warning("member role [%s] doesn't exist", member.getRole()));
        }
    }

    private void validatePrimaryOwner(Input input, Set<MemberCRD> sanitized, ArrayList<Validator.Error> errors) {
        Optional<Membership> membership = switch (input.referenceType) {
            case MembershipReferenceType.APPLICATION -> {
                String poRole = this.roleQueryService.findApplicationRole(SystemRole.PRIMARY_OWNER.name(), new ReferenceContext(ReferenceContext.Type.ORGANIZATION, input.organizationId)).orElseThrow(() -> new RuntimeException("application primary owner role not found")).getId();
                yield this.membershipQueryService.findByReference(Membership.ReferenceType.APPLICATION, input.referenceId).stream().filter(m -> m.getRoleId().equals(poRole)).findFirst();
            }
            case MembershipReferenceType.API -> {
                String poRole = this.roleQueryService.findApiRole(SystemRole.PRIMARY_OWNER.name(), new ReferenceContext(ReferenceContext.Type.ORGANIZATION, input.organizationId)).orElseThrow(() -> new RuntimeException("api primary owner role not found")).getId();
                yield this.membershipQueryService.findByReference(Membership.ReferenceType.API, input.referenceId).stream().filter(m -> m.getRoleId().equals(poRole)).findFirst();
            }
            default -> throw new UnsupportedMembershipReferencer(String.format("membership reference type [%s] doesn't exist", input.referenceType.name()));
        };
        Iterator<MemberCRD> members = sanitized.iterator();
        while (members.hasNext()) {
            MemberCRD member = members.next();
            if (SystemRole.PRIMARY_OWNER.name().equals(member.getRole())) {
                errors.add(Validator.Error.severe("setting a member with the primary owner role is not allowed", new Object[0]));
                members.remove();
            }
            if (!membership.isPresent() || !membership.get().getMemberId().equals(member.getId())) continue;
            errors.add(Validator.Error.severe("can not change the role of exiting primary owner [%s]", member.getSourceId()));
            members.remove();
        }
    }

    @Generated
    public ValidateCRDMembersDomainService(UserDomainService userDomainService, RoleQueryService roleQueryService, MembershipQueryService membershipQueryService) {
        this.userDomainService = userDomainService;
        this.roleQueryService = roleQueryService;
        this.membershipQueryService = membershipQueryService;
    }

    public record Input(String organizationId, String referenceId, MembershipReferenceType referenceType, Set<MemberCRD> members) implements Validator.Input
    {
        Input sanitized(Set<MemberCRD> sanitizedMembers) {
            return new Input(this.organizationId, this.referenceId, this.referenceType, sanitizedMembers);
        }
    }
}

