/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.integration.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.exception.NotAllowedDomainException;
import io.gravitee.apim.core.group.domain_service.ValidateGroupsDomainService;
import io.gravitee.apim.core.integration.crud_service.IntegrationCrudService;
import io.gravitee.apim.core.integration.exception.IntegrationGroupValidationException;
import io.gravitee.apim.core.integration.exception.IntegrationNotFoundException;
import io.gravitee.apim.core.integration.model.Integration;
import io.gravitee.apim.core.license.domain_service.LicenseDomainService;
import io.gravitee.apim.core.validation.Validator;
import io.gravitee.common.utils.TimeProvider;
import java.time.ZonedDateTime;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UseCase
public class UpdateIntegrationUseCase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UpdateIntegrationUseCase.class);
    private final IntegrationCrudService integrationCrudService;
    private final LicenseDomainService licenseDomainService;
    private final ValidateGroupsDomainService validateGroupsDomainService;

    public Output execute(Input input) {
        if (!this.licenseDomainService.isFederationFeatureAllowed(input.auditInfo.organizationId())) {
            throw NotAllowedDomainException.noLicenseForFederation();
        }
        ZonedDateTime now = TimeProvider.now();
        String integrationId = input.integration.getId();
        Set<String> validatedGroups = this.validateGroups(input);
        Integration integration = this.integrationCrudService.findById(integrationId).orElseThrow(() -> new IntegrationNotFoundException(integrationId));
        Object integrationToUpdate = ((Integration.IntegrationBuilder)((Integration.IntegrationBuilder)((Integration.IntegrationBuilder)((Integration.IntegrationBuilder)integration.toBuilder().name(input.integration.getName())).description(input.integration.getDescription())).groups(validatedGroups)).updatedAt(now)).build();
        return new Output(this.integrationCrudService.update((Integration)integrationToUpdate));
    }

    private Set<String> validateGroups(Input input) {
        Validator.Result<ValidateGroupsDomainService.Input> validationResult = this.validateGroupsDomainService.validateAndSanitize(new ValidateGroupsDomainService.Input(input.auditInfo.environmentId(), input.integration.getGroups()));
        if (validationResult.errors().isPresent() && !validationResult.errors().get().isEmpty()) {
            validationResult.errors().get().forEach(error -> log.error(error.getMessage(), error));
            throw new IntegrationGroupValidationException(input.integration.getId());
        }
        return validationResult.value().isPresent() ? validationResult.value().get().groups() : Set.of();
    }

    @Generated
    public UpdateIntegrationUseCase(IntegrationCrudService integrationCrudService, LicenseDomainService licenseDomainService, ValidateGroupsDomainService validateGroupsDomainService) {
        this.integrationCrudService = integrationCrudService;
        this.licenseDomainService = licenseDomainService;
        this.validateGroupsDomainService = validateGroupsDomainService;
    }

    public record Input(Integration integration, AuditInfo auditInfo) {
        @Generated
        public static InputBuilder builder() {
            return new InputBuilder();
        }

        @Generated
        public static class InputBuilder {
            @Generated
            private Integration integration;
            @Generated
            private AuditInfo auditInfo;

            @Generated
            InputBuilder() {
            }

            @Generated
            public InputBuilder integration(Integration integration) {
                this.integration = integration;
                return this;
            }

            @Generated
            public InputBuilder auditInfo(AuditInfo auditInfo) {
                this.auditInfo = auditInfo;
                return this;
            }

            @Generated
            public Input build() {
                return new Input(this.integration, this.auditInfo);
            }

            @Generated
            public String toString() {
                return "UpdateIntegrationUseCase.Input.InputBuilder(integration=" + this.integration + ", auditInfo=" + this.auditInfo + ")";
            }
        }
    }

    public record Output(Integration integration) {
    }
}

