/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.integration.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.async_job.query_service.AsyncJobQueryService;
import io.gravitee.apim.core.exception.NotAllowedDomainException;
import io.gravitee.apim.core.integration.model.Integration;
import io.gravitee.apim.core.integration.model.IntegrationView;
import io.gravitee.apim.core.integration.query_service.IntegrationQueryService;
import io.gravitee.apim.core.integration.service_provider.IntegrationAgent;
import io.gravitee.apim.core.license.domain_service.LicenseDomainService;
import io.gravitee.apim.core.membership.domain_service.IntegrationPrimaryOwnerDomainService;
import io.gravitee.common.data.domain.Page;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.common.PageableImpl;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

@UseCase
public class GetIntegrationsUseCase {
    private final IntegrationQueryService integrationQueryService;
    private final LicenseDomainService licenseDomainService;
    private final IntegrationAgent integrationAgent;
    private final IntegrationPrimaryOwnerDomainService integrationPrimaryOwnerDomainService;
    private final AsyncJobQueryService asyncJobQueryService;

    public Output execute(Input input) {
        String environmentId = input.environmentId();
        Pageable pageable = input.pageable.orElse((Pageable)new PageableImpl(1, 10));
        if (!this.licenseDomainService.isFederationFeatureAllowed(input.organizationId())) {
            throw NotAllowedDomainException.noLicenseForFederation();
        }
        Page<Integration> page = input.isAdmin() ? this.integrationQueryService.findByEnvironment(environmentId, pageable) : this.integrationQueryService.findByEnvironmentAndGroups(environmentId, input.groups(), pageable);
        List pageContent = (List)Flowable.fromIterable((Iterable)page.getContent()).flatMapSingle(integration -> Single.zip((SingleSource)this.integrationAgent.getAgentStatusFor(integration.getId()).map(status -> IntegrationView.AgentStatus.valueOf(status.name())), (SingleSource)Maybe.fromOptional(this.asyncJobQueryService.findPendingJobFor(integration.getId())).map(Optional::of).defaultIfEmpty(Optional.empty()), (SingleSource)this.integrationPrimaryOwnerDomainService.getIntegrationPrimaryOwner(input.organizationId(), integration.getId()).map(po -> Optional.of(new IntegrationView.PrimaryOwner(po.id(), po.email(), po.displayName()))).defaultIfEmpty(Optional.empty()), (agentStatus, pendingJob, primaryOwner) -> new IntegrationView((Integration)integration, (IntegrationView.AgentStatus)((Object)((Object)agentStatus)), pendingJob.orElse(null), primaryOwner.orElse(null)))).toList().blockingGet();
        return new Output((Page<IntegrationView>)new Page(pageContent, page.getPageNumber(), (int)page.getPageElements(), page.getTotalElements()));
    }

    @Generated
    public GetIntegrationsUseCase(IntegrationQueryService integrationQueryService, LicenseDomainService licenseDomainService, IntegrationAgent integrationAgent, IntegrationPrimaryOwnerDomainService integrationPrimaryOwnerDomainService, AsyncJobQueryService asyncJobQueryService) {
        this.integrationQueryService = integrationQueryService;
        this.licenseDomainService = licenseDomainService;
        this.integrationAgent = integrationAgent;
        this.integrationPrimaryOwnerDomainService = integrationPrimaryOwnerDomainService;
        this.asyncJobQueryService = asyncJobQueryService;
    }

    public record Input(String organizationId, String environmentId, boolean isAdmin, Collection<String> groups, Optional<Pageable> pageable) {
        public Input(String organizationId, String environmentId, boolean isAdmin, Collection<String> groups) {
            this(organizationId, environmentId, isAdmin, groups, Optional.empty());
        }

        public Input(String organizationId, String environmentId, boolean isAdmin, Collection<String> groups, Pageable pageable) {
            this(organizationId, environmentId, isAdmin, groups, Optional.of(pageable));
        }

        @Generated
        public static InputBuilder builder() {
            return new InputBuilder();
        }

        @Generated
        public static class InputBuilder {
            @Generated
            private String organizationId;
            @Generated
            private String environmentId;
            @Generated
            private boolean isAdmin;
            @Generated
            private Collection<String> groups;
            @Generated
            private Optional<Pageable> pageable;

            @Generated
            InputBuilder() {
            }

            @Generated
            public InputBuilder organizationId(String organizationId) {
                this.organizationId = organizationId;
                return this;
            }

            @Generated
            public InputBuilder environmentId(String environmentId) {
                this.environmentId = environmentId;
                return this;
            }

            @Generated
            public InputBuilder isAdmin(boolean isAdmin) {
                this.isAdmin = isAdmin;
                return this;
            }

            @Generated
            public InputBuilder groups(Collection<String> groups) {
                this.groups = groups;
                return this;
            }

            @Generated
            public InputBuilder pageable(Optional<Pageable> pageable) {
                this.pageable = pageable;
                return this;
            }

            @Generated
            public Input build() {
                return new Input(this.organizationId, this.environmentId, this.isAdmin, this.groups, this.pageable);
            }

            @Generated
            public String toString() {
                return "GetIntegrationsUseCase.Input.InputBuilder(organizationId=" + this.organizationId + ", environmentId=" + this.environmentId + ", isAdmin=" + this.isAdmin + ", groups=" + this.groups + ", pageable=" + this.pageable + ")";
            }
        }
    }

    public record Output(Page<IntegrationView> integrations) {
    }
}

