/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.integration.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.environment.crud_service.EnvironmentCrudService;
import io.gravitee.apim.core.environment.model.Environment;
import io.gravitee.apim.core.integration.crud_service.IntegrationCrudService;

@UseCase
public class CheckIntegrationUseCase {
    private final IntegrationCrudService integrationCrudService;
    private final EnvironmentCrudService environmentCrudService;

    public CheckIntegrationUseCase(IntegrationCrudService integrationCrudService, EnvironmentCrudService environmentCrudService) {
        this.integrationCrudService = integrationCrudService;
        this.environmentCrudService = environmentCrudService;
    }

    public Output execute(Input input) {
        return this.integrationCrudService.findById(input.integrationId).filter(integration -> {
            Environment environment = this.environmentCrudService.get(integration.getEnvironmentId());
            return environment.getOrganizationId().equals(input.organizationId);
        }).map(integration -> {
            if (!integration.getProvider().equals(input.provider)) {
                return new Output(false, String.format("Integration [id=%s] does not match. Expected provider [provider=%s]", integration.getId(), integration.getProvider()));
            }
            return new Output(true);
        }).orElse(new Output(false, String.format("Integration [id=%s] not found", input.integrationId)));
    }

    public record Input(String organizationId, String integrationId, String provider) {
        public Input(String integrationId) {
            this(null, integrationId, null);
        }
    }

    public record Output(boolean success, String message) {
        public Output(boolean success) {
            this(success, null);
        }
    }
}

