/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.group.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.group.model.Group;
import io.gravitee.apim.core.group.query_service.GroupQueryService;
import io.gravitee.apim.core.utils.CollectionUtils;
import io.gravitee.apim.core.validation.Validator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DomainService
public class ValidateGroupsDomainService
implements Validator<Input> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ValidateGroupsDomainService.class);
    private final GroupQueryService groupQueryService;

    @Override
    public Validator.Result<Input> validateAndSanitize(Input input) {
        if (CollectionUtils.isEmpty(input.groups())) {
            log.debug("no group to resolve");
            return Validator.Result.ofValue(input);
        }
        log.debug("resolving groups");
        HashSet<String> givenGroups = new HashSet<String>(input.groups());
        List groupsFromIds = this.groupQueryService.findByIds(givenGroups).stream().toList();
        List groupsFromNames = this.groupQueryService.findByNames(input.environmentId(), givenGroups).stream().toList();
        HashSet<String> groupIds = new HashSet<String>(groupsFromIds.stream().map(Group::getId).toList());
        Set groupNames = groupsFromNames.stream().map(Group::getName).collect(Collectors.toSet());
        ArrayList<Validator.Error> errors = new ArrayList<Validator.Error>();
        groupIds.addAll(groupsFromNames.stream().map(Group::getId).toList());
        givenGroups.removeAll(groupIds);
        givenGroups.removeAll(groupNames);
        for (String unknownGroup : givenGroups) {
            errors.add(Validator.Error.warning("Group [%s] could not be found in environment [%s]", unknownGroup, input.environmentId()));
        }
        return Validator.Result.ofBoth(input.sanitized(groupIds), errors);
    }

    @Generated
    public ValidateGroupsDomainService(GroupQueryService groupQueryService) {
        this.groupQueryService = groupQueryService;
    }

    public record Input(String environmentId, Set<String> groups) implements Validator.Input
    {
        Input sanitized(Set<String> sanitizedGroups) {
            return new Input(this.environmentId, sanitizedGroups);
        }
    }
}

