/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.application.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.application.domain_service.ValidateApplicationSettingsDomainService;
import io.gravitee.apim.core.application.model.crd.ApplicationCRDSpec;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.group.domain_service.ValidateGroupsDomainService;
import io.gravitee.apim.core.member.domain_service.ValidateCRDMembersDomainService;
import io.gravitee.apim.core.member.model.MembershipReferenceType;
import io.gravitee.apim.core.validation.Validator;
import io.gravitee.rest.api.model.ApplicationEntity;
import java.util.ArrayList;
import lombok.Generated;

@DomainService
public class ValidateApplicationCRDDomainService
implements Validator<Input> {
    private final ValidateGroupsDomainService groupsValidator;
    private final ValidateCRDMembersDomainService membersValidator;
    private final ValidateApplicationSettingsDomainService settingsValidator;

    @Override
    public Validator.Result<Input> validateAndSanitize(Input input) {
        ArrayList<Validator.Error> errors = new ArrayList<Validator.Error>();
        ApplicationEntity.ApplicationEntityBuilder sanitizedBuilder = input.spec().toBuilder();
        this.groupsValidator.validateAndSanitize(new ValidateGroupsDomainService.Input(input.auditInfo.environmentId(), input.spec().getGroups())).peek(arg_0 -> ValidateApplicationCRDDomainService.lambda$validateAndSanitize$0((ApplicationCRDSpec.ApplicationCRDSpecBuilder)sanitizedBuilder, arg_0), errors::addAll);
        this.membersValidator.validateAndSanitize(new ValidateCRDMembersDomainService.Input(input.auditInfo.organizationId(), input.spec.getId(), MembershipReferenceType.APPLICATION, input.spec.getMembers())).peek(arg_0 -> ValidateApplicationCRDDomainService.lambda$validateAndSanitize$1((ApplicationCRDSpec.ApplicationCRDSpecBuilder)sanitizedBuilder, arg_0), errors::addAll);
        this.settingsValidator.validateAndSanitize(new ValidateApplicationSettingsDomainService.Input(input.auditInfo, input.spec.getId(), input.spec.getSettings())).peek(arg_0 -> ValidateApplicationCRDDomainService.lambda$validateAndSanitize$2((ApplicationCRDSpec.ApplicationCRDSpecBuilder)sanitizedBuilder, arg_0), errors::addAll);
        return Validator.Result.ofBoth(new Input(input.auditInfo(), (ApplicationCRDSpec)sanitizedBuilder.build()), errors);
    }

    @Generated
    public ValidateApplicationCRDDomainService(ValidateGroupsDomainService groupsValidator, ValidateCRDMembersDomainService membersValidator, ValidateApplicationSettingsDomainService settingsValidator) {
        this.groupsValidator = groupsValidator;
        this.membersValidator = membersValidator;
        this.settingsValidator = settingsValidator;
    }

    private static /* synthetic */ void lambda$validateAndSanitize$2(ApplicationCRDSpec.ApplicationCRDSpecBuilder sanitizedBuilder, ValidateApplicationSettingsDomainService.Input sanitized) {
        sanitizedBuilder.settings(sanitized.settings());
    }

    private static /* synthetic */ void lambda$validateAndSanitize$1(ApplicationCRDSpec.ApplicationCRDSpecBuilder sanitizedBuilder, ValidateCRDMembersDomainService.Input sanitized) {
        sanitizedBuilder.members(sanitized.members());
    }

    private static /* synthetic */ void lambda$validateAndSanitize$0(ApplicationCRDSpec.ApplicationCRDSpecBuilder sanitizedBuilder, ValidateGroupsDomainService.Input sanitized) {
        sanitizedBuilder.groups(sanitized.groups());
    }

    public record Input(AuditInfo auditInfo, ApplicationCRDSpec spec) implements Validator.Input
    {
    }
}

