/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.impl.validation;

import io.gravitee.definition.model.v4.ApiType;
import io.gravitee.definition.model.v4.flow.Flow;
import io.gravitee.definition.model.v4.flow.selector.ChannelSelector;
import io.gravitee.definition.model.v4.flow.selector.SelectorType;
import io.gravitee.rest.api.model.platform.plugin.PlatformPluginEntity;
import io.gravitee.rest.api.service.PolicyService;
import io.gravitee.rest.api.service.impl.TransactionalService;
import io.gravitee.rest.api.service.v4.EntrypointConnectorPluginService;
import io.gravitee.rest.api.service.v4.exception.FlowSelectorsDuplicatedException;
import io.gravitee.rest.api.service.v4.exception.FlowSelectorsEntrypointInvalidException;
import io.gravitee.rest.api.service.v4.exception.FlowSelectorsInvalidException;
import io.gravitee.rest.api.service.v4.validation.FlowValidationService;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
@Deprecated
public class FlowValidationServiceImpl
extends TransactionalService
implements FlowValidationService {
    private final PolicyService policyService;
    private final EntrypointConnectorPluginService entrypointConnectorPluginService;

    @Override
    public List<Flow> validateAndSanitize(ApiType apiType, List<Flow> flows) {
        if (flows != null) {
            flows.forEach(flow -> {
                this.checkDuplicatedSelectors((Flow)flow);
                this.checkSelectorsForType(apiType, (Flow)flow);
                this.checkPolicyConfiguration((Flow)flow);
            });
        }
        return flows;
    }

    private void checkSelectorsForType(ApiType apiType, Flow flow) {
        if (flow.getSelectors() != null) {
            if (ApiType.PROXY == apiType) {
                Set<String> invalidSelectors = flow.getSelectors().stream().filter(selector -> selector.getType() != SelectorType.HTTP && selector.getType() != SelectorType.CONDITION).map(selector -> selector.getType().getLabel()).collect(Collectors.toSet());
                if (!invalidSelectors.isEmpty()) {
                    throw new FlowSelectorsInvalidException(flow.getName(), apiType, invalidSelectors);
                }
            } else if (ApiType.MESSAGE == apiType) {
                Set<String> invalidSelectors = flow.getSelectors().stream().filter(selector -> selector.getType() != SelectorType.CHANNEL && selector.getType() != SelectorType.CONDITION).map(selector -> selector.getType().getLabel()).collect(Collectors.toSet());
                if (!invalidSelectors.isEmpty()) {
                    throw new FlowSelectorsInvalidException(flow.getName(), apiType, invalidSelectors);
                }
                this.checkChannelAsyncEntrypoint(flow);
            }
        }
    }

    private void checkChannelAsyncEntrypoint(Flow flow) {
        ChannelSelector channelSelector;
        Optional<ChannelSelector> channelSelectorOpt = flow.getSelectors().stream().filter(selector -> selector.getType() == SelectorType.CHANNEL).map(ChannelSelector.class::cast).findFirst();
        if (channelSelectorOpt.isPresent() && (channelSelector = channelSelectorOpt.get()).getEntrypoints() != null) {
            Set asyncEntrypoints = this.entrypointConnectorPluginService.findBySupportedApi(ApiType.MESSAGE).stream().map(PlatformPluginEntity::getId).collect(Collectors.toSet());
            Set<String> invalidEntrypoints = channelSelector.getEntrypoints().stream().filter(entrypointId -> !asyncEntrypoints.contains(entrypointId)).collect(Collectors.toSet());
            if (!invalidEntrypoints.isEmpty()) {
                throw new FlowSelectorsEntrypointInvalidException(flow.getName(), invalidEntrypoints);
            }
        }
    }

    private void checkPolicyConfiguration(Flow flow) {
        Stream.of(flow.getRequest(), flow.getResponse(), flow.getSubscribe(), flow.getPublish()).filter(Objects::nonNull).flatMap(Collection::stream).filter(step -> step != null && step.getPolicy() != null && step.getConfiguration() != null).forEach(step -> step.setConfiguration(this.policyService.validatePolicyConfiguration(step.getPolicy(), step.getConfiguration())));
    }

    private void checkDuplicatedSelectors(Flow flow) {
        if (flow.getSelectors() != null) {
            HashSet seenSelectors = new HashSet();
            Set<String> duplicatedSelectors = flow.getSelectors().stream().filter(e -> !seenSelectors.add(e)).map(selector -> selector.getType().getLabel()).collect(Collectors.toSet());
            if (!duplicatedSelectors.isEmpty()) {
                throw new FlowSelectorsDuplicatedException(flow.getName(), duplicatedSelectors);
            }
        }
    }

    @Generated
    public FlowValidationServiceImpl(PolicyService policyService, EntrypointConnectorPluginService entrypointConnectorPluginService) {
        this.policyService = policyService;
        this.entrypointConnectorPluginService = entrypointConnectorPluginService;
    }
}

