/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.plan.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.plan.domain_service.CreatePlanDomainService;
import io.gravitee.apim.core.plan.exception.PlanInvalidException;
import io.gravitee.apim.core.plan.model.Plan;
import io.gravitee.apim.core.plan.model.PlanWithFlows;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.v4.flow.Flow;
import io.gravitee.definition.model.v4.plan.PlanMode;
import io.gravitee.definition.model.v4.plan.PlanStatus;
import java.util.List;
import lombok.Generated;

@UseCase
public class CreatePlanUseCase {
    private final CreatePlanDomainService createPlanDomainService;
    private final ApiCrudService apiCrudService;

    public Output execute(Input input) {
        Api api = this.apiCrudService.get(input.apiId());
        if (api.getDefinitionVersion() == DefinitionVersion.FEDERATED) {
            throw new PlanInvalidException("Can't manually create Federated Plan");
        }
        Plan plan = input.plan;
        plan.setEnvironmentId(api.getEnvironmentId());
        plan.setApiId(input.apiId);
        plan.setType(Plan.PlanType.API);
        plan.setPlanStatus(PlanStatus.STAGING);
        if (plan.getPlanMode() == null) {
            plan.setPlanMode(PlanMode.STANDARD);
        }
        PlanWithFlows createdPlan = this.createPlanDomainService.create(plan, input.flows == null ? List.of() : input.flows, api, input.auditInfo);
        return new Output(createdPlan.getId(), createdPlan);
    }

    @Generated
    public CreatePlanUseCase(CreatePlanDomainService createPlanDomainService, ApiCrudService apiCrudService) {
        this.createPlanDomainService = createPlanDomainService;
        this.apiCrudService = apiCrudService;
    }

    public record Input(String apiId, Plan plan, List<Flow> flows, AuditInfo auditInfo) {
    }

    public record Output(String id, PlanWithFlows plan) {
    }
}

