/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.apim.core.api.domain_service.ApiMetadataDomainService;
import io.gravitee.apim.core.api.domain_service.ValidateApiMetadataDomainService;
import io.gravitee.apim.core.api.exception.ApiNotFoundException;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.api.model.ApiMetadata;
import io.gravitee.apim.core.api.model.NewApiMetadata;
import io.gravitee.apim.core.audit.model.AuditInfo;

@UseCase
public class CreateApiMetadataUseCase {
    private final ValidateApiMetadataDomainService validateApiMetadataDomainService;
    private final ApiMetadataDomainService apiMetadataDomainService;
    private final ApiCrudService apiCrudService;

    public CreateApiMetadataUseCase(ValidateApiMetadataDomainService validateApiMetadataDomainService, ApiMetadataDomainService apiMetadataDomainService, ApiCrudService apiCrudService) {
        this.validateApiMetadataDomainService = validateApiMetadataDomainService;
        this.apiMetadataDomainService = apiMetadataDomainService;
        this.apiCrudService = apiCrudService;
    }

    public Output execute(Input input) {
        String apiId = input.newApiMetadata.getApiId();
        Api api = this.apiCrudService.get(apiId);
        if (!api.getEnvironmentId().equals(input.auditInfo().environmentId())) {
            throw new ApiNotFoundException(apiId);
        }
        this.validateApiMetadataDomainService.validateUniqueKey(apiId, input.newApiMetadata.getKey());
        this.validateApiMetadataDomainService.validateUniqueName(apiId, input.newApiMetadata.getName());
        this.validateApiMetadataDomainService.validateValueByFormat(api, input.auditInfo().organizationId(), input.newApiMetadata.getValue(), input.newApiMetadata.getFormat());
        return new Output(this.apiMetadataDomainService.create(input.newApiMetadata(), input.auditInfo()));
    }

    public record Input(NewApiMetadata newApiMetadata, AuditInfo auditInfo) {
    }

    public record Output(ApiMetadata created) {
    }
}

