/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.theme.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.theme.crud_service.ThemeCrudService;
import io.gravitee.apim.core.theme.model.Theme;
import io.gravitee.apim.core.theme.query_service.ThemeQueryService;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;

@DomainService
public class CurrentThemeDomainService {
    private final ThemeQueryService themeQueryService;
    private final ThemeCrudService themeCrudService;

    public void disablePreviousEnabledTheme(Theme newCurrentTheme) {
        Set<Theme> themes = this.themeQueryService.findByThemeTypeAndEnvironmentId(newCurrentTheme.getType(), newCurrentTheme.getReferenceId());
        if (themes.isEmpty()) {
            return;
        }
        themes.stream().filter(theme -> !Objects.equals(theme.getId(), newCurrentTheme.getId()) && Objects.equals(theme.isEnabled(), true)).forEach(theme -> {
            theme.setEnabled(false);
            theme.setUpdatedAt(ZonedDateTime.now());
            this.themeCrudService.update((Theme)theme);
        });
    }

    @Generated
    public CurrentThemeDomainService(ThemeQueryService themeQueryService, ThemeCrudService themeCrudService) {
        this.themeQueryService = themeQueryService;
        this.themeCrudService = themeCrudService;
    }
}

