/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.integration.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.api.model.ApiFieldFilter;
import io.gravitee.apim.core.api.model.ApiSearchCriteria;
import io.gravitee.apim.core.api.model.factory.ApiModelFactory;
import io.gravitee.apim.core.api.query_service.ApiQueryService;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.exception.NotAllowedDomainException;
import io.gravitee.apim.core.integration.crud_service.IntegrationCrudService;
import io.gravitee.apim.core.integration.exception.IntegrationNotFoundException;
import io.gravitee.apim.core.integration.service_provider.IntegrationAgent;
import io.gravitee.apim.core.license.domain_service.LicenseDomainService;
import io.reactivex.rxjava3.core.Single;
import java.util.List;

@UseCase
public class PreviewNewIntegrationApisUseCase {
    private final IntegrationAgent integrationAgent;
    private final LicenseDomainService licenseDomainService;
    private final ApiQueryService apiQueryService;
    private final IntegrationCrudService integrationCrudService;

    public PreviewNewIntegrationApisUseCase(IntegrationAgent integrationAgent, LicenseDomainService licenseDomainService, ApiQueryService apiQueryService, IntegrationCrudService integrationCrudService) {
        this.integrationAgent = integrationAgent;
        this.licenseDomainService = licenseDomainService;
        this.apiQueryService = apiQueryService;
        this.integrationCrudService = integrationCrudService;
    }

    public Output execute(Input input) {
        if (!this.licenseDomainService.isFederationFeatureAllowed(input.auditInfo.organizationId())) {
            throw NotAllowedDomainException.noLicenseForFederation();
        }
        String integrationId = input.integrationId;
        List<String> alreadyIngestedApisIds = this.apiQueryService.search(ApiSearchCriteria.builder().integrationId(input.integrationId).build(), null, ApiFieldFilter.builder().pictureExcluded(true).definitionExcluded(true).build()).map(Api::getId).toList();
        Long newApisCount = (Long)Single.fromCallable(() -> this.integrationCrudService.findById(integrationId).filter(integration -> integration.getEnvironmentId().equals(input.auditInfo.environmentId())).orElseThrow(() -> new IntegrationNotFoundException(integrationId))).flatMapPublisher(integration -> this.integrationAgent.discoverApis(integrationId).filter(discoveredApi -> {
            String discoveredApiId = ApiModelFactory.generateFederatedApiId(discoveredApi, integration);
            return !alreadyIngestedApisIds.contains(discoveredApiId);
        })).count().blockingGet();
        return new Output(newApisCount);
    }

    public record Input(String integrationId, AuditInfo auditInfo) {
    }

    public record Output(Long newApisCount) {
    }
}

