/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.policy.domain_service.PolicyValidationDomainService;
import io.gravitee.definition.model.Api;
import io.gravitee.definition.model.Plan;
import io.gravitee.definition.model.Rule;
import io.gravitee.definition.model.flow.Step;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Stream;
import lombok.Generated;

@DomainService
public class ApiPolicyValidatorDomainService {
    private final PolicyValidationDomainService policyValidationDomainService;

    public void checkPolicyConfigurations(Api api, Set<Plan> plans) {
        if (api == null) {
            throw new IllegalStateException("Api should not be null");
        }
        switch (api.getDefinitionVersion()) {
            case V1: {
                this.validatePathConfigurations(api, plans);
                break;
            }
            case V2: {
                this.validateFlowConfigurations(api, plans);
                break;
            }
            case V4: {
                throw new IllegalStateException("Cannot validate V4 api");
            }
        }
    }

    private void validatePathConfigurations(Api api, Set<Plan> plans) {
        Stream<Rule> pathsStream = ApiPolicyValidatorDomainService.getRulesStream(api, plans);
        if (pathsStream == null) {
            return;
        }
        pathsStream.filter(Rule::isEnabled).map(Rule::getPolicy).forEach(policy -> policy.setConfiguration(this.policyValidationDomainService.validateAndSanitizeConfiguration(policy.getName(), policy.getConfiguration())));
    }

    private static Stream<Rule> getRulesStream(Api api, Set<Plan> plans) {
        Stream pathsStream = null;
        if (api.getPaths() != null) {
            pathsStream = api.getPaths().values().stream().flatMap(Collection::stream);
        }
        if (plans != null && pathsStream != null) {
            pathsStream = Stream.concat(pathsStream, plans.stream().flatMap(plan -> plan.getPaths() != null ? plan.getPaths().values().stream().flatMap(Collection::stream) : Stream.empty()));
        }
        return pathsStream;
    }

    private void validateFlowConfigurations(Api api, Set<Plan> plans) {
        Stream<Step> flowsStream = ApiPolicyValidatorDomainService.getFlowsStream(api, plans);
        if (flowsStream == null) {
            return;
        }
        flowsStream.filter(Step::isEnabled).forEach(step -> step.setConfiguration(this.policyValidationDomainService.validateAndSanitizeConfiguration(step.getPolicy(), step.getConfiguration())));
    }

    private static Stream<Step> getFlowsStream(Api api, Set<Plan> plans) {
        Stream flowsStream = null;
        if (api.getFlows() != null) {
            flowsStream = api.getFlows().stream();
        }
        if (plans != null && flowsStream != null) {
            flowsStream = Stream.concat(flowsStream, plans.stream().flatMap(plan -> plan.getFlows() != null ? plan.getFlows().stream() : Stream.empty()));
        }
        if (flowsStream == null) {
            return null;
        }
        return flowsStream.flatMap(flow -> Stream.concat(flow.getPre() != null ? flow.getPre().stream() : Stream.empty(), flow.getPost() != null ? flow.getPost().stream() : Stream.empty()));
    }

    @Generated
    public ApiPolicyValidatorDomainService(PolicyValidationDomainService policyValidationDomainService) {
        this.policyValidationDomainService = policyValidationDomainService;
    }
}

