/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.api.model.ApiMetadata;
import io.gravitee.apim.core.api.query_service.ApiMetadataQueryService;
import io.gravitee.apim.core.documentation.model.ApiFreemarkerTemplate;
import io.gravitee.apim.core.exception.TechnicalDomainException;
import io.gravitee.apim.core.membership.model.PrimaryOwnerEntity;
import io.gravitee.apim.core.template.TemplateProcessor;
import io.gravitee.apim.core.template.TemplateProcessorException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DomainService
public class ApiMetadataDecoderDomainService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiMetadataDecoderDomainService.class);
    private final ApiMetadataQueryService metadataQueryService;
    private final TemplateProcessor templateProcessor;

    public ApiMetadataDecoderDomainService(ApiMetadataQueryService metadataQueryService, TemplateProcessor templateProcessor) {
        this.metadataQueryService = metadataQueryService;
        this.templateProcessor = templateProcessor;
    }

    public Map<String, String> decodeMetadata(String environmentId, String apiId, ApiMetadataDecodeContext context) {
        Map<String, String> metadata = this.metadataQueryService.findApiMetadata(environmentId, apiId).entrySet().stream().filter(entry -> ((ApiMetadata)entry.getValue()).getValue() != null).map(entry -> Map.entry((String)entry.getKey(), ((ApiMetadata)entry.getValue()).getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return this.decode(metadata, context);
    }

    public String decodeMetadataValue(String value, ApiMetadataDecodeContext context) {
        try {
            return this.templateProcessor.processInlineTemplate(value, Collections.singletonMap("api", context));
        }
        catch (TemplateProcessorException e) {
            log.warn("Error while validating template '{}' from reader:\n{}", (Object)e.getTemplate(), (Object)e.getMessage());
            return value;
        }
    }

    private Map<String, String> decode(Map<String, String> metadata, ApiMetadataDecodeContext context) {
        if (metadata.isEmpty()) {
            return metadata;
        }
        try {
            String decodedValue = this.templateProcessor.processInlineTemplate(metadata.toString(), Collections.singletonMap("api", context));
            return Arrays.stream(decodedValue.substring(1, decodedValue.length() - 1).split(", ")).map(entry -> entry.split("=", 2)).collect(Collectors.toMap(entry -> entry[0], entry -> ((String[])entry).length > 1 ? entry[1] : ""));
        }
        catch (TemplateProcessorException e) {
            log.warn("Error while creating template '{}' from reader:\n{}", (Object)e.getTemplate(), (Object)e.getMessage());
            return metadata;
        }
        catch (Exception ex) {
            throw new TechnicalDomainException("An error occurs while evaluating API metadata", ex);
        }
    }

    public static class ApiMetadataDecodeContext
    extends ApiFreemarkerTemplate {
        public ApiMetadataDecodeContext(Api api, Map<String, String> metadata, PrimaryOwnerEntity primaryOwner) {
            super(api, metadata, primaryOwner);
        }

        @Generated
        protected ApiMetadataDecodeContext(ApiMetadataDecodeContextBuilder<?, ?> b) {
            super(b);
        }

        @Generated
        public static ApiMetadataDecodeContextBuilder<?, ?> builder() {
            return new ApiMetadataDecodeContextBuilderImpl();
        }

        @Generated
        private static final class ApiMetadataDecodeContextBuilderImpl
        extends ApiMetadataDecodeContextBuilder<ApiMetadataDecodeContext, ApiMetadataDecodeContextBuilderImpl> {
            @Generated
            private ApiMetadataDecodeContextBuilderImpl() {
            }

            @Override
            @Generated
            protected ApiMetadataDecodeContextBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public ApiMetadataDecodeContext build() {
                return new ApiMetadataDecodeContext(this);
            }
        }

        @Generated
        public static abstract class ApiMetadataDecodeContextBuilder<C extends ApiMetadataDecodeContext, B extends ApiMetadataDecodeContextBuilder<C, B>>
        extends ApiFreemarkerTemplate.ApiFreemarkerTemplateBuilder<C, B> {
            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Override
            @Generated
            public String toString() {
                return "ApiMetadataDecoderDomainService.ApiMetadataDecodeContext.ApiMetadataDecodeContextBuilder(super=" + super.toString() + ")";
            }
        }
    }
}

