/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.api.domain_service.OAIDomainService;
import io.gravitee.apim.core.api.model.import_definition.ImportDefinition;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.documentation.model.Page;
import io.gravitee.apim.core.group.model.Group;
import io.gravitee.apim.core.group.query_service.GroupQueryService;
import io.gravitee.apim.core.plugin.domain_service.EndpointConnectorPluginDomainService;
import io.gravitee.apim.core.tag.model.Tag;
import io.gravitee.apim.core.tag.query_service.TagQueryService;
import io.gravitee.definition.model.v4.endpointgroup.EndpointGroup;
import io.gravitee.rest.api.model.ImportSwaggerDescriptorEntity;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@UseCase
public class OAIToImportApiUseCase {
    protected static final String DEFAULT_IMPORT_PAGE_NAME = "Swagger";
    private final OAIDomainService oaiDomainService;
    private final GroupQueryService groupQueryService;
    private final TagQueryService tagsQueryService;
    private final EndpointConnectorPluginDomainService endpointConnectorPluginService;

    public OAIToImportApiUseCase(OAIDomainService oaiDomainService, GroupQueryService groupQueryService, TagQueryService tagsQueryService, EndpointConnectorPluginDomainService endpointConnectorPluginService) {
        this.oaiDomainService = oaiDomainService;
        this.groupQueryService = groupQueryService;
        this.tagsQueryService = tagsQueryService;
        this.endpointConnectorPluginService = endpointConnectorPluginService;
    }

    public Output execute(Input input) {
        String organizationId = input.auditInfo.organizationId();
        String environmentId = input.auditInfo.environmentId();
        ImportDefinition importDefinition = this.oaiDomainService.convert(organizationId, environmentId, input.importSwaggerDescriptor);
        boolean withDocumentation = input.importSwaggerDescriptor.isWithDocumentation();
        if (importDefinition != null) {
            ImportDefinition importWithEndpointGroupsSharedConfiguration = this.addEndpointGroupSharedConfiguration(importDefinition);
            ImportDefinition importWithGroups = this.replaceGroupNamesWithIds(environmentId, importWithEndpointGroupsSharedConfiguration);
            ImportDefinition importWithTags = this.replaceTagsNamesWithIds(organizationId, importWithGroups);
            ImportDefinition importWithDocumentation = this.addOAIDocumentation(withDocumentation, input.importSwaggerDescriptor.getPayload(), importWithTags);
            return new Output(importWithDocumentation);
        }
        return null;
    }

    private ImportDefinition addEndpointGroupSharedConfiguration(ImportDefinition importDefinition) {
        String sharedConfiguration = this.endpointConnectorPluginService.getSharedConfigurationSchema("http-proxy");
        List<EndpointGroup> endpointGroups = importDefinition.getApiExport().getEndpointGroups();
        if (endpointGroups == null || endpointGroups.isEmpty()) {
            return importDefinition;
        }
        return importDefinition.toBuilder().apiExport(importDefinition.getApiExport().toBuilder().endpointGroups(endpointGroups.stream().map(endpointGroup -> endpointGroup.toBuilder().sharedConfiguration(sharedConfiguration).build()).toList()).build()).build();
    }

    private ImportDefinition replaceGroupNamesWithIds(String environmentId, ImportDefinition importDefinition) {
        Set<String> groups = importDefinition.getApiExport().getGroups();
        if (groups == null || groups.isEmpty()) {
            return importDefinition;
        }
        return importDefinition.toBuilder().apiExport(importDefinition.getApiExport().toBuilder().groups(groups.stream().flatMap(group -> this.groupQueryService.findByNames(environmentId, Set.of(group)).stream()).map(Group::getId).collect(Collectors.toSet())).build()).build();
    }

    private ImportDefinition replaceTagsNamesWithIds(String organizationId, ImportDefinition importDefinition) {
        if (importDefinition.getApiExport() == null || importDefinition.getApiExport().getTags() == null || importDefinition.getApiExport().getTags().isEmpty()) {
            return importDefinition;
        }
        return importDefinition.toBuilder().apiExport(importDefinition.getApiExport().toBuilder().tags(importDefinition.getApiExport().getTags().stream().flatMap(group -> this.tagsQueryService.findByName(organizationId, (String)group).stream()).map(Tag::getId).collect(Collectors.toSet())).build()).build();
    }

    private ImportDefinition addOAIDocumentation(boolean withDocumentation, String payload, ImportDefinition importWithTags) {
        if (!withDocumentation) {
            return importWithTags;
        }
        Page page = Page.builder().name(DEFAULT_IMPORT_PAGE_NAME).type(Page.Type.SWAGGER).homepage(false).content(payload).referenceType(Page.ReferenceType.API).published(true).visibility(Page.Visibility.PUBLIC).build();
        return importWithTags.toBuilder().pages(List.of(page)).build();
    }

    public record Input(ImportSwaggerDescriptorEntity importSwaggerDescriptor, AuditInfo auditInfo) {
    }

    public record Output(ImportDefinition importDefinition) {
    }
}

