/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.domain_service.documentation;

import io.gravitee.apim.core.documentation.domain_service.PageSourceDomainService;
import io.gravitee.apim.core.documentation.model.Page;
import io.gravitee.apim.core.documentation.model.PageSource;
import io.gravitee.apim.core.exception.TechnicalDomainException;
import io.gravitee.fetcher.api.Fetcher;
import io.gravitee.fetcher.api.FetcherConfiguration;
import io.gravitee.fetcher.api.FetcherException;
import io.gravitee.fetcher.api.Resource;
import io.gravitee.plugin.core.api.PluginManager;
import io.gravitee.plugin.fetcher.FetcherPlugin;
import io.gravitee.rest.api.fetcher.FetcherConfigurationFactory;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Optional;
import lombok.Generated;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class PageSourceDomainServiceImpl
implements PageSourceDomainService {
    private final FetcherConfigurationFactory fetcherConfigurationFactory;
    private final PluginManager<FetcherPlugin<?>> pluginManager;
    private final ApplicationContext applicationContext;

    @Override
    public void setContentFromSource(Page page) {
        this.loadFetcher(page).ifPresentOrElse(fetcher -> this.fetchContent((Fetcher)fetcher, page), () -> page.setUseAutoFetch(false));
    }

    private void fetchContent(Fetcher fetcher, Page page) {
        page.setContent(this.readContent(fetcher, page.getSource()));
        page.setUseAutoFetch(fetcher.getConfiguration().isAutoFetch());
    }

    private String readContent(Fetcher fetcher, PageSource source) {
        try {
            Resource resource = fetcher.fetch();
            InputStream content = resource.getContent();
            return new String(content.readAllBytes(), Charset.defaultCharset());
        }
        catch (FetcherException | IOException e) {
            throw new TechnicalDomainException("unable to fetch content with configuration " + source.getConfiguration());
        }
    }

    private Optional<Fetcher> loadFetcher(Page page) {
        return Optional.ofNullable(page.getSource()).flatMap(this::loadPlugin).map(plugin -> this.buildFetcher((FetcherPlugin<?>)plugin, page.getSource()));
    }

    private Optional<FetcherPlugin<?>> loadPlugin(PageSource source) {
        return Optional.ofNullable((FetcherPlugin)this.pluginManager.get(source.getType()));
    }

    private Fetcher buildFetcher(FetcherPlugin<?> plugin, PageSource source) {
        try {
            ClassLoader classLoader = plugin.fetcher().getClassLoader();
            Class<?> configClass = classLoader.loadClass(plugin.configuration().getName());
            FetcherConfiguration config = this.fetcherConfigurationFactory.create(configClass, source.getConfiguration());
            Class<?> fetcherClass = classLoader.loadClass(plugin.clazz());
            Fetcher fetcher = (Fetcher)fetcherClass.getConstructor(configClass).newInstance(config);
            this.applicationContext.getAutowireCapableBeanFactory().autowireBean((Object)fetcher);
            return fetcher;
        }
        catch (Exception e) {
            throw new TechnicalDomainException("unable to build fetcher instance", e);
        }
    }

    @Generated
    public PageSourceDomainServiceImpl(FetcherConfigurationFactory fetcherConfigurationFactory, PluginManager<FetcherPlugin<?>> pluginManager, ApplicationContext applicationContext) {
        this.fetcherConfigurationFactory = fetcherConfigurationFactory;
        this.pluginManager = pluginManager;
        this.applicationContext = applicationContext;
    }
}

