/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.cockpit.command.handler;

import io.gravitee.apim.core.access_point.crud_service.AccessPointCrudService;
import io.gravitee.apim.core.access_point.model.AccessPoint;
import io.gravitee.cockpit.api.command.v1.CockpitCommandType;
import io.gravitee.cockpit.api.command.v1.organization.DisableOrganizationCommand;
import io.gravitee.cockpit.api.command.v1.organization.DisableOrganizationCommandPayload;
import io.gravitee.cockpit.api.command.v1.organization.DisableOrganizationReply;
import io.gravitee.exchange.api.command.CommandHandler;
import io.gravitee.rest.api.model.OrganizationEntity;
import io.gravitee.rest.api.model.configuration.identity.IdentityProviderActivationReferenceType;
import io.gravitee.rest.api.service.OrganizationService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.configuration.identity.IdentityProviderActivationService;
import io.reactivex.rxjava3.core.Single;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DisableOrganizationCommandHandler
implements CommandHandler<DisableOrganizationCommand, DisableOrganizationReply> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DisableOrganizationCommandHandler.class);
    private final OrganizationService organizationService;
    private final AccessPointCrudService accessPointService;
    private final IdentityProviderActivationService identityProviderActivationService;

    public DisableOrganizationCommandHandler(OrganizationService organizationService, AccessPointCrudService accessPointService, IdentityProviderActivationService identityProviderActivationService) {
        this.organizationService = organizationService;
        this.accessPointService = accessPointService;
        this.identityProviderActivationService = identityProviderActivationService;
    }

    public String supportType() {
        return CockpitCommandType.DISABLE_ORGANIZATION.name();
    }

    public Single<DisableOrganizationReply> handle(DisableOrganizationCommand command) {
        DisableOrganizationCommandPayload organizationPayload = (DisableOrganizationCommandPayload)command.getPayload();
        try {
            OrganizationEntity organization = this.organizationService.findByCockpitId(organizationPayload.cockpitId());
            this.accessPointService.deleteAccessPoints(AccessPoint.ReferenceType.ORGANIZATION, organization.getId());
            ExecutionContext context = new ExecutionContext(organization.getId());
            this.identityProviderActivationService.removeAllIdpsFromTarget(context, new IdentityProviderActivationService.ActivationTarget(organization.getId(), IdentityProviderActivationReferenceType.ORGANIZATION));
            log.info("Organization [{}] with id [{}] has been disabled.", (Object)organization.getName(), (Object)organization.getId());
            return Single.just((Object)new DisableOrganizationReply(command.getId()));
        }
        catch (Exception e) {
            String errorDetails = "Error occurred when disabling organization [%s] with id [%s].".formatted(organizationPayload.name(), organizationPayload.id());
            log.error(errorDetails, (Throwable)e);
            return Single.just((Object)new DisableOrganizationReply(command.getId(), errorDetails));
        }
    }
}

