/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.query_service.integration;

import io.gravitee.apim.core.integration.model.Integration;
import io.gravitee.apim.core.integration.query_service.IntegrationQueryService;
import io.gravitee.apim.infra.adapter.IntegrationAdapter;
import io.gravitee.common.data.domain.Page;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.IntegrationRepository;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.AbstractService;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class IntegrationQueryServiceImpl
extends AbstractService
implements IntegrationQueryService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IntegrationQueryServiceImpl.class);
    private final IntegrationRepository integrationRepository;

    public IntegrationQueryServiceImpl(@Lazy IntegrationRepository integrationRepository) {
        this.integrationRepository = integrationRepository;
    }

    @Override
    public Page<Integration> findByEnvironment(String environmentId, Pageable pageable) {
        try {
            Page integrationsPage = this.integrationRepository.findAllByEnvironment(environmentId, IntegrationQueryServiceImpl.convert(pageable));
            List integrationList = integrationsPage.getContent().stream().map(IntegrationAdapter.INSTANCE::toEntity).collect(Collectors.toList());
            return new Page(integrationList, integrationsPage.getPageNumber(), (int)integrationsPage.getPageElements(), integrationsPage.getTotalElements());
        }
        catch (TechnicalException e) {
            log.error("An error occurred while finding Integrations by environment", (Throwable)e);
            throw new TechnicalManagementException("An error occurred while finding Integrations by environment id: " + environmentId, e);
        }
    }
}

