/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.query_service.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.api.query_service.ApiEventQueryService;
import io.gravitee.apim.infra.adapter.ApiAdapter;
import io.gravitee.apim.infra.adapter.GraviteeJacksonMapper;
import io.gravitee.repository.management.api.EventLatestRepository;
import io.gravitee.repository.management.api.search.EventCriteria;
import io.gravitee.repository.management.model.Event;
import io.gravitee.repository.management.model.EventType;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class ApiEventQueryServiceImpl
implements ApiEventQueryService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiEventQueryServiceImpl.class);
    private final EventLatestRepository eventLatestRepository;
    private static final ApiAdapter apiAdapter = ApiAdapter.INSTANCE;

    public ApiEventQueryServiceImpl(@Lazy EventLatestRepository eventLatestRepository) {
        this.eventLatestRepository = eventLatestRepository;
    }

    @Override
    public Optional<Api> findLastPublishedApi(String organizationId, String environmentId, String apiId) {
        Optional latestEvent = this.eventLatestRepository.search(ApiEventQueryServiceImpl.buildCriteria(environmentId, apiId), Event.EventProperties.API_ID, Long.valueOf(0L), Long.valueOf(1L)).stream().findFirst();
        if (latestEvent.isEmpty()) {
            return Optional.empty();
        }
        return latestEvent.flatMap(event -> {
            try {
                io.gravitee.repository.management.model.Api api = (io.gravitee.repository.management.model.Api)GraviteeJacksonMapper.getInstance().readValue(event.getPayload(), io.gravitee.repository.management.model.Api.class);
                return Optional.ofNullable(apiAdapter.toCoreModel(api));
            }
            catch (JsonProcessingException e) {
                log.warn("Impossible to deserialize event payload for api: {}", (Object)apiId);
                return Optional.empty();
            }
        });
    }

    private static EventCriteria buildCriteria(String environmentId, String apiId) {
        return EventCriteria.builder().environment(environmentId).types(Set.of(EventType.PUBLISH_API)).property(Event.EventProperties.API_ID.getValue(), (Object)apiId).build();
    }
}

