/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.plugin.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.plugin.domain_service.PluginFilterByLicenseDomainService;
import io.gravitee.apim.core.plugin.model.ConnectorPlugin;
import io.gravitee.apim.core.plugin.query_service.EndpointPluginQueryService;
import java.util.Set;

@UseCase
public class GetEndpointPluginsUseCase {
    private final EndpointPluginQueryService endpointPluginQueryService;
    private final PluginFilterByLicenseDomainService licenseChecker;

    public GetEndpointPluginsUseCase(EndpointPluginQueryService endpointPluginQueryService, PluginFilterByLicenseDomainService licenseChecker) {
        this.endpointPluginQueryService = endpointPluginQueryService;
        this.licenseChecker = licenseChecker;
    }

    public Output getEndpointPluginsByOrganization(Input input) {
        return new Output(this.licenseChecker.setPluginDeployedStatusDependingOnLicense(this.endpointPluginQueryService.findAll(), input.organizationId));
    }

    public record Output(Set<ConnectorPlugin> plugins) {
    }

    public record Input(String organizationId) {
    }
}

