/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.core.membership.model.PrimaryOwnerEntity;
import io.gravitee.apim.infra.adapter.ApiAdapter;
import io.gravitee.repository.management.model.Api;
import io.gravitee.rest.api.model.context.IntegrationContext;
import io.gravitee.rest.api.model.context.KubernetesContext;
import io.gravitee.rest.api.model.context.ManagementContext;
import io.gravitee.rest.api.model.context.OriginContext;
import io.gravitee.rest.api.model.federation.FederatedApiEntity;

public abstract class ApiAdapterDecorator
implements ApiAdapter {
    private final ApiAdapter delegate;

    public ApiAdapterDecorator(ApiAdapter delegate) {
        this.delegate = delegate;
    }

    @Override
    public Api toRepository(io.gravitee.apim.core.api.model.Api source) {
        Api api = this.delegate.toRepository(source);
        switch (source.getOriginContext().getOrigin()) {
            case MANAGEMENT: {
                api.setOrigin(OriginContext.Origin.MANAGEMENT.name().toLowerCase());
                break;
            }
            case KUBERNETES: {
                api.setOrigin(OriginContext.Origin.KUBERNETES.name().toLowerCase());
                api.setMode(((KubernetesContext)source.getOriginContext()).getMode().name().toLowerCase());
                api.setSyncFrom(((KubernetesContext)source.getOriginContext()).getSyncFrom());
                break;
            }
            case INTEGRATION: {
                api.setOrigin(OriginContext.Origin.INTEGRATION.name().toLowerCase());
                api.setIntegrationId(((IntegrationContext)source.getOriginContext()).getIntegrationId());
            }
        }
        return api;
    }

    @Override
    public io.gravitee.apim.core.api.model.Api toCoreModel(Api source) {
        io.gravitee.apim.core.api.model.Api api = this.delegate.toCoreModel(source);
        api.setOriginContext(ApiAdapterDecorator.toOriginContext(source));
        return api;
    }

    @Override
    public FederatedApiEntity toFederatedApiEntity(Api source, PrimaryOwnerEntity primaryOwnerEntity) {
        FederatedApiEntity api = this.delegate.toFederatedApiEntity(source, primaryOwnerEntity);
        api.setOriginContext(ApiAdapterDecorator.toOriginContext(source));
        api.setCategories(source.getCategories());
        return api;
    }

    public static OriginContext toOriginContext(Api source) {
        OriginContext.Origin origin;
        try {
            origin = source.getOrigin() == null ? OriginContext.Origin.MANAGEMENT : OriginContext.Origin.valueOf((String)source.getOrigin().toUpperCase());
        }
        catch (IllegalArgumentException e) {
            origin = OriginContext.Origin.MANAGEMENT;
        }
        return switch (origin) {
            default -> throw new IncompatibleClassChangeError();
            case OriginContext.Origin.MANAGEMENT -> new ManagementContext();
            case OriginContext.Origin.KUBERNETES -> new KubernetesContext(source.getMode() != null ? KubernetesContext.Mode.valueOf((String)source.getMode().toUpperCase()) : KubernetesContext.Mode.FULLY_MANAGED);
            case OriginContext.Origin.INTEGRATION -> new IntegrationContext(source.getIntegrationId());
        };
    }
}

