/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.documentation.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.documentation.crud_service.PageCrudService;
import io.gravitee.apim.core.documentation.domain_service.ApiDocumentationDomainService;
import io.gravitee.apim.core.documentation.domain_service.DocumentationValidationDomainService;
import io.gravitee.apim.core.documentation.domain_service.HomepageDomainService;
import io.gravitee.apim.core.documentation.domain_service.UpdateApiDocumentationDomainService;
import io.gravitee.apim.core.documentation.model.Page;
import io.gravitee.apim.core.documentation.query_service.PageQueryService;
import java.util.Date;
import java.util.Objects;
import lombok.Generated;

@UseCase
public class ApiUpdateDocumentationPageUseCase {
    private final UpdateApiDocumentationDomainService updateApiDocumentationDomainService;
    private final ApiDocumentationDomainService apiDocumentationDomainService;
    private final HomepageDomainService homepageDomainService;
    private final ApiCrudService apiCrudService;
    private final PageCrudService pageCrudService;
    private final PageQueryService pageQueryService;
    private final DocumentationValidationDomainService documentationValidationDomainService;

    public Output execute(Input input) {
        Api api = this.apiCrudService.get(input.apiId);
        Page oldPage = this.pageCrudService.get(input.pageId);
        this.apiDocumentationDomainService.validatePageAssociatedToApi(oldPage, input.apiId);
        Page.PageBuilder newPage = oldPage.toBuilder();
        String name = this.documentationValidationDomainService.sanitizeDocumentationName(input.name);
        if (!Objects.equals(oldPage.getName(), name)) {
            this.apiDocumentationDomainService.validateNameIsUnique(input.apiId, oldPage.getParentId(), name, oldPage.getType());
            newPage.name(name);
        }
        if (oldPage.isMarkdown() && !Objects.equals(oldPage.getContent(), input.content)) {
            this.documentationValidationDomainService.validateContent(input.content, input.apiId, input.auditInfo().organizationId());
            newPage.content(input.content);
        } else if (oldPage.isSwagger() && !Objects.equals(oldPage.getContent(), input.content)) {
            this.documentationValidationDomainService.parseOpenApiContent(input.content);
            newPage.content(input.content);
        } else if (oldPage.isAsyncApi() && !Objects.equals(oldPage.getContent(), input.content)) {
            newPage.content(input.content);
        }
        newPage.updatedAt(new Date());
        newPage.visibility(input.visibility);
        newPage.homepage(input.homepage);
        newPage.order(input.order);
        Page updatedPage = this.updateApiDocumentationDomainService.updatePage(newPage.build(), oldPage, input.auditInfo);
        if (!updatedPage.isFolder() && updatedPage.isHomepage() && !oldPage.isHomepage()) {
            this.homepageDomainService.setPreviousHomepageToFalse(input.apiId, updatedPage.getId());
        }
        if (updatedPage.getOrder() != oldPage.getOrder()) {
            this.updatePageOrders(oldPage.getOrder(), updatedPage, input.auditInfo);
        }
        updatedPage = updatedPage.withHidden(this.apiDocumentationDomainService.pageIsHidden(updatedPage)).withGeneralConditions(this.apiDocumentationDomainService.pageIsUsedAsGeneralConditions(updatedPage, api));
        return new Output(updatedPage);
    }

    private void updatePageOrders(int oldOrder, Page updatedPage, AuditInfo auditInfo) {
        int newOrder = updatedPage.getOrder();
        boolean shouldMoveDown = newOrder < oldOrder;
        int orderIncrement = shouldMoveDown ? 1 : -1;
        this.pageQueryService.searchByApiIdAndParentId(updatedPage.getReferenceId(), updatedPage.getParentId()).stream().filter(page -> !Objects.equals(page.getId(), updatedPage.getId())).filter(page -> shouldMoveDown ? this.toBeMovedDown(oldOrder, newOrder, page.getOrder()) : this.toBeMovedUp(oldOrder, newOrder, page.getOrder())).forEach(page -> {
            int updatedOrder = page.getOrder() + orderIncrement;
            this.updateApiDocumentationDomainService.updatePage(page.toBuilder().order(updatedOrder).build(), (Page)page, auditInfo);
        });
    }

    private boolean toBeMovedUp(int oldOrder, int newOrder, int pageOrder) {
        return oldOrder < pageOrder && pageOrder <= newOrder;
    }

    private boolean toBeMovedDown(int oldOrder, int newOrder, int pageOrder) {
        return newOrder <= pageOrder && pageOrder < oldOrder;
    }

    @Generated
    public ApiUpdateDocumentationPageUseCase(UpdateApiDocumentationDomainService updateApiDocumentationDomainService, ApiDocumentationDomainService apiDocumentationDomainService, HomepageDomainService homepageDomainService, ApiCrudService apiCrudService, PageCrudService pageCrudService, PageQueryService pageQueryService, DocumentationValidationDomainService documentationValidationDomainService) {
        this.updateApiDocumentationDomainService = updateApiDocumentationDomainService;
        this.apiDocumentationDomainService = apiDocumentationDomainService;
        this.homepageDomainService = homepageDomainService;
        this.apiCrudService = apiCrudService;
        this.pageCrudService = pageCrudService;
        this.pageQueryService = pageQueryService;
        this.documentationValidationDomainService = documentationValidationDomainService;
    }

    public record Input(String apiId, String pageId, String name, int order, Page.Visibility visibility, String content, boolean homepage, AuditInfo auditInfo) {
        @Generated
        public static InputBuilder builder() {
            return new InputBuilder();
        }

        @Generated
        public static class InputBuilder {
            @Generated
            private String apiId;
            @Generated
            private String pageId;
            @Generated
            private String name;
            @Generated
            private int order;
            @Generated
            private Page.Visibility visibility;
            @Generated
            private String content;
            @Generated
            private boolean homepage;
            @Generated
            private AuditInfo auditInfo;

            @Generated
            InputBuilder() {
            }

            @Generated
            public InputBuilder apiId(String apiId) {
                this.apiId = apiId;
                return this;
            }

            @Generated
            public InputBuilder pageId(String pageId) {
                this.pageId = pageId;
                return this;
            }

            @Generated
            public InputBuilder name(String name) {
                this.name = name;
                return this;
            }

            @Generated
            public InputBuilder order(int order) {
                this.order = order;
                return this;
            }

            @Generated
            public InputBuilder visibility(Page.Visibility visibility) {
                this.visibility = visibility;
                return this;
            }

            @Generated
            public InputBuilder content(String content) {
                this.content = content;
                return this;
            }

            @Generated
            public InputBuilder homepage(boolean homepage) {
                this.homepage = homepage;
                return this;
            }

            @Generated
            public InputBuilder auditInfo(AuditInfo auditInfo) {
                this.auditInfo = auditInfo;
                return this;
            }

            @Generated
            public Input build() {
                return new Input(this.apiId, this.pageId, this.name, this.order, this.visibility, this.content, this.homepage, this.auditInfo);
            }

            @Generated
            public String toString() {
                return "ApiUpdateDocumentationPageUseCase.Input.InputBuilder(apiId=" + this.apiId + ", pageId=" + this.pageId + ", name=" + this.name + ", order=" + this.order + ", visibility=" + this.visibility + ", content=" + this.content + ", homepage=" + this.homepage + ", auditInfo=" + this.auditInfo + ")";
            }
        }
    }

    public record Output(Page page) {
    }
}

