/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.search.lucene.searcher;

import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.rest.api.model.PageEntity;
import io.gravitee.rest.api.model.search.Indexable;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.impl.search.SearchResult;
import io.gravitee.rest.api.service.impl.search.lucene.searcher.AbstractDocumentSearcher;
import io.gravitee.rest.api.service.search.query.Query;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParserBase;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.springframework.stereotype.Component;

@Component
public class PageDocumentSearcher
extends AbstractDocumentSearcher {
    protected static final String FIELD_TYPE_VALUE = "page";

    public SearchResult searchReference(ExecutionContext executionContext, Query query) throws TechnicalException {
        try {
            BooleanQuery.Builder pageQuery = this.buildQuery(query);
            return this.searchReference((org.apache.lucene.search.Query)pageQuery.build());
        }
        catch (ParseException pe) {
            this.logger.error("Invalid query to search for page documents", (Throwable)pe);
            throw new TechnicalException("Invalid query to search for page documents", (Throwable)pe);
        }
    }

    public SearchResult search(ExecutionContext executionContext, Query query) throws TechnicalException {
        try {
            BooleanQuery.Builder pageQuery = this.buildQuery(query);
            return this.search((org.apache.lucene.search.Query)pageQuery.build());
        }
        catch (ParseException pe) {
            this.logger.error("Invalid query to search for page documents", (Throwable)pe);
            throw new TechnicalException("Invalid query to search for page documents", (Throwable)pe);
        }
    }

    private BooleanQuery.Builder buildQuery(Query query) throws ParseException {
        MultiFieldQueryParser parser = new MultiFieldQueryParser(new String[]{"name", "name_lowercase", "content"}, this.analyzer);
        parser.setFuzzyMinSim(0.6f);
        BooleanQuery.Builder pageQuery = new BooleanQuery.Builder();
        BooleanQuery.Builder pageFieldsQuery = new BooleanQuery.Builder();
        if (!StringUtils.isBlank((CharSequence)query.getQuery())) {
            org.apache.lucene.search.Query parse = parser.parse(QueryParserBase.escape((String)query.getQuery()));
            pageFieldsQuery.add(parse, BooleanClause.Occur.SHOULD);
            pageFieldsQuery.add((org.apache.lucene.search.Query)new WildcardQuery(new Term("name", "*" + query.getQuery() + "*")), BooleanClause.Occur.SHOULD);
            pageFieldsQuery.add((org.apache.lucene.search.Query)new WildcardQuery(new Term("name_lowercase", "*" + query.getQuery().toLowerCase() + "*")), BooleanClause.Occur.SHOULD);
            pageFieldsQuery.add((org.apache.lucene.search.Query)new WildcardQuery(new Term("content", "*" + query.getQuery() + "*")), BooleanClause.Occur.SHOULD);
        }
        pageQuery.add((org.apache.lucene.search.Query)pageFieldsQuery.build(), BooleanClause.Occur.MUST);
        pageQuery.add((org.apache.lucene.search.Query)new TermQuery(new Term("type", FIELD_TYPE_VALUE)), BooleanClause.Occur.MUST);
        Optional<org.apache.lucene.search.Query> baseFilterQuery = this.buildFilterQuery("reference_id", query.getFilters());
        baseFilterQuery.ifPresent(q -> pageQuery.add(q, BooleanClause.Occur.FILTER));
        return pageQuery;
    }

    @Override
    public boolean handle(Class<? extends Indexable> source) {
        return source.isAssignableFrom(PageEntity.class);
    }
}

