/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.core.integration.model.Integration;
import io.gravitee.apim.core.integration.model.IntegrationApi;
import io.gravitee.apim.infra.adapter.IntegrationAdapter;
import io.gravitee.integration.api.model.Api;
import io.gravitee.integration.api.model.Page;
import io.gravitee.integration.api.model.PageType;
import io.gravitee.integration.api.model.Plan;
import io.gravitee.integration.api.model.PlanSecurityType;
import io.gravitee.repository.management.model.Integration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class IntegrationAdapterImpl
implements IntegrationAdapter {
    @Override
    public Integration toEntity(io.gravitee.repository.management.model.Integration integration) {
        if (integration == null) {
            return null;
        }
        Integration.IntegrationBuilder integration1 = Integration.builder();
        integration1.id(integration.getId());
        integration1.name(integration.getName());
        integration1.description(integration.getDescription());
        integration1.provider(integration.getProvider());
        integration1.environmentId(integration.getEnvironmentId());
        if (integration.getCreatedAt() != null) {
            integration1.createdAt(ZonedDateTime.ofInstant(integration.getCreatedAt().toInstant(), ZoneId.systemDefault()));
        }
        if (integration.getUpdatedAt() != null) {
            integration1.updatedAt(ZonedDateTime.ofInstant(integration.getUpdatedAt().toInstant(), ZoneId.systemDefault()));
        }
        integration1.agentStatus(this.agentStatusToAgentStatus(integration.getAgentStatus()));
        return integration1.build();
    }

    @Override
    public io.gravitee.repository.management.model.Integration toRepository(Integration integration) {
        if (integration == null) {
            return null;
        }
        Integration.IntegrationBuilder integration1 = io.gravitee.repository.management.model.Integration.builder();
        integration1.id(integration.getId());
        integration1.name(integration.getName());
        integration1.description(integration.getDescription());
        integration1.provider(integration.getProvider());
        integration1.environmentId(integration.getEnvironmentId());
        if (integration.getCreatedAt() != null) {
            integration1.createdAt(Date.from(integration.getCreatedAt().toInstant()));
        }
        if (integration.getUpdatedAt() != null) {
            integration1.updatedAt(Date.from(integration.getUpdatedAt().toInstant()));
        }
        integration1.agentStatus(this.agentStatusToAgentStatus1(integration.getAgentStatus()));
        return integration1.build();
    }

    @Override
    public IntegrationApi map(Api source, String integrationId) {
        if (source == null && integrationId == null) {
            return null;
        }
        IntegrationApi.IntegrationApiBuilder integrationApi = IntegrationApi.builder();
        if (source != null) {
            integrationApi.uniqueId(source.getUniqueId());
            integrationApi.id(source.getId());
            integrationApi.name(source.getName());
            integrationApi.description(source.getDescription());
            integrationApi.version(source.getVersion());
            Map map = source.getConnectionDetails();
            if (map != null) {
                integrationApi.connectionDetails(new LinkedHashMap<String, String>(map));
            }
            integrationApi.plans(this.planListToPlanList(source.getPlans()));
            integrationApi.pages(this.pageListToPageList(source.getPages()));
        }
        integrationApi.integrationId(integrationId);
        return integrationApi.build();
    }

    @Override
    public IntegrationApi.Plan map(Plan source) {
        if (source == null) {
            return null;
        }
        IntegrationApi.PlanType type = null;
        String id = null;
        String name = null;
        String description = null;
        type = this.map(source.planSecurityType());
        id = source.id();
        name = source.name();
        description = source.description();
        IntegrationApi.Plan plan = new IntegrationApi.Plan(id, name, description, type);
        return plan;
    }

    @Override
    public IntegrationApi.PlanType map(PlanSecurityType source) {
        if (source == null) {
            return null;
        }
        return switch (source) {
            case PlanSecurityType.API_KEY -> IntegrationApi.PlanType.API_KEY;
            case PlanSecurityType.JWT -> null;
            case PlanSecurityType.OAUTH2 -> IntegrationApi.PlanType.OAUTH2;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + source);
        };
    }

    @Override
    public IntegrationApi.Page map(Page source) {
        if (source == null) {
            return null;
        }
        IntegrationApi.PageType pageType = null;
        String content = null;
        pageType = this.pageTypeToPageType(source.pageType());
        content = source.content();
        IntegrationApi.Page page = new IntegrationApi.Page(pageType, content);
        return page;
    }

    protected Integration.AgentStatus agentStatusToAgentStatus(Integration.AgentStatus agentStatus) {
        if (agentStatus == null) {
            return null;
        }
        return switch (agentStatus) {
            case Integration.AgentStatus.CONNECTED -> Integration.AgentStatus.CONNECTED;
            case Integration.AgentStatus.DISCONNECTED -> Integration.AgentStatus.DISCONNECTED;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + agentStatus);
        };
    }

    protected Integration.AgentStatus agentStatusToAgentStatus1(Integration.AgentStatus agentStatus) {
        if (agentStatus == null) {
            return null;
        }
        return switch (agentStatus) {
            case Integration.AgentStatus.CONNECTED -> Integration.AgentStatus.CONNECTED;
            case Integration.AgentStatus.DISCONNECTED -> Integration.AgentStatus.DISCONNECTED;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + agentStatus);
        };
    }

    protected List<IntegrationApi.Plan> planListToPlanList(List<Plan> list) {
        if (list == null) {
            return null;
        }
        ArrayList<IntegrationApi.Plan> list1 = new ArrayList<IntegrationApi.Plan>(list.size());
        for (Plan plan : list) {
            list1.add(this.map(plan));
        }
        return list1;
    }

    protected List<IntegrationApi.Page> pageListToPageList(List<Page> list) {
        if (list == null) {
            return null;
        }
        ArrayList<IntegrationApi.Page> list1 = new ArrayList<IntegrationApi.Page>(list.size());
        for (Page page : list) {
            list1.add(this.map(page));
        }
        return list1;
    }

    protected IntegrationApi.PageType pageTypeToPageType(PageType pageType) {
        if (pageType == null) {
            return null;
        }
        return switch (pageType) {
            case PageType.ASCIIDOC -> IntegrationApi.PageType.ASCIIDOC;
            case PageType.ASYNCAPI -> IntegrationApi.PageType.ASYNCAPI;
            case PageType.MARKDOWN -> IntegrationApi.PageType.MARKDOWN;
            case PageType.MARKDOWN_TEMPLATE -> IntegrationApi.PageType.MARKDOWN_TEMPLATE;
            case PageType.SWAGGER -> IntegrationApi.PageType.SWAGGER;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + pageType);
        };
    }
}

