/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.crud_service.api;

import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.apim.core.api.exception.ApiNotFoundException;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.exception.TechnicalDomainException;
import io.gravitee.apim.infra.adapter.ApiAdapter;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiRepository;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ApiCrudServiceImpl
implements ApiCrudService {
    private static final Logger logger = LoggerFactory.getLogger(ApiCrudServiceImpl.class);
    private final ApiRepository apiRepository;

    public ApiCrudServiceImpl(@Lazy ApiRepository apiRepository) {
        this.apiRepository = apiRepository;
    }

    @Override
    public Api get(String id) {
        try {
            Optional foundApi = this.apiRepository.findById((Object)id);
            if (foundApi.isPresent()) {
                return ApiAdapter.INSTANCE.toCoreModel((io.gravitee.repository.management.model.Api)foundApi.get());
            }
        }
        catch (TechnicalException e) {
            logger.error("An error occurred while finding Api by id {}", (Object)id, (Object)e);
        }
        throw new ApiNotFoundException(id);
    }

    @Override
    public boolean existsById(String id) {
        try {
            return this.apiRepository.existById(id);
        }
        catch (TechnicalException e) {
            logger.error("An error occurred while finding Api by id {}", (Object)id, (Object)e);
            return false;
        }
    }

    @Override
    public Api create(Api api) {
        try {
            return ApiAdapter.INSTANCE.toCoreModel((io.gravitee.repository.management.model.Api)this.apiRepository.create((Object)ApiAdapter.INSTANCE.toRepository(api)));
        }
        catch (TechnicalException e) {
            throw new TechnicalDomainException("An error occurs while trying to create the api: " + api.getId(), e);
        }
    }

    @Override
    public Api update(Api api) {
        try {
            return ApiAdapter.INSTANCE.toCoreModel((io.gravitee.repository.management.model.Api)this.apiRepository.update((Object)ApiAdapter.INSTANCE.toRepository(api)));
        }
        catch (TechnicalException e) {
            throw new TechnicalDomainException("An error occurs while trying to update the api: " + api.getId(), e);
        }
    }

    @Override
    public void delete(String id) {
        try {
            this.apiRepository.delete((Object)id);
        }
        catch (TechnicalException e) {
            throw new TechnicalDomainException("An error occurs while trying to delete the api: " + id, e);
        }
    }
}

