/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.theme.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.theme.crud_service.ThemeCrudService;
import io.gravitee.apim.core.theme.exception.ThemeDefinitionInvalidException;
import io.gravitee.apim.core.theme.exception.ThemeNotFoundException;
import io.gravitee.apim.core.theme.exception.ThemeTypeInvalidException;
import io.gravitee.apim.core.theme.model.Theme;
import io.gravitee.apim.core.theme.model.ThemeType;
import io.gravitee.apim.core.theme.model.UpdateTheme;
import io.gravitee.rest.api.service.common.ExecutionContext;
import java.util.Objects;
import lombok.Generated;

@DomainService
public class ValidateThemeDomainService {
    private final ThemeCrudService themeCrudService;

    public void validateUpdateTheme(UpdateTheme updateTheme, ExecutionContext executionContext) {
        Theme existingTheme = this.themeCrudService.get(updateTheme.getId());
        if (!Objects.equals(existingTheme.getReferenceId(), executionContext.getEnvironmentId()) && Theme.ReferenceType.ENVIRONMENT.equals((Object)existingTheme.getReferenceType())) {
            throw new ThemeNotFoundException(updateTheme.getId());
        }
        if (!Objects.equals((Object)existingTheme.getType(), (Object)updateTheme.getType())) {
            throw new ThemeTypeInvalidException(updateTheme.getType().name());
        }
        if (ThemeType.PORTAL_NEXT.equals((Object)updateTheme.getType()) && Objects.isNull(updateTheme.getDefinitionPortalNext())) {
            throw new ThemeDefinitionInvalidException(updateTheme.getType().name(), (Object)null);
        }
        if (ThemeType.PORTAL.equals((Object)updateTheme.getType()) && Objects.isNull(updateTheme.getDefinitionPortal())) {
            throw new ThemeDefinitionInvalidException(updateTheme.getType().name(), (Object)null);
        }
    }

    @Generated
    public ValidateThemeDomainService(ThemeCrudService themeCrudService) {
        this.themeCrudService = themeCrudService;
    }
}

