/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.impl;

import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.search.ApiCriteria;
import io.gravitee.repository.management.api.search.ApiFieldFilter;
import io.gravitee.repository.management.api.search.builder.PageableBuilder;
import io.gravitee.repository.management.model.Api;
import io.gravitee.repository.management.model.ApiLifecycleState;
import io.gravitee.repository.management.model.ApplicationStatus;
import io.gravitee.repository.management.model.LifecycleState;
import io.gravitee.rest.api.model.GroupEntity;
import io.gravitee.rest.api.model.MembershipEntity;
import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.PrimaryOwnerEntity;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.SubscriptionEntity;
import io.gravitee.rest.api.model.SubscriptionStatus;
import io.gravitee.rest.api.model.Visibility;
import io.gravitee.rest.api.model.api.ApiQuery;
import io.gravitee.rest.api.model.application.ApplicationQuery;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.common.PageableImpl;
import io.gravitee.rest.api.model.common.Sortable;
import io.gravitee.rest.api.model.permissions.ApiPermission;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.model.subscription.SubscriptionQuery;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.service.ApplicationService;
import io.gravitee.rest.api.service.CategoryService;
import io.gravitee.rest.api.service.GroupService;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.RoleService;
import io.gravitee.rest.api.service.SubscriptionService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.AbstractService;
import io.gravitee.rest.api.service.impl.search.SearchResult;
import io.gravitee.rest.api.service.search.SearchEngineService;
import io.gravitee.rest.api.service.search.query.Query;
import io.gravitee.rest.api.service.search.query.QueryBuilder;
import io.gravitee.rest.api.service.v4.ApiAuthorizationService;
import io.gravitee.rest.api.service.v4.PrimaryOwnerService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component(value="ApiAuthzServiceImplV4")
public class ApiAuthorizationServiceImpl
extends AbstractService
implements ApiAuthorizationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiAuthorizationServiceImpl.class);
    private final ApiRepository apiRepository;
    private final CategoryService categoryService;
    private final MembershipService membershipService;
    private final RoleService roleService;
    private final ApplicationService applicationService;
    private final GroupService groupService;
    private final SubscriptionService subscriptionService;
    private final PrimaryOwnerService primaryOwnerService;
    private final SearchEngineService searchEngineService;

    public ApiAuthorizationServiceImpl(@Lazy ApiRepository apiRepository, CategoryService categoryService, MembershipService membershipService, RoleService roleService, ApplicationService applicationService, GroupService groupService, SubscriptionService subscriptionService, PrimaryOwnerService primaryOwnerService, SearchEngineService searchEngineService) {
        this.apiRepository = apiRepository;
        this.categoryService = categoryService;
        this.membershipService = membershipService;
        this.roleService = roleService;
        this.applicationService = applicationService;
        this.groupService = groupService;
        this.subscriptionService = subscriptionService;
        this.primaryOwnerService = primaryOwnerService;
        this.searchEngineService = searchEngineService;
    }

    @Override
    public boolean canManageApi(RoleEntity role) {
        return role != null && role.getScope() == RoleScope.API && role.getPermissions().entrySet().stream().filter(entry -> this.isApiManagementPermission((String)entry.getKey())).anyMatch(entry -> {
            String stringPerm = new String((char[])entry.getValue());
            return stringPerm.contains("C") || stringPerm.contains("U") || stringPerm.contains("D");
        });
    }

    private boolean isApiManagementPermission(String permissionAsString) {
        return Arrays.stream(ApiPermission.values()).filter(permission -> permission != ApiPermission.RATING && permission != ApiPermission.RATING_ANSWER).anyMatch(permission -> permission.name().equals(permissionAsString));
    }

    @Override
    public Set<String> findAccessibleApiIdsForUser(ExecutionContext executionContext, String userId, ApiQuery apiQuery) {
        if (apiQuery == null) {
            apiQuery = new ApiQuery();
        }
        apiQuery.setLifecycleStates(Collections.singletonList(io.gravitee.rest.api.model.api.ApiLifecycleState.PUBLISHED));
        return this.findIdsByUser(executionContext, userId, apiQuery, false);
    }

    @Override
    public Set<String> findIdsByUser(ExecutionContext executionContext, String userId, ApiQuery apiQuery, Sortable sortable, boolean manageOnly) {
        List<ApiCriteria> apiCriteriaList;
        Optional<Collection<String>> optionalTargetIds = this.searchInDefinition(executionContext, apiQuery);
        if (optionalTargetIds.isPresent()) {
            Collection<String> targetIds = optionalTargetIds.get();
            if (targetIds.isEmpty()) {
                return Collections.emptySet();
            }
            apiQuery.setIds(targetIds);
        }
        if ((apiCriteriaList = this.computeApiCriteriaForUser(executionContext, userId, apiQuery, manageOnly)).isEmpty()) {
            return Set.of();
        }
        PageableImpl pageable = new PageableImpl(1, Integer.MAX_VALUE);
        List apiIds = this.apiRepository.searchIds(apiCriteriaList, ApiAuthorizationServiceImpl.convert((Pageable)pageable), ApiAuthorizationServiceImpl.convert(sortable)).getContent();
        return new LinkedHashSet<String>(apiIds);
    }

    @Override
    public Set<String> findIdsByEnvironment(String environmentId) {
        if (StringUtils.isBlank((CharSequence)environmentId)) {
            return Set.of();
        }
        ApiCriteria.Builder builder = new ApiCriteria.Builder().environmentId(environmentId);
        ArrayList<ApiCriteria> apiCriteriaList = new ArrayList<ApiCriteria>();
        apiCriteriaList.add(builder.build());
        PageableImpl pageable = new PageableImpl(1, Integer.MAX_VALUE);
        List apiIds = this.apiRepository.searchIds(apiCriteriaList, ApiAuthorizationServiceImpl.convert((Pageable)pageable), null).getContent();
        return new LinkedHashSet<String>(apiIds);
    }

    private Optional<Collection<String>> searchInDefinition(ExecutionContext executionContext, ApiQuery apiQuery) {
        if (apiQuery == null) {
            return Optional.empty();
        }
        Query<GenericApiEntity> searchEngineQuery = this.convert(apiQuery).build();
        if (StringUtils.isBlank((CharSequence)searchEngineQuery.getQuery())) {
            return Optional.empty();
        }
        SearchResult matchApis = this.searchEngineService.search(executionContext, searchEngineQuery);
        return Optional.of(matchApis.getDocuments());
    }

    private QueryBuilder<GenericApiEntity> convert(ApiQuery query) {
        QueryBuilder<GenericApiEntity> searchEngineQuery = QueryBuilder.create(GenericApiEntity.class);
        if (query.getIds() != null && !query.getIds().isEmpty()) {
            HashMap<String, Object> filters = new HashMap<String, Object>();
            filters.put("api", query.getIds());
            searchEngineQuery.setFilters(filters);
        }
        if (!StringUtils.isBlank((CharSequence)query.getContextPath())) {
            searchEngineQuery.addExplicitFilter("paths", query.getContextPath());
        }
        if (!StringUtils.isBlank((CharSequence)query.getTag())) {
            searchEngineQuery.addExplicitFilter("tag", query.getTag());
        }
        if (query.getDefinitionVersions() != null && !query.getDefinitionVersions().isEmpty()) {
            DefinitionVersion[] allPossibleDefinitionVersions = DefinitionVersion.values();
            List definitionVersionsToExclude = Arrays.stream(allPossibleDefinitionVersions).filter(definitionVersion -> !query.getDefinitionVersions().contains(definitionVersion)).map(DefinitionVersion::getLabel).collect(Collectors.toList());
            searchEngineQuery.setExcludedFilters(Map.of("definition_version", definitionVersionsToExclude));
        }
        return searchEngineQuery;
    }

    @Override
    public boolean canConsumeApi(ExecutionContext executionContext, String userId, GenericApiEntity api) {
        boolean isApiGroupMember;
        if (Visibility.PUBLIC.equals((Object)api.getVisibility())) {
            return true;
        }
        boolean isDirectMember = this.membershipService.getMembershipsByMemberAndReference(MembershipMemberType.USER, userId, MembershipReferenceType.API).stream().anyMatch(membership -> membership.getReferenceId().equals(api.getId()));
        if (isDirectMember) {
            return true;
        }
        Set apiGroups = api.getGroups();
        if (apiGroups != null && !apiGroups.isEmpty() && (isApiGroupMember = this.membershipService.getMembershipsByMemberAndReference(MembershipMemberType.USER, userId, MembershipReferenceType.GROUP).stream().anyMatch(membership -> apiGroups.contains(membership.getReferenceId())))) {
            return true;
        }
        Set<String> applicationIds = this.applicationService.findUserApplicationsIds(executionContext, userId, ApplicationStatus.ACTIVE);
        if (applicationIds.isEmpty()) {
            return false;
        }
        SubscriptionQuery query = new SubscriptionQuery();
        query.setApplications(applicationIds);
        query.setApi(api.getId());
        query.setStatuses(Set.of(SubscriptionStatus.ACCEPTED, SubscriptionStatus.RESUMED));
        return !this.subscriptionService.search(executionContext, query).isEmpty();
    }

    @Override
    public List<ApiCriteria> computeApiCriteriaForUser(ExecutionContext executionContext, String userId, ApiQuery apiQuery, boolean manageOnly) {
        ArrayList<ApiCriteria> apiCriteriaList = new ArrayList<ApiCriteria>();
        if (!manageOnly) {
            apiCriteriaList.add(this.queryToCriteria(executionContext, apiQuery).visibility(io.gravitee.repository.management.model.Visibility.PUBLIC).build());
        }
        if (apiQuery == null) {
            apiQuery = new ApiQuery();
        }
        if (userId != null) {
            Set<String> applicationIds;
            Set<String> userGroupApiIds;
            Set<String> userApiIds = this.findUserApiIdsFromMemberships(userId, manageOnly);
            if (!userApiIds.isEmpty()) {
                apiCriteriaList.add(this.queryToCriteria(executionContext, apiQuery).ids(userApiIds).build());
            }
            if (!(userGroupApiIds = this.findApiIdsByUserGroups(executionContext, userId, apiQuery, manageOnly)).isEmpty()) {
                apiCriteriaList.add(this.queryToCriteria(executionContext, apiQuery).ids(userGroupApiIds).build());
            }
            if (!manageOnly && !(applicationIds = this.applicationService.findUserApplicationsIds(executionContext, userId, ApplicationStatus.ACTIVE)).isEmpty()) {
                SubscriptionQuery query = new SubscriptionQuery();
                query.setApplications(applicationIds);
                query.setExcludedApis((Collection)apiCriteriaList.stream().map(ApiCriteria::getIds).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toSet()));
                Collection<SubscriptionEntity> subscriptions = this.subscriptionService.search(executionContext, query);
                if (subscriptions != null && !subscriptions.isEmpty()) {
                    apiCriteriaList.add(this.queryToCriteria(executionContext, apiQuery).ids((Collection)subscriptions.stream().map(SubscriptionEntity::getApi).distinct().collect(Collectors.toList())).build());
                }
            }
        }
        return apiCriteriaList;
    }

    private Set<String> getUserApplicationIds(ExecutionContext executionContext, String userId) {
        Set<String> userApplicationIds = this.membershipService.getReferenceIdsByMemberAndReference(MembershipMemberType.USER, userId, MembershipReferenceType.APPLICATION);
        HashSet<String> applicationIds = new HashSet<String>(userApplicationIds);
        Set<String> userGroupIds = this.membershipService.getReferenceIdsByMemberAndReference(MembershipMemberType.USER, userId, MembershipReferenceType.GROUP);
        ApplicationQuery appQuery = new ApplicationQuery();
        appQuery.setGroups(userGroupIds);
        appQuery.setStatus(ApplicationStatus.ACTIVE.name());
        Set<String> groupApplicationIds = this.applicationService.searchIds(executionContext, appQuery, null);
        applicationIds.addAll(groupApplicationIds);
        return applicationIds;
    }

    @Override
    public Set<String> findApiIdsByUserId(ExecutionContext executionContext, String userId, ApiQuery apiQuery, boolean manageOnly) {
        if (Objects.isNull(userId)) {
            return new HashSet<String>();
        }
        HashSet<String> apiIds = new HashSet<String>();
        if (Objects.isNull(apiQuery)) {
            apiQuery = new ApiQuery();
        }
        Set<String> userApiIds = this.findUserApiIdsFromMemberships(userId, manageOnly);
        apiIds.addAll(userApiIds);
        Set<String> userGroupApiIds = this.findApiIdsByUserGroups(executionContext, userId, apiQuery, manageOnly);
        apiIds.addAll(userGroupApiIds);
        return apiIds;
    }

    private Set<String> findUserApiIdsFromMemberships(String userId, boolean manageOnly) {
        return this.membershipService.getMembershipsByMemberAndReference(MembershipMemberType.USER, userId, MembershipReferenceType.API).stream().filter(membership -> membership.getRoleId() != null).filter(membership -> {
            RoleEntity role = this.roleService.findById(membership.getRoleId());
            if (manageOnly) {
                return this.canManageApi(role);
            }
            return role.getScope().equals((Object)RoleScope.API);
        }).map(MembershipEntity::getReferenceId).collect(Collectors.toSet());
    }

    private Set<String> findApiIdsByUserGroups(ExecutionContext executionContext, String userId, ApiQuery apiQuery, boolean manageOnly) {
        HashSet<String> apis = new HashSet<String>();
        Map<String, RoleEntity> apiRoles = this.roleService.findByScope(RoleScope.API, executionContext.getOrganizationId()).stream().collect(Collectors.toMap(RoleEntity::getId, Function.identity()));
        List<String> nonPOGroupApiIds = this.findApiIdsByGroupWithUserHavingNonPOApiRole(executionContext, userId, apiQuery, apiRoles, manageOnly);
        List<String> poGroupApiIds = this.findApiIdsByGroupWithUserHavingPOApiRole(executionContext, userId, apiQuery, apiRoles, manageOnly);
        apis.addAll(nonPOGroupApiIds);
        apis.addAll(poGroupApiIds);
        return apis;
    }

    private List<String> findApiIdsByGroupWithUserHavingNonPOApiRole(ExecutionContext executionContext, String userId, ApiQuery apiQuery, Map<String, RoleEntity> apiRoles, boolean manageOnly) {
        Set<String> nonPoRoleIds = apiRoles.values().stream().filter(role -> !role.isApiPrimaryOwner()).map(RoleEntity::getId).collect(Collectors.toSet());
        String[] groupIds = (String[])this.membershipService.getMembershipsByMemberAndReferenceAndRoleIn(MembershipMemberType.USER, userId, MembershipReferenceType.GROUP, nonPoRoleIds).stream().filter(membership -> {
            RoleEntity roleInGroup = (RoleEntity)apiRoles.get(membership.getRoleId());
            if (manageOnly) {
                return this.canManageApi(roleInGroup);
            }
            return roleInGroup.getScope().equals((Object)RoleScope.API);
        }).map(MembershipEntity::getReferenceId).filter(Objects::nonNull).toArray(String[]::new);
        if (groupIds.length > 0) {
            List<String> apiIds = this.apiRepository.searchIds(List.of(this.queryToCriteria(executionContext, apiQuery).groups(groupIds).build()), new PageableBuilder().pageSize(Integer.MAX_VALUE).build(), null).getContent();
            return apiIds != null ? apiIds : List.of();
        }
        return List.of();
    }

    private List<String> findApiIdsByGroupWithUserHavingPOApiRole(ExecutionContext executionContext, String userId, ApiQuery apiQuery, Map<String, RoleEntity> apiRoles, boolean manageOnly) {
        String apiPrimaryOwnerRoleId = apiRoles.values().stream().filter(RoleEntity::isApiPrimaryOwner).map(RoleEntity::getId).findFirst().orElseThrow(() -> new TechnicalManagementException("Unable to find API Primary Owner System Role"));
        String[] poGroupIds = (String[])this.membershipService.getMembershipsByMemberAndReferenceAndRole(MembershipMemberType.USER, userId, MembershipReferenceType.GROUP, apiPrimaryOwnerRoleId).stream().map(MembershipEntity::getReferenceId).filter(Objects::nonNull).toArray(String[]::new);
        Map apiRolesByName = apiRoles.values().stream().collect(Collectors.toMap(RoleEntity::getName, Function.identity()));
        Set<GroupEntity> userGroups = this.groupService.findByIds(Set.of(poGroupIds));
        if (poGroupIds.length > 0) {
            return this.apiRepository.search(this.queryToCriteria(executionContext, apiQuery).groups(poGroupIds).build(), null, ApiFieldFilter.allFields()).filter(api -> {
                PrimaryOwnerEntity primaryOwner = this.primaryOwnerService.getPrimaryOwner(executionContext.getOrganizationId(), api.getId());
                if (Set.of(poGroupIds).contains(primaryOwner.getId())) {
                    return true;
                }
                return userGroups.stream().map(GroupEntity::getRoles).filter(Objects::nonNull).anyMatch(groupDefaultRoles -> {
                    String defaultApiRoleName = (String)groupDefaultRoles.get(RoleScope.API);
                    RoleEntity role = (RoleEntity)apiRolesByName.get(defaultApiRoleName);
                    if (manageOnly) {
                        return this.canManageApi(role);
                    }
                    return role.getScope().equals((Object)RoleScope.API);
                });
            }).map(Api::getId).collect(Collectors.toList());
        }
        return List.of();
    }

    private ApiCriteria.Builder queryToCriteria(ExecutionContext executionContext, ApiQuery query) {
        ApiCriteria.Builder builder = new ApiCriteria.Builder().environmentId(executionContext.getEnvironmentId());
        if (query == null) {
            return builder;
        }
        builder.label(query.getLabel()).name(query.getName()).version(query.getVersion());
        if (query.getDefinitionVersions() != null && !query.getDefinitionVersions().isEmpty()) {
            builder.definitionVersion(query.getDefinitionVersions());
        }
        if (!StringUtils.isBlank((CharSequence)query.getCategory())) {
            builder.category(this.categoryService.findById(query.getCategory(), executionContext.getEnvironmentId()).getId());
        }
        if (query.getGroups() != null && !query.getGroups().isEmpty()) {
            builder.groups((Collection)query.getGroups());
        }
        if (!StringUtils.isBlank((CharSequence)query.getState())) {
            builder.state(LifecycleState.valueOf((String)query.getState()));
        }
        if (query.getVisibility() != null) {
            builder.visibility(io.gravitee.repository.management.model.Visibility.valueOf((String)query.getVisibility().name()));
        }
        if (query.getLifecycleStates() != null) {
            builder.lifecycleStates(query.getLifecycleStates().stream().map(apiLifecycleState -> ApiLifecycleState.valueOf((String)apiLifecycleState.name())).collect(Collectors.toList()));
        }
        if (query.getIds() != null && !query.getIds().isEmpty()) {
            builder.ids(query.getIds());
        }
        if (query.getCrossId() != null && !query.getCrossId().isEmpty()) {
            builder.crossId(query.getCrossId());
        }
        return builder;
    }
}

