/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.alert.api.condition.StringCondition;
import io.gravitee.alert.api.trigger.Trigger;
import io.gravitee.alert.api.trigger.TriggerProvider;
import io.gravitee.alert.api.trigger.command.AlertNotificationCommand;
import io.gravitee.alert.api.trigger.command.Command;
import io.gravitee.alert.api.trigger.command.Handler;
import io.gravitee.alert.api.trigger.command.ResolvePropertyCommand;
import io.gravitee.common.data.domain.Page;
import io.gravitee.common.utils.UUID;
import io.gravitee.node.api.configuration.Configuration;
import io.gravitee.notifier.api.Notification;
import io.gravitee.plugin.alert.AlertTriggerProviderManager;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.AlertEventRepository;
import io.gravitee.repository.management.api.AlertTriggerRepository;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.search.AlertEventCriteria;
import io.gravitee.repository.management.api.search.ApiCriteria;
import io.gravitee.repository.management.api.search.builder.PageableBuilder;
import io.gravitee.repository.management.model.AlertEvent;
import io.gravitee.repository.management.model.AlertEventRule;
import io.gravitee.repository.management.model.AlertEventType;
import io.gravitee.repository.management.model.AlertTrigger;
import io.gravitee.rest.api.model.AlertEventQuery;
import io.gravitee.rest.api.model.EnvironmentEntity;
import io.gravitee.rest.api.model.alert.AlertEventEntity;
import io.gravitee.rest.api.model.alert.AlertReferenceType;
import io.gravitee.rest.api.model.alert.AlertStatusEntity;
import io.gravitee.rest.api.model.alert.AlertTriggerEntity;
import io.gravitee.rest.api.model.alert.NewAlertTriggerEntity;
import io.gravitee.rest.api.model.alert.UpdateAlertTriggerEntity;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.common.PageableImpl;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.service.AlertService;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.ApplicationService;
import io.gravitee.rest.api.service.EnvironmentService;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.PlanService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.ReferenceContext;
import io.gravitee.rest.api.service.converter.AlertTriggerConverter;
import io.gravitee.rest.api.service.exceptions.AlertNotFoundException;
import io.gravitee.rest.api.service.exceptions.AlertTemplateInvalidException;
import io.gravitee.rest.api.service.exceptions.AlertUnavailableException;
import io.gravitee.rest.api.service.exceptions.ApiNotFoundException;
import io.gravitee.rest.api.service.exceptions.ApplicationNotFoundException;
import io.gravitee.rest.api.service.exceptions.PlanNotFoundException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.AbstractService;
import io.gravitee.rest.api.service.impl.TransactionalService;
import io.gravitee.rest.api.service.impl.alert.EmailNotifierConfiguration;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class AlertServiceImpl
extends TransactionalService
implements AlertService,
InitializingBean {
    private final Logger LOGGER = LoggerFactory.getLogger(AlertServiceImpl.class);
    private static final String UNKNOWN_SERVICE = "1";
    private static final String FIELD_API = "api";
    private static final String FIELD_APPLICATION = "application";
    private static final String FIELD_PLAN = "plan";
    private static final String METADATA_NAME = "name";
    private static final String METADATA_DELETED = "deleted";
    private static final String METADATA_UNKNOWN = "unknown";
    private static final String METADATA_UNKNOWN_API_NAME = "Unknown API (not found)";
    private static final String METADATA_UNKNOWN_APPLICATION_NAME = "Unknown application (keyless)";
    private static final String METADATA_DELETED_API_NAME = "Deleted API";
    private static final String METADATA_DELETED_APPLICATION_NAME = "Deleted application";
    private static final String METADATA_DELETED_PLAN_NAME = "Deleted plan";
    private final Configuration configuration;
    private final ObjectMapper mapper;
    private final AlertTriggerRepository alertTriggerRepository;
    private final ApiService apiService;
    private final ApplicationService applicationService;
    private final PlanService planService;
    private final AlertEventRepository alertEventRepository;
    private final TriggerProvider triggerProvider;
    private final AlertTriggerProviderManager triggerProviderManager;
    private final ParameterService parameterService;
    private final ApiRepository apiRepository;
    private final AlertTriggerConverter alertTriggerConverter;
    private final EnvironmentService environmentService;

    @Autowired
    public AlertServiceImpl(Configuration configuration, ObjectMapper mapper, @Lazy AlertTriggerRepository alertTriggerRepository, @Lazy ApiService apiService, ApplicationService applicationService, PlanService planService, @Lazy AlertEventRepository alertEventRepository, TriggerProvider triggerProvider, AlertTriggerProviderManager triggerProviderManager, ParameterService parameterService, @Lazy ApiRepository apiRepository, AlertTriggerConverter alertTriggerConverter, EnvironmentService environmentService) {
        this.configuration = configuration;
        this.mapper = mapper;
        this.alertTriggerRepository = alertTriggerRepository;
        this.apiService = apiService;
        this.applicationService = applicationService;
        this.planService = planService;
        this.alertEventRepository = alertEventRepository;
        this.triggerProvider = triggerProvider;
        this.triggerProviderManager = triggerProviderManager;
        this.parameterService = parameterService;
        this.apiRepository = apiRepository;
        this.alertTriggerConverter = alertTriggerConverter;
        this.environmentService = environmentService;
    }

    @Override
    public AlertStatusEntity getStatus(ExecutionContext executionContext) {
        AlertStatusEntity status = new AlertStatusEntity();
        status.setEnabled(this.parameterService.findAsBoolean(executionContext, Key.ALERT_ENABLED, ParameterReferenceType.ORGANIZATION));
        status.setPlugins(this.triggerProviderManager.findAll().size());
        return status;
    }

    @Override
    public AlertTriggerEntity create(ExecutionContext executionContext, NewAlertTriggerEntity newAlertTrigger) {
        this.checkAlert(executionContext);
        try {
            AlertTrigger alertTrigger = this.alertTriggerConverter.toAlertTrigger(executionContext, newAlertTrigger);
            alertTrigger.setCreatedAt(new Date());
            alertTrigger.setUpdatedAt(alertTrigger.getCreatedAt());
            return this.create(executionContext, alertTrigger);
        }
        catch (TechnicalException ex) {
            String message = "An error occurs while trying to create an alert " + newAlertTrigger;
            this.LOGGER.error(message, (Throwable)ex);
            throw new TechnicalManagementException(message, ex);
        }
    }

    private AlertTriggerEntity create(ExecutionContext executionContext, AlertTrigger alertTrigger) throws TechnicalException {
        AlertTrigger createdAlert = (AlertTrigger)this.alertTriggerRepository.create((Object)alertTrigger);
        AlertTriggerEntity alertTriggerEntity = this.alertTriggerConverter.toAlertTriggerEntity(createdAlert);
        this.fillNotificationsAndFilters(executionContext, alertTriggerEntity, alertTriggerEntity.getReferenceType(), alertTriggerEntity.getReferenceId());
        if (!alertTriggerEntity.isTemplate()) {
            this.triggerOrCancelAlert((Trigger)alertTriggerEntity);
        }
        return alertTriggerEntity;
    }

    @Override
    public AlertTriggerEntity update(ExecutionContext executionContext, UpdateAlertTriggerEntity updateAlertTrigger) {
        this.checkAlert(executionContext);
        try {
            AlertTrigger alertToUpdate = (AlertTrigger)this.alertTriggerRepository.findById((Object)updateAlertTrigger.getId()).orElseThrow(() -> new AlertNotFoundException(updateAlertTrigger.getId()));
            if (!alertToUpdate.getReferenceId().equals(updateAlertTrigger.getReferenceId())) {
                throw new AlertNotFoundException(updateAlertTrigger.getId());
            }
            AlertTrigger trigger = this.alertTriggerConverter.toAlertTrigger(executionContext, updateAlertTrigger);
            trigger.setReferenceId(alertToUpdate.getReferenceId());
            trigger.setReferenceType(alertToUpdate.getReferenceType());
            trigger.setCreatedAt(alertToUpdate.getCreatedAt());
            trigger.setType(alertToUpdate.getType());
            trigger.setUpdatedAt(new Date());
            AlertTriggerEntity alertTriggerEntity = this.alertTriggerConverter.toAlertTriggerEntity((AlertTrigger)this.alertTriggerRepository.update((Object)trigger));
            this.fillNotificationsAndFilters(executionContext, alertTriggerEntity, updateAlertTrigger.getReferenceType(), updateAlertTrigger.getReferenceId());
            if (!alertTriggerEntity.isTemplate()) {
                this.triggerOrCancelAlert((Trigger)alertTriggerEntity);
            }
            return alertTriggerEntity;
        }
        catch (TechnicalException ex) {
            String message = "An error occurs while trying to update an alert " + updateAlertTrigger;
            this.LOGGER.error(message, (Throwable)ex);
            throw new TechnicalManagementException(message, ex);
        }
    }

    @Override
    public AlertTriggerEntity findById(String alertId) {
        try {
            return this.alertTriggerRepository.findById((Object)alertId).map(this.alertTriggerConverter::toAlertTriggerEntity).orElseThrow(() -> new AlertNotFoundException(alertId));
        }
        catch (TechnicalException e) {
            this.LOGGER.error("An error occurs while trying to find alert by id {}", (Object)alertId, (Object)e);
            throw new TechnicalManagementException("An error occurs while trying to find alert with id", e);
        }
    }

    @Override
    public List<AlertTriggerEntity> findAll() {
        try {
            return this.alertTriggerConverter.toAlertTriggerEntities(new ArrayList<AlertTrigger>(this.alertTriggerRepository.findAll()));
        }
        catch (TechnicalException ex) {
            String message = "An error occurs while trying to list all alerts";
            this.LOGGER.error("An error occurs while trying to list all alerts", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to list all alerts", ex);
        }
    }

    @Override
    public List<AlertTriggerEntity> findByReference(AlertReferenceType referenceType, String referenceId) {
        try {
            return this.alertTriggerConverter.toAlertTriggerEntities(this.alertTriggerRepository.findByReferenceAndReferenceId(referenceType.name(), referenceId));
        }
        catch (TechnicalException ex) {
            String message = "An error occurs while trying to list alerts by reference " + referenceType + "/" + referenceId;
            this.LOGGER.error(message, (Throwable)ex);
            throw new TechnicalManagementException(message, ex);
        }
    }

    @Override
    public List<AlertTriggerEntity> findByReferences(AlertReferenceType referenceType, List<String> referenceIds) {
        try {
            return this.alertTriggerConverter.toAlertTriggerEntities(this.alertTriggerRepository.findByReferenceAndReferenceIds(referenceType.name(), referenceIds));
        }
        catch (TechnicalException ex) {
            String message = "An error occurs while trying to list alerts by references " + referenceType + "/" + referenceIds;
            this.LOGGER.error(message, (Throwable)ex);
            throw new TechnicalManagementException(message, ex);
        }
    }

    @Override
    public List<AlertTriggerEntity> findByReferenceWithEventCounts(AlertReferenceType referenceType, String referenceId) {
        try {
            List triggers = this.alertTriggerRepository.findByReferenceAndReferenceId(referenceType.name(), referenceId);
            return triggers.stream().map(alertTrigger -> {
                AlertTriggerEntity entity = this.alertTriggerConverter.toAlertTriggerEntity((AlertTrigger)alertTrigger);
                this.getLastEvent(entity.getId()).ifPresent(alertEvent -> {
                    entity.setLastAlertAt(alertEvent.getCreatedAt());
                    entity.setLastAlertMessage(alertEvent.getMessage());
                });
                Date from = new Date(System.currentTimeMillis());
                Map<String, Integer> counters = Map.of("5m", from.toInstant().minus(Duration.ofMinutes(5L)), "1h", from.toInstant().minus(Duration.ofHours(1L)), "1d", from.toInstant().minus(Duration.ofDays(1L)), "1M", from.toInstant().minus(Duration.ofDays(30L))).entrySet().parallelStream().map(entry -> new AbstractMap.SimpleEntry<String, Integer>((String)entry.getKey(), this.countEvents(entity.getId(), ((Instant)entry.getValue()).toEpochMilli(), from.getTime()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                entity.setCounters(counters);
                return entity;
            }).sorted(Comparator.comparing(Trigger::getName)).collect(Collectors.toList());
        }
        catch (TechnicalException ex) {
            String message = "An error occurs while trying to list alerts by reference " + referenceType + "/" + referenceId;
            this.LOGGER.error(message, (Throwable)ex);
            throw new TechnicalManagementException(message, ex);
        }
    }

    @Override
    public void delete(String alertId, String referenceId) {
        try {
            AlertTriggerEntity alert = this.alertTriggerRepository.findById((Object)alertId).filter(a -> a.getReferenceId().equals(referenceId)).map(this.alertTriggerConverter::toAlertTriggerEntity).orElseThrow(() -> new AlertNotFoundException(alertId));
            this.alertTriggerRepository.delete((Object)alertId);
            this.alertEventRepository.deleteAll(alertId);
            this.disableTrigger((Trigger)alert);
        }
        catch (TechnicalException te) {
            String msg = "An error occurs while trying to delete the alert " + alertId;
            this.LOGGER.error(msg, (Throwable)te);
            throw new TechnicalManagementException(msg, te);
        }
    }

    @Override
    public Page<AlertEventEntity> findEvents(String alertId, AlertEventQuery eventQuery) {
        Page alertEventsRepo = this.alertEventRepository.search(new AlertEventCriteria.Builder().alert(alertId).from(eventQuery.getFrom()).to(eventQuery.getTo()).build(), new PageableBuilder().pageNumber(eventQuery.getPageNumber()).pageSize(eventQuery.getPageSize()).build());
        if (alertEventsRepo.getPageElements() == 0L) {
            return new Page(Collections.emptyList(), 1, 0, 0L);
        }
        List alertEvents = alertEventsRepo.getContent().stream().map(alertEventRepo -> {
            AlertEventEntity alertEvent = new AlertEventEntity();
            alertEvent.setCreatedAt(alertEventRepo.getCreatedAt());
            alertEvent.setMessage(alertEventRepo.getMessage());
            return alertEvent;
        }).collect(Collectors.toList());
        return new Page(alertEvents, alertEventsRepo.getPageNumber(), (int)alertEventsRepo.getPageElements(), alertEventsRepo.getTotalElements());
    }

    private Set<AlertTriggerEntity> findByEvent(AlertEventType event) {
        try {
            this.LOGGER.debug("findByEvent: {}", (Object)event);
            Set set = this.alertTriggerRepository.findAll().stream().filter(alert -> alert.isTemplate() && alert.getEventRules() != null && alert.getEventRules().stream().map(AlertEventRule::getEvent).collect(Collectors.toList()).contains(event)).map(this.alertTriggerConverter::toAlertTriggerEntity).sorted(Comparator.comparing(Trigger::getName)).collect(Collectors.toCollection(LinkedHashSet::new));
            this.LOGGER.debug("findByEvent : {} - DONE", (Object)set);
            return set;
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find alert triggers by event", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find alert triggers by event", ex);
        }
    }

    @Override
    public void createDefaults(ExecutionContext executionContext, AlertReferenceType referenceType, String referenceId) {
        if (this.getStatus(executionContext).isEnabled()) {
            Set<AlertTriggerEntity> defaultAlerts = this.findByEvent(AlertEventType.API_CREATE);
            for (AlertTriggerEntity alert : defaultAlerts) {
                AlertTrigger trigger = this.alertTriggerConverter.toAlertTrigger(alert);
                AlertTriggerEntity triggerEntity = this.alertTriggerConverter.toAlertTriggerEntity(trigger);
                triggerEntity.setId(UUID.toString((java.util.UUID)UUID.random()));
                triggerEntity.setReferenceType(AlertReferenceType.API);
                triggerEntity.setReferenceId(referenceId);
                triggerEntity.setTemplate(false);
                triggerEntity.setEnabled(true);
                triggerEntity.setEventRules(null);
                triggerEntity.setParentId(alert.getId());
                triggerEntity.setCreatedAt(new Date());
                triggerEntity.setUpdatedAt(trigger.getCreatedAt());
                try {
                    this.create(executionContext, this.alertTriggerConverter.toAlertTrigger(triggerEntity));
                }
                catch (TechnicalException te) {
                    this.LOGGER.error("Unable to create default alert", (Throwable)te);
                }
            }
        }
    }

    @Override
    public void applyDefaults(ExecutionContext executionContext, String alertId, AlertReferenceType referenceType) {
        try {
            List apiIds;
            AlertTriggerEntity alert = this.alertTriggerRepository.findById((Object)alertId).map(this.alertTriggerConverter::toAlertTriggerEntity).orElseThrow(() -> new AlertNotFoundException(alertId));
            if (!alert.isTemplate()) {
                throw new AlertTemplateInvalidException(alertId);
            }
            if (referenceType == AlertReferenceType.API && (apiIds = this.apiRepository.searchIds(List.of(new ApiCriteria.Builder().environmentId(executionContext.getEnvironmentId()).build()), AbstractService.convert((Pageable)new PageableImpl(0, Integer.MAX_VALUE)), null).getContent()) != null) {
                apiIds.stream().forEach(apiId -> {
                    try {
                        boolean create = this.alertTriggerRepository.findByReferenceAndReferenceId(AlertReferenceType.API.name(), apiId).stream().noneMatch(alertTrigger -> alertId.equals(alertTrigger.getParentId()));
                        if (create) {
                            AlertTrigger trigger = this.alertTriggerConverter.toAlertTrigger(alert);
                            AlertTriggerEntity triggerEntity = this.alertTriggerConverter.toAlertTriggerEntity(trigger);
                            triggerEntity.setId(UUID.toString((java.util.UUID)UUID.random()));
                            triggerEntity.setReferenceType(AlertReferenceType.API);
                            triggerEntity.setReferenceId(apiId);
                            triggerEntity.setTemplate(false);
                            triggerEntity.setEnabled(true);
                            triggerEntity.setEventRules(null);
                            triggerEntity.setParentId(alertId);
                            triggerEntity.setCreatedAt(new Date());
                            triggerEntity.setUpdatedAt(trigger.getCreatedAt());
                            this.create(executionContext, this.alertTriggerConverter.toAlertTrigger(triggerEntity));
                        }
                    }
                    catch (TechnicalException te) {
                        this.LOGGER.error("Unable to create default alert for API {}", apiId, (Object)te);
                    }
                });
            }
        }
        catch (TechnicalException te) {
            String msg = "An error occurs while trying to apply template alert " + alertId;
            this.LOGGER.error(msg, (Throwable)te);
            throw new TechnicalManagementException(msg, te);
        }
    }

    private void fillNotificationsAndFilters(ExecutionContext executionContext, AlertTriggerEntity trigger, AlertReferenceType referenceType, String referenceId) {
        ArrayList notifications = trigger.getNotifications();
        if (notifications == null) {
            notifications = new ArrayList();
            trigger.setNotifications(notifications);
        }
        notifications.forEach(notification -> {
            if ("default-email".equalsIgnoreCase(notification.getType())) {
                this.setDefaultEmailNotifier(executionContext, (Notification)notification);
            }
        });
        ArrayList<StringCondition> filters = trigger.getFilters();
        if (filters == null) {
            filters = new ArrayList<StringCondition>();
            trigger.setFilters(filters);
        }
        if (referenceType == AlertReferenceType.APPLICATION || referenceType == AlertReferenceType.API) {
            filters.add(StringCondition.equals((String)referenceType.name().toLowerCase(), (String)referenceId).build());
        } else if (referenceType == AlertReferenceType.ENVIRONMENT) {
            EnvironmentEntity environment = this.environmentService.findById(referenceId);
            filters.add(this.stringMatchesCondition(ReferenceContext.Type.ENVIRONMENT, environment.getId()));
            filters.add(this.stringMatchesCondition(ReferenceContext.Type.ORGANIZATION, environment.getOrganizationId()));
        }
    }

    private void setDefaultEmailNotifier(ExecutionContext executionContext, Notification notification) {
        EmailNotifierConfiguration configuration = new EmailNotifierConfiguration();
        if (this.host() == null) {
            configuration.setHost(this.parameterService.find(executionContext, Key.EMAIL_HOST, ParameterReferenceType.ORGANIZATION));
            String emailPort = this.parameterService.find(executionContext, Key.EMAIL_PORT, ParameterReferenceType.ORGANIZATION);
            if (emailPort != null) {
                configuration.setPort(Integer.parseInt(emailPort));
            }
            configuration.setUsername(this.parameterService.find(executionContext, Key.EMAIL_USERNAME, ParameterReferenceType.ORGANIZATION));
            configuration.setPassword(this.parameterService.find(executionContext, Key.EMAIL_PASSWORD, ParameterReferenceType.ORGANIZATION));
            configuration.setStartTLSEnabled(this.parameterService.findAsBoolean(executionContext, Key.EMAIL_HOST, ParameterReferenceType.ORGANIZATION));
        } else {
            configuration.setHost(this.host());
            configuration.setPort(this.port());
            configuration.setUsername(this.username());
            configuration.setPassword(this.password());
            configuration.setStartTLSEnabled(this.startTLSEnabled());
            configuration.setSslKeyStore(this.sslKeyStore());
            configuration.setSslKeyStorePassword(this.sslKeyStorePassword());
            configuration.setSslTrustAll(this.sslTrustAll());
        }
        configuration.setAuthMethods(this.authMethods());
        try {
            JsonNode emailNode = this.mapper.readTree(notification.getConfiguration());
            configuration.setFrom(emailNode.path("from").asText());
            configuration.setTo(emailNode.path("to").asText());
            configuration.setSubject(String.format(this.subject(), emailNode.path("subject").asText()));
            configuration.setBody(emailNode.path("body").asText());
            notification.setConfiguration(this.mapper.writeValueAsString((Object)configuration));
            notification.setType("email-notifier");
        }
        catch (IOException e) {
            this.LOGGER.error("Unexpected error while converting system email configuration to email notifier");
        }
    }

    private void checkAlert(ExecutionContext executionContext) {
        if (!this.parameterService.findAsBoolean(executionContext, Key.ALERT_ENABLED, ParameterReferenceType.ORGANIZATION) || this.triggerProviderManager.findAll().isEmpty()) {
            throw new AlertUnavailableException();
        }
    }

    private void triggerOrCancelAlert(Trigger trigger) {
        if (trigger.isEnabled()) {
            this.pushTrigger(trigger);
        } else {
            this.disableTrigger(trigger);
        }
    }

    private void pushTrigger(Trigger trigger) {
        this.triggerProvider.register(trigger);
    }

    private void disableTrigger(Trigger trigger) {
        trigger.setEnabled(false);
        this.triggerProvider.unregister(trigger);
    }

    public void afterPropertiesSet() throws Exception {
        this.triggerProvider.addListener((TriggerProvider.Listener)((TriggerProvider.OnConnectionListener)() -> {
            this.LOGGER.info("Connected to alerting system. Sync alert triggers...");
            this.findAll().stream().filter(alertTriggerEntity -> !alertTriggerEntity.isTemplate()).forEach(alertTriggerEntity -> {
                ExecutionContext executionContext = new ExecutionContext(this.environmentService.findById(alertTriggerEntity.getEnvironmentId()));
                this.fillNotificationsAndFilters(executionContext, (AlertTriggerEntity)alertTriggerEntity, alertTriggerEntity.getReferenceType(), alertTriggerEntity.getReferenceId());
                this.triggerOrCancelAlert((Trigger)alertTriggerEntity);
            });
            this.LOGGER.info("Alert triggers synchronized with the alerting system.");
        }));
        this.triggerProvider.addListener((TriggerProvider.Listener)((TriggerProvider.OnDisconnectionListener)() -> this.LOGGER.error("Connection with the alerting system has been loose.")));
        this.triggerProvider.addListener((TriggerProvider.Listener)((TriggerProvider.OnCommandListener)command -> {
            if (command instanceof AlertNotificationCommand) {
                this.handleAlertNotificationCommand((AlertNotificationCommand)command);
            } else {
                this.LOGGER.warn("Unknown alert command: {}", (Object)command);
            }
        }));
        this.triggerProvider.addListener((TriggerProvider.Listener)new TriggerProvider.OnCommandResultListener(){

            public <T> void doOnCommand(Command command, Handler<T> resultHandler) {
                ResolvePropertyCommandHandler supplier = null;
                if (command instanceof ResolvePropertyCommand) {
                    supplier = new ResolvePropertyCommandHandler((ResolvePropertyCommand)command);
                } else {
                    AlertServiceImpl.this.LOGGER.warn("Unknown alert command: {}", (Object)command);
                }
                if (supplier != null) {
                    resultHandler.handle(supplier.get());
                } else {
                    resultHandler.handle(null);
                }
            }
        });
    }

    private void handleAlertNotificationCommand(AlertNotificationCommand command) {
        try {
            AlertEvent alertEvent = new AlertEvent();
            alertEvent.setId(UUID.toString((java.util.UUID)UUID.random()));
            alertEvent.setAlert(command.getTrigger());
            alertEvent.setCreatedAt(new Date(command.getTimestamp()));
            alertEvent.setUpdatedAt(alertEvent.getCreatedAt());
            alertEvent.setMessage(command.getMessage());
            this.alertEventRepository.create((Object)alertEvent);
        }
        catch (TechnicalException ex) {
            String message = "An error occurs while trying to create an alert event from command {}" + command;
            this.LOGGER.error(message, (Throwable)ex);
            throw new TechnicalManagementException(message, ex);
        }
    }

    private int countEvents(String triggerId, long from, long to) {
        AlertEventCriteria criteria = new AlertEventCriteria.Builder().alert(triggerId).from(from).to(to).build();
        return Math.toIntExact(this.alertEventRepository.count(criteria));
    }

    private Optional<AlertEvent> getLastEvent(String triggerId) {
        Page alertEventsRepo = this.alertEventRepository.search(new AlertEventCriteria.Builder().alert(triggerId).from(0L).to(0L).build(), new PageableBuilder().pageNumber(0).pageSize(1).build());
        return alertEventsRepo.getPageElements() == 0L ? Optional.empty() : Optional.of((AlertEvent)alertEventsRepo.getContent().get(0));
    }

    private StringCondition stringMatchesCondition(ReferenceContext.Type key, String value) {
        return StringCondition.matches((String)key.name().toLowerCase(), (String)("(?:.*,|^)" + value + "(?:,.*|$)|\\*")).build();
    }

    private String subject() {
        return this.configuration.getProperty("notifiers.email.subject", "[Gravitee.io] %s");
    }

    private String host() {
        return this.configuration.getProperty("notifiers.email.host");
    }

    private Integer port() {
        return (Integer)this.configuration.getProperty("notifiers.email.port", Integer.class);
    }

    private String username() {
        return this.configuration.getProperty("notifiers.email.username");
    }

    private String password() {
        return this.configuration.getProperty("notifiers.email.password");
    }

    private Set<String> authMethods() {
        return Optional.ofNullable((String[])this.configuration.getProperty("notifiers.email.authMethods", String[].class)).map(Set::of).orElse(null);
    }

    private boolean startTLSEnabled() {
        return (Boolean)this.configuration.getProperty("notifiers.email.starttls.enabled", Boolean.class, (Object)false);
    }

    private boolean sslTrustAll() {
        return (Boolean)this.configuration.getProperty("notifiers.email.ssl.trustAll", Boolean.class, (Object)false);
    }

    private String sslKeyStore() {
        return this.configuration.getProperty("notifiers.email.ssl.keyStore");
    }

    private String sslKeyStorePassword() {
        return this.configuration.getProperty("notifiers.email.ssl.keyStorePassword");
    }

    private final class ResolvePropertyCommandHandler
    implements Supplier<Map<String, Map<String, Object>>> {
        private final ResolvePropertyCommand command;

        ResolvePropertyCommandHandler(ResolvePropertyCommand command) {
            this.command = command;
        }

        @Override
        public Map<String, Map<String, Object>> get() {
            Map properties = this.command.getProperties();
            HashMap<String, Map<String, Object>> values = new HashMap<String, Map<String, Object>>();
            if (properties != null) {
                properties.forEach((key, value) -> {
                    switch (key) {
                        case "api": {
                            values.put((String)key, this.getAPIMetadata((String)value));
                            break;
                        }
                        case "application": {
                            values.put((String)key, this.getApplicationMetadata((String)value));
                            break;
                        }
                        case "plan": {
                            values.put((String)key, this.getPlanMetadata((String)value));
                        }
                    }
                });
            }
            return values;
        }

        private Map<String, Object> getAPIMetadata(String api) {
            HashMap<String, Object> metadata = new HashMap<String, Object>();
            try {
                if (!api.equals(AlertServiceImpl.UNKNOWN_SERVICE)) {
                    return AlertServiceImpl.this.apiService.findByIdAsMap(api);
                }
                metadata.put(AlertServiceImpl.METADATA_NAME, AlertServiceImpl.METADATA_UNKNOWN_API_NAME);
                metadata.put(AlertServiceImpl.METADATA_UNKNOWN, Boolean.TRUE.toString());
            }
            catch (ApiNotFoundException anfe) {
                metadata.put(AlertServiceImpl.METADATA_DELETED, Boolean.TRUE.toString());
                metadata.put(AlertServiceImpl.METADATA_NAME, AlertServiceImpl.METADATA_DELETED_API_NAME);
            }
            catch (TechnicalException e) {
                AlertServiceImpl.this.LOGGER.error("Failed to retrieve API {} metadata", (Object)api, (Object)e);
            }
            return metadata;
        }

        private Map<String, Object> getApplicationMetadata(String application) {
            HashMap<String, Object> metadata = new HashMap<String, Object>();
            try {
                if (!application.equals(AlertServiceImpl.UNKNOWN_SERVICE)) {
                    return AlertServiceImpl.this.applicationService.findByIdAsMap(application);
                }
                metadata.put(AlertServiceImpl.METADATA_NAME, AlertServiceImpl.METADATA_UNKNOWN_APPLICATION_NAME);
                metadata.put(AlertServiceImpl.METADATA_UNKNOWN, Boolean.TRUE.toString());
            }
            catch (ApplicationNotFoundException anfe) {
                metadata.put(AlertServiceImpl.METADATA_DELETED, Boolean.TRUE.toString());
                metadata.put(AlertServiceImpl.METADATA_NAME, AlertServiceImpl.METADATA_DELETED_APPLICATION_NAME);
            }
            catch (TechnicalException e) {
                AlertServiceImpl.this.LOGGER.error("Failed to retrieve application {} metadata", (Object)application, (Object)e);
            }
            return metadata;
        }

        private Map<String, Object> getPlanMetadata(String plan) {
            HashMap<String, Object> metadata = new HashMap<String, Object>();
            try {
                return AlertServiceImpl.this.planService.findByIdAsMap(plan);
            }
            catch (PlanNotFoundException anfe) {
                metadata.put(AlertServiceImpl.METADATA_DELETED, Boolean.TRUE.toString());
                metadata.put(AlertServiceImpl.METADATA_NAME, AlertServiceImpl.METADATA_DELETED_PLAN_NAME);
            }
            catch (TechnicalException e) {
                AlertServiceImpl.this.LOGGER.error("Failed to retrieve plan {} metadata", (Object)plan, (Object)e);
            }
            return metadata;
        }
    }
}

