/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.core.theme.model.Theme;
import io.gravitee.apim.infra.adapter.ThemeAdapter;
import io.gravitee.repository.management.model.Theme;
import io.gravitee.repository.management.model.ThemeType;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;

public class ThemeAdapterImpl
implements ThemeAdapter {
    @Override
    public io.gravitee.apim.core.theme.model.Theme map(Theme theme) {
        if (theme == null) {
            return null;
        }
        Theme.ThemeBuilder theme1 = io.gravitee.apim.core.theme.model.Theme.builder();
        theme1.id(theme.getId());
        theme1.name(theme.getName());
        theme1.type(this.themeTypeToThemeType(theme.getType()));
        if (theme.getCreatedAt() != null) {
            theme1.createdAt(ZonedDateTime.ofInstant(theme.getCreatedAt().toInstant(), ZoneId.systemDefault()));
        }
        if (theme.getUpdatedAt() != null) {
            theme1.updatedAt(ZonedDateTime.ofInstant(theme.getUpdatedAt().toInstant(), ZoneId.systemDefault()));
        }
        theme1.enabled(theme.isEnabled());
        theme1.logo(theme.getLogo());
        theme1.optionalLogo(theme.getOptionalLogo());
        theme1.favicon(theme.getFavicon());
        theme1.backgroundImage(theme.getBackgroundImage());
        theme1.definitionPortal(this.deserializeDefinitionPortal(theme));
        theme1.definitionPortalNext(this.deserializeDefinitionPortalNext(theme));
        return theme1.build();
    }

    @Override
    public List<io.gravitee.apim.core.theme.model.Theme> map(List<Theme> themes) {
        if (themes == null) {
            return null;
        }
        ArrayList<io.gravitee.apim.core.theme.model.Theme> list = new ArrayList<io.gravitee.apim.core.theme.model.Theme>(themes.size());
        for (Theme theme : themes) {
            list.add(this.map(theme));
        }
        return list;
    }

    protected Theme.ThemeType themeTypeToThemeType(ThemeType themeType) {
        if (themeType == null) {
            return null;
        }
        return switch (themeType) {
            case ThemeType.PORTAL -> Theme.ThemeType.PORTAL;
            case ThemeType.PORTAL_NEXT -> Theme.ThemeType.PORTAL_NEXT;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + themeType);
        };
    }
}

