/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.apim.core.api.domain_service.ApiImportDomainService;
import io.gravitee.apim.core.api.domain_service.ApiMetadataDomainService;
import io.gravitee.apim.core.api.domain_service.ApiStateDomainService;
import io.gravitee.apim.core.api.domain_service.CreateApiDomainService;
import io.gravitee.apim.core.api.domain_service.UpdateApiDomainService;
import io.gravitee.apim.core.api.domain_service.ValidateApiDomainService;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.api.model.ApiWithFlows;
import io.gravitee.apim.core.api.model.crd.ApiCRDSpec;
import io.gravitee.apim.core.api.model.crd.ApiCRDStatus;
import io.gravitee.apim.core.api.model.crd.MemberCRD;
import io.gravitee.apim.core.api.model.crd.PageCRD;
import io.gravitee.apim.core.api.model.crd.PlanCRD;
import io.gravitee.apim.core.api.model.factory.ApiModelFactory;
import io.gravitee.apim.core.api.model.import_definition.ApiMember;
import io.gravitee.apim.core.api.model.import_definition.ApiMemberRole;
import io.gravitee.apim.core.api.query_service.ApiCategoryQueryService;
import io.gravitee.apim.core.api.query_service.ApiQueryService;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.category.model.Category;
import io.gravitee.apim.core.documentation.crud_service.PageCrudService;
import io.gravitee.apim.core.documentation.domain_service.CreateApiDocumentationDomainService;
import io.gravitee.apim.core.documentation.domain_service.DocumentationValidationDomainService;
import io.gravitee.apim.core.documentation.domain_service.UpdateApiDocumentationDomainService;
import io.gravitee.apim.core.documentation.exception.InvalidPageParentException;
import io.gravitee.apim.core.documentation.model.Page;
import io.gravitee.apim.core.documentation.model.PageSource;
import io.gravitee.apim.core.documentation.query_service.PageQueryService;
import io.gravitee.apim.core.exception.AbstractDomainException;
import io.gravitee.apim.core.group.model.Group;
import io.gravitee.apim.core.group.query_service.GroupQueryService;
import io.gravitee.apim.core.membership.crud_service.MembershipCrudService;
import io.gravitee.apim.core.membership.domain_service.ApiPrimaryOwnerDomainService;
import io.gravitee.apim.core.membership.domain_service.ApiPrimaryOwnerFactory;
import io.gravitee.apim.core.membership.model.Membership;
import io.gravitee.apim.core.membership.model.PrimaryOwnerEntity;
import io.gravitee.apim.core.membership.query_service.MembershipQueryService;
import io.gravitee.apim.core.plan.domain_service.CreatePlanDomainService;
import io.gravitee.apim.core.plan.domain_service.DeletePlanDomainService;
import io.gravitee.apim.core.plan.domain_service.ReorderPlanDomainService;
import io.gravitee.apim.core.plan.domain_service.UpdatePlanDomainService;
import io.gravitee.apim.core.plan.model.Plan;
import io.gravitee.apim.core.plan.query_service.PlanQueryService;
import io.gravitee.apim.core.subscription.domain_service.CloseSubscriptionDomainService;
import io.gravitee.apim.core.subscription.query_service.SubscriptionQueryService;
import io.gravitee.apim.core.user.domain_service.UserDomainService;
import io.gravitee.apim.core.user.model.BaseUserEntity;
import io.gravitee.apim.core.utils.CollectionUtils;
import io.gravitee.common.utils.TimeProvider;
import io.gravitee.definition.model.v4.plan.PlanStatus;
import io.gravitee.rest.api.model.context.KubernetesContext;
import io.gravitee.rest.api.model.context.OriginContext;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.exceptions.UserNotFoundException;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UseCase
public class ImportCRDUseCase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImportCRDUseCase.class);
    private final ApiQueryService apiQueryService;
    private final ApiPrimaryOwnerFactory apiPrimaryOwnerFactory;
    private final ValidateApiDomainService validateApiDomainService;
    private final CreateApiDomainService createApiDomainService;
    private final CreatePlanDomainService createPlanDomainService;
    private final ApiStateDomainService apiStateDomainService;
    private final UpdateApiDomainService updateApiDomainService;
    private final ApiCrudService apiCrudService;
    private final PlanQueryService planQueryService;
    private final PageQueryService pageQueryService;
    private final PageCrudService pageCrudService;
    private final UserDomainService userDomainService;
    private final UpdatePlanDomainService updatePlanDomainService;
    private final DeletePlanDomainService deletePlanDomainService;
    private final SubscriptionQueryService subscriptionQueryService;
    private final CloseSubscriptionDomainService closeSubscriptionDomainService;
    private final ReorderPlanDomainService reorderPlanDomainService;
    private final ApiImportDomainService apiImportDomainService;
    private final ApiPrimaryOwnerDomainService primaryOwnerDomainService;
    private final MembershipCrudService membershipCrudService;
    private final MembershipQueryService membershipQueryService;
    private final GroupQueryService groupQueryService;
    private final ApiMetadataDomainService apiMetadataDomainService;
    private final ApiCategoryQueryService apiCategoryQueryService;
    private final DocumentationValidationDomainService documentationValidationDomainService;
    private final CreateApiDocumentationDomainService createApiDocumentationDomainService;
    private final UpdateApiDocumentationDomainService updateApiDocumentationDomainService;

    public ImportCRDUseCase(ApiCrudService apiCrudService, ApiQueryService apiQueryService, ApiPrimaryOwnerFactory apiPrimaryOwnerFactory, ValidateApiDomainService validateApiDomainService, CreateApiDomainService createApiDomainService, CreatePlanDomainService createPlanDomainService, ApiStateDomainService apiStateDomainService, UpdateApiDomainService updateApiDomainService, PlanQueryService planQueryService, UserDomainService userDomainService, UpdatePlanDomainService updatePlanDomainService, DeletePlanDomainService deletePlanDomainService, SubscriptionQueryService subscriptionQueryService, CloseSubscriptionDomainService closeSubscriptionDomainService, ReorderPlanDomainService reorderPlanDomainService, ApiImportDomainService apiImportDomainService, ApiPrimaryOwnerDomainService primaryOwnerDomainService, MembershipCrudService membershipCrudService, MembershipQueryService membershipQueryService, GroupQueryService groupQueryService, ApiMetadataDomainService apiMetadataDomainService, ApiCategoryQueryService apiCategoryQueryService, PageQueryService pageQueryService, PageCrudService pageCrudService, DocumentationValidationDomainService documentationValidationDomainService, CreateApiDocumentationDomainService createApiDocumentationDomainService, UpdateApiDocumentationDomainService updateApiDocumentationDomainService) {
        this.apiCrudService = apiCrudService;
        this.apiQueryService = apiQueryService;
        this.apiPrimaryOwnerFactory = apiPrimaryOwnerFactory;
        this.validateApiDomainService = validateApiDomainService;
        this.createApiDomainService = createApiDomainService;
        this.createPlanDomainService = createPlanDomainService;
        this.apiStateDomainService = apiStateDomainService;
        this.updateApiDomainService = updateApiDomainService;
        this.planQueryService = planQueryService;
        this.userDomainService = userDomainService;
        this.updatePlanDomainService = updatePlanDomainService;
        this.deletePlanDomainService = deletePlanDomainService;
        this.subscriptionQueryService = subscriptionQueryService;
        this.closeSubscriptionDomainService = closeSubscriptionDomainService;
        this.reorderPlanDomainService = reorderPlanDomainService;
        this.apiImportDomainService = apiImportDomainService;
        this.primaryOwnerDomainService = primaryOwnerDomainService;
        this.membershipCrudService = membershipCrudService;
        this.membershipQueryService = membershipQueryService;
        this.groupQueryService = groupQueryService;
        this.apiMetadataDomainService = apiMetadataDomainService;
        this.apiCategoryQueryService = apiCategoryQueryService;
        this.pageQueryService = pageQueryService;
        this.pageCrudService = pageCrudService;
        this.documentationValidationDomainService = documentationValidationDomainService;
        this.createApiDocumentationDomainService = createApiDocumentationDomainService;
        this.updateApiDocumentationDomainService = updateApiDocumentationDomainService;
    }

    public Output execute(Input input) {
        Optional<Api> api = this.apiQueryService.findByEnvironmentIdAndCrossId(input.auditInfo.environmentId(), input.crd.getCrossId());
        ApiCRDStatus status = api.map(exiting -> this.update(input, (Api)exiting)).orElseGet(() -> this.create(input));
        return new Output(status);
    }

    private ApiCRDStatus create(Input input) {
        try {
            String environmentId = input.auditInfo.environmentId();
            String organizationId = input.auditInfo.organizationId();
            PrimaryOwnerEntity primaryOwner = this.apiPrimaryOwnerFactory.createForNewApi(organizationId, environmentId, input.auditInfo.actor().userId());
            this.resolveGroups(input);
            this.cleanCategories(environmentId, input.crd);
            ApiWithFlows createdApi = this.createApiDomainService.create(ApiModelFactory.fromCrd(input.crd, environmentId), primaryOwner, input.auditInfo, api -> this.validateApiDomainService.validateAndSanitizeForCreation((Api)api, primaryOwner, environmentId, organizationId));
            Map<String, String> planNameIdMapping = input.crd.getPlans().entrySet().stream().map(entry -> Map.entry((String)entry.getKey(), this.createPlanDomainService.create(this.initPlanFromCRD((PlanCRD)entry.getValue()), ((PlanCRD)entry.getValue()).getFlows(), createdApi, input.auditInfo).getId())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            this.createMembers(input, createdApi.getId());
            this.createOrUpdatePages(input.crd.getPages(), createdApi.getId(), input.auditInfo);
            this.apiMetadataDomainService.saveApiMetadata(createdApi.getId(), input.crd.getMetadata(), input.auditInfo);
            if (input.crd.getDefinitionContext().getSyncFrom().equalsIgnoreCase("management")) {
                if (createdApi.getLifecycleState() == Api.LifecycleState.STOPPED) {
                    this.apiStateDomainService.stop(createdApi, input.auditInfo);
                } else {
                    this.apiStateDomainService.start(createdApi, input.auditInfo);
                }
            }
            return ApiCRDStatus.builder().id(createdApi.getId()).crossId(createdApi.getCrossId()).environmentId(environmentId).organizationId(organizationId).state(createdApi.getLifecycleState().name()).plans(planNameIdMapping).build();
        }
        catch (AbstractDomainException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TechnicalManagementException(e);
        }
    }

    private ApiCRDStatus update(Input input, Api existingApi) {
        try {
            this.resolveGroups(input);
            this.cleanCategories(input.auditInfo.environmentId(), input.crd);
            Api updatedApi = this.updateApiDomainService.update(existingApi.getId(), input.crd, input.auditInfo);
            Api api = this.apiCrudService.update((Api)((Api.ApiBuilder)((Api.ApiBuilder)updatedApi.toBuilder().originContext((OriginContext)new KubernetesContext(KubernetesContext.Mode.valueOf((String)input.crd().getDefinitionContext().getMode().toUpperCase()), input.crd().getDefinitionContext().getSyncFrom().toUpperCase()))).lifecycleState(Api.LifecycleState.valueOf(input.crd().getState()))).build());
            List<Plan> existingPlans = this.planQueryService.findAllByApiId(api.getId());
            Map<String, PlanStatus> existingPlanStatuses = existingPlans.stream().collect(Collectors.toMap(Plan::getId, Plan::getPlanStatus));
            Map<String, String> planKeyIdMapping = input.crd().getPlans().entrySet().stream().map(entry -> {
                String key = (String)entry.getKey();
                PlanCRD plan = (PlanCRD)entry.getValue();
                if (existingPlanStatuses.containsKey(plan.getId())) {
                    return Map.entry(key, this.updatePlanDomainService.update(this.initPlanFromCRD(plan), plan.getFlows(), existingPlanStatuses, api, input.auditInfo).getId());
                }
                return Map.entry(key, this.createPlanDomainService.create(this.initPlanFromCRD(plan), plan.getFlows(), api, input.auditInfo).getId());
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            this.deletePlans(api, existingPlans, planKeyIdMapping, input);
            if (input.crd.getDefinitionContext().getSyncFrom().equalsIgnoreCase("management")) {
                if (api.getLifecycleState() == Api.LifecycleState.STOPPED) {
                    this.apiStateDomainService.stop(api, input.auditInfo);
                } else {
                    this.apiStateDomainService.start(api, input.auditInfo);
                }
            }
            this.createMembers(input, updatedApi.getId());
            this.deleteOrphanMemberships(updatedApi.getId(), input);
            this.createOrUpdatePages(input.crd.getPages(), updatedApi.getId(), input.auditInfo);
            this.deleteRemovedPages(input.crd.getPages(), updatedApi.getId());
            this.apiMetadataDomainService.saveApiMetadata(api.getId(), input.crd.getMetadata(), input.auditInfo);
            return ApiCRDStatus.builder().id(api.getId()).crossId(api.getCrossId()).environmentId(api.getEnvironmentId()).organizationId(input.auditInfo.organizationId()).state(api.getLifecycleState().name()).plans(planKeyIdMapping).build();
        }
        catch (Exception e) {
            throw new TechnicalManagementException(e);
        }
    }

    private void deletePlans(Api api, List<Plan> existingPlans, Map<String, String> planKeyIdMapping, Input input) {
        List<Plan> plansToDelete = existingPlans.stream().filter(plan -> !planKeyIdMapping.containsValue(plan.getId())).filter(plan -> !input.crd.getPlans().containsKey(plan.getId())).toList();
        plansToDelete.forEach(plan -> {
            this.subscriptionQueryService.findActiveSubscriptionsByPlan(plan.getId()).forEach(subscription -> this.closeSubscriptionDomainService.closeSubscription(subscription.getId(), input.auditInfo));
            this.deletePlanDomainService.delete((Plan)plan, input.auditInfo);
        });
        this.reorderPlanDomainService.refreshOrderAfterDelete(api.getId());
    }

    private Plan initPlanFromCRD(PlanCRD planCRD) {
        return ((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)Plan.builder().id(planCRD.getId())).name(planCRD.getName())).description(planCRD.getDescription())).planDefinitionV4(io.gravitee.definition.model.v4.plan.Plan.builder().security(planCRD.getSecurity()).selectionRule(planCRD.getSelectionRule()).status(planCRD.getStatus()).tags(planCRD.getTags()).mode(planCRD.getMode()).build())).characteristics(planCRD.getCharacteristics())).crossId(planCRD.getCrossId())).excludedGroups(planCRD.getExcludedGroups())).generalConditions(planCRD.getGeneralConditions())).order(planCRD.getOrder())).type(planCRD.getType())).validation(planCRD.getValidation())).build();
    }

    private void resolveGroups(Input input) {
        if (CollectionUtils.isEmpty(input.crd().getGroups())) {
            log.debug("no group found to resolve in api crd spec");
            return;
        }
        log.debug("resolving api crd spec groups");
        HashSet<String> crdGroups = new HashSet<String>(input.crd.getGroups());
        String envId = input.auditInfo.environmentId();
        List groupsFromIds = this.groupQueryService.findByIds(crdGroups).stream().toList();
        List groupsFromNames = this.groupQueryService.findByNames(envId, crdGroups).stream().toList();
        HashSet<String> groupIds = new HashSet<String>(groupsFromIds.stream().map(Group::getId).toList());
        Set groupNames = groupsFromNames.stream().map(Group::getName).collect(Collectors.toSet());
        groupIds.addAll(groupsFromNames.stream().map(Group::getId).toList());
        crdGroups.removeAll(groupIds);
        crdGroups.removeAll(groupNames);
        for (String unknownGroup : crdGroups) {
            log.warn("group '{}' found in spec will not be imported because it cannot found", (Object)unknownGroup);
        }
        input.crd.setGroups(groupIds);
    }

    private void cleanCategories(String environmentId, ApiCRDSpec spec) {
        if (!CollectionUtils.isEmpty(spec.getCategories())) {
            HashSet<String> categories = new HashSet<String>(spec.getCategories());
            Collection<Category> existingCategories = this.apiCategoryQueryService.findByEnvironmentId(environmentId);
            categories.removeIf(keyOrId -> existingCategories.stream().noneMatch(category -> category.getKey().equals(keyOrId) || category.getId().equals(keyOrId)));
            spec.setCategories(categories);
        }
    }

    private void createMembers(Input input, String apiId) {
        Set<MemberCRD> members = input.crd.getMembers();
        if (members != null && !members.isEmpty()) {
            Set<ApiMember> memberSet = members.stream().map(crd -> {
                BaseUserEntity user = this.userDomainService.findBySource(input.auditInfo.organizationId(), crd.getSource(), crd.getSourceId());
                if (user == null) {
                    throw new UserNotFoundException(crd.getSourceId());
                }
                crd.setId(user.getId());
                return this.initApiMemberFromCRD((MemberCRD)crd);
            }).collect(Collectors.toSet());
            this.apiImportDomainService.createMembers(memberSet, apiId);
        }
    }

    private void deleteOrphanMemberships(String apiId, Input input) {
        PrimaryOwnerEntity po = this.primaryOwnerDomainService.getApiPrimaryOwner(input.auditInfo.organizationId(), apiId);
        Map<String, String> existingApiMembers = this.membershipQueryService.findByReference(Membership.ReferenceType.API, apiId).stream().filter(m -> !m.getMemberId().equals(po.id())).collect(Collectors.toMap(Membership::getMemberId, Membership::getId));
        if (input.crd != null && input.crd.getMembers() != null) {
            input.crd.getMembers().forEach(am -> existingApiMembers.remove(am.getId()));
        }
        existingApiMembers.forEach((k, v) -> this.membershipCrudService.delete((String)v));
    }

    private void deleteRemovedPages(Map<String, PageCRD> pages, String apiId) {
        Set existingPageIds = this.pageQueryService.searchByApiId(apiId).stream().map(Page::getId).collect(Collectors.toSet());
        if (pages != null && !pages.isEmpty()) {
            Set givenPageIds = pages.values().stream().map(PageCRD::getId).collect(Collectors.toSet());
            existingPageIds.removeIf(givenPageIds::contains);
        }
        try {
            for (String id : existingPageIds) {
                this.pageCrudService.delete(id);
            }
        }
        catch (RuntimeException e) {
            log.error("An error as occurred while trying to remove a page with kubernetes origin");
        }
    }

    private void createOrUpdatePages(Map<String, PageCRD> pageCrds, String apiId, AuditInfo auditInfo) {
        if (pageCrds == null || pageCrds.isEmpty()) {
            return;
        }
        Date now = Date.from(TimeProvider.now().toInstant());
        List<Page> pages = pageCrds.values().stream().map(this::initPageFromCRD).toList();
        pages.forEach(page -> {
            page.setReferenceId(apiId);
            page.setReferenceType(Page.ReferenceType.API);
            if (page.getParentId() != null) {
                this.validatePageParent(pages, page.getParentId());
            }
            this.pageCrudService.findById(page.getId()).ifPresentOrElse(oldPage -> {
                Page sanitizedPage = this.documentationValidationDomainService.validateAndSanitizeForUpdate((Page)page, auditInfo.organizationId(), false);
                this.updateApiDocumentationDomainService.updatePage(sanitizedPage.toBuilder().createdAt(oldPage.getCreatedAt()).updatedAt(now).build(), (Page)oldPage, auditInfo);
            }, () -> {
                Page sanitizedPage = this.documentationValidationDomainService.validateAndSanitizeForCreation((Page)page, auditInfo.organizationId(), false);
                this.createApiDocumentationDomainService.createPage(sanitizedPage.toBuilder().createdAt(now).updatedAt(now).build(), auditInfo);
            });
        });
    }

    private void validatePageParent(List<Page> pages, String parentId) {
        pages.stream().filter(page -> parentId.equals(page.getId())).findFirst().ifPresent(parent -> {
            if (!parent.isFolder() && !parent.isRoot()) {
                throw new InvalidPageParentException(parent.getId());
            }
        });
    }

    private Page initPageFromCRD(PageCRD pageCRD) {
        Page page = Page.builder().id(pageCRD.getId()).name(pageCRD.getName()).crossId(pageCRD.getCrossId()).parentId(pageCRD.getParentId()).type(Page.Type.valueOf(pageCRD.getType().name())).visibility(Page.Visibility.valueOf(pageCRD.getVisibility().name())).order(pageCRD.getOrder()).published(pageCRD.isPublished()).content(pageCRD.getContent()).homepage(pageCRD.isHomepage()).configuration(pageCRD.getConfiguration()).build();
        if (pageCRD.getSource() != null) {
            page.setSource(new PageSource(pageCRD.getSource().getType(), pageCRD.getSource().getConfiguration()));
        }
        return page;
    }

    private ApiMember initApiMemberFromCRD(MemberCRD crd) {
        return ApiMember.builder().id(crd.getId()).displayName(crd.getDisplayName()).roles(List.of(new ApiMemberRole(crd.getRole(), RoleScope.API))).build();
    }

    public record Input(AuditInfo auditInfo, ApiCRDSpec crd) {
    }

    public record Output(ApiCRDStatus status) {
    }
}

