/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.impl;

import io.gravitee.common.util.DataEncryptor;
import io.gravitee.rest.api.model.v4.api.properties.PropertyEntity;
import io.gravitee.rest.api.service.impl.TransactionalService;
import io.gravitee.rest.api.service.v4.PropertiesService;
import java.security.GeneralSecurityException;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PropertiesServiceImpl
extends TransactionalService
implements PropertiesService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PropertiesServiceImpl.class);
    private final DataEncryptor dataEncryptor;

    public PropertiesServiceImpl(DataEncryptor dataEncryptor) {
        this.dataEncryptor = dataEncryptor;
    }

    @Override
    public List<PropertyEntity> encryptProperties(List<PropertyEntity> properties) {
        for (PropertyEntity property : properties) {
            if (!property.isEncryptable() || property.isEncrypted()) continue;
            try {
                property.setValue(this.dataEncryptor.encrypt(property.getValue()));
                property.setEncrypted(true);
            }
            catch (GeneralSecurityException e) {
                log.error("Error encrypting property value", (Throwable)e);
            }
        }
        return properties;
    }
}

