/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.cockpit.command.handler;

import io.gravitee.cockpit.api.command.Command;
import io.gravitee.cockpit.api.command.CommandHandler;
import io.gravitee.cockpit.api.command.CommandStatus;
import io.gravitee.cockpit.api.command.designer.DeployModelCommand;
import io.gravitee.cockpit.api.command.designer.DeployModelPayload;
import io.gravitee.cockpit.api.command.designer.DeployModelReply;
import io.gravitee.rest.api.model.EnvironmentEntity;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.api.ApiEntityResult;
import io.gravitee.rest.api.service.EnvironmentService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.cockpit.model.DeploymentMode;
import io.gravitee.rest.api.service.cockpit.services.ApiServiceCockpit;
import io.gravitee.rest.api.service.cockpit.services.CockpitApiPermissionChecker;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.SecurityContextHelper;
import io.gravitee.rest.api.service.exceptions.EnvironmentNotFoundException;
import io.gravitee.rest.api.service.v4.ApiSearchService;
import io.reactivex.rxjava3.core.Single;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DeployModelCommandHandler
implements CommandHandler<DeployModelCommand, DeployModelReply> {
    private final Logger logger = LoggerFactory.getLogger(DeployModelCommandHandler.class);
    private final ApiSearchService apiSearchService;
    private final ApiServiceCockpit cockpitApiService;
    private final CockpitApiPermissionChecker permissionChecker;
    private final UserService userService;
    private final EnvironmentService environmentService;

    public Command.Type handleType() {
        return Command.Type.DEPLOY_MODEL_COMMAND;
    }

    public Single<DeployModelReply> handle(DeployModelCommand command) {
        DeployModelPayload payload = (DeployModelPayload)command.getPayload();
        String apiCrossId = payload.getModelId();
        String userId = payload.getUserId();
        String swaggerDefinition = payload.getSwaggerDefinition();
        String environmentId = payload.getEnvironmentId();
        DeploymentMode mode = DeploymentMode.fromDeployModelPayload(payload);
        List labels = payload.getLabels();
        try {
            ApiEntityResult result;
            EnvironmentEntity environment = this.getEnvironment(environmentId);
            ExecutionContext executionContext = new ExecutionContext(environment);
            UserEntity user = this.userService.findBySource(executionContext.getOrganizationId(), "cockpit", userId, true);
            SecurityContextHelper.authenticateAs(user);
            Optional<String> optApiId = this.apiSearchService.findIdByEnvironmentIdAndCrossId(executionContext.getEnvironmentId(), apiCrossId);
            if (optApiId.isPresent()) {
                String apiId = optApiId.get();
                Optional<String> message = this.permissionChecker.checkUpdatePermission(executionContext, user.getId(), executionContext.getEnvironmentId(), apiId, mode);
                if (message.isPresent()) {
                    DeployModelReply reply = new DeployModelReply(command.getId(), CommandStatus.FAILED);
                    reply.setMessage(message.get());
                    return Single.just((Object)reply);
                }
                result = this.cockpitApiService.updateApi(executionContext, apiId, user.getId(), swaggerDefinition, executionContext.getEnvironmentId(), mode, labels);
            } else {
                Optional<String> message = this.permissionChecker.checkCreatePermission(executionContext, user.getId(), executionContext.getEnvironmentId(), mode);
                if (message.isPresent()) {
                    DeployModelReply reply = new DeployModelReply(command.getId(), CommandStatus.FAILED);
                    reply.setMessage(message.get());
                    return Single.just((Object)reply);
                }
                result = this.cockpitApiService.createApi(executionContext, apiCrossId, user.getId(), swaggerDefinition, executionContext.getEnvironmentId(), mode, labels);
            }
            if (result.isSuccess()) {
                this.logger.info("Api imported [{}].", (Object)result.getApi().getId());
                return Single.just((Object)new DeployModelReply(command.getId(), CommandStatus.SUCCEEDED));
            }
            this.logger.error("Failed to import API [{}].", (Object)result.getErrorMessage());
            DeployModelReply reply = new DeployModelReply(command.getId(), CommandStatus.FAILED);
            reply.setMessage(result.getErrorMessage());
            return Single.just((Object)reply);
        }
        catch (Exception e) {
            this.logger.error("Error occurred when importing api [{}].", (Object)payload.getModelId(), (Object)e);
            return Single.just((Object)new DeployModelReply(command.getId(), CommandStatus.ERROR));
        }
    }

    private EnvironmentEntity getEnvironment(String environmentId) {
        try {
            return this.environmentService.findByCockpitId(environmentId);
        }
        catch (EnvironmentNotFoundException e) {
            return this.environmentService.findById(environmentId);
        }
    }

    @Generated
    public DeployModelCommandHandler(ApiSearchService apiSearchService, ApiServiceCockpit cockpitApiService, CockpitApiPermissionChecker permissionChecker, UserService userService, EnvironmentService environmentService) {
        this.apiSearchService = apiSearchService;
        this.cockpitApiService = cockpitApiService;
        this.permissionChecker = permissionChecker;
        this.userService = userService;
        this.environmentService = environmentService;
    }
}

