/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiQualityRuleRepository;
import io.gravitee.repository.management.api.QualityRuleRepository;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.QualityRule;
import io.gravitee.rest.api.model.quality.NewQualityRuleEntity;
import io.gravitee.rest.api.model.quality.QualityRuleEntity;
import io.gravitee.rest.api.model.quality.QualityRuleReferenceType;
import io.gravitee.rest.api.model.quality.UpdateQualityRuleEntity;
import io.gravitee.rest.api.service.AuditService;
import io.gravitee.rest.api.service.QualityRuleService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.exceptions.QualityRuleNotFoundException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.AbstractService;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class QualityRuleServiceImpl
extends AbstractService
implements QualityRuleService {
    private static final Logger LOGGER = LoggerFactory.getLogger(QualityRuleServiceImpl.class);
    @Lazy
    @Autowired
    private QualityRuleRepository qualityRuleRepository;
    @Lazy
    @Autowired
    private ApiQualityRuleRepository apiQualityRuleRepository;
    @Autowired
    private AuditService auditService;

    @Override
    public QualityRuleEntity findByReferenceAndId(QualityRuleReferenceType referenceType, String referenceId, String id) {
        try {
            LOGGER.debug("Find quality rule by id : {}", (Object)id);
            return this.qualityRuleRepository.findById((Object)id).filter(qr -> qr.getReferenceType() == QualityRule.ReferenceType.valueOf((String)referenceType.name()) && qr.getReferenceId().equalsIgnoreCase(referenceId)).map(this::convert).orElseThrow(() -> new QualityRuleNotFoundException(id));
        }
        catch (TechnicalException ex) {
            String error = "An error occurs while trying to find a quality rule using its ID: " + id;
            LOGGER.error(error, (Throwable)ex);
            throw new TechnicalManagementException(error, ex);
        }
    }

    @Override
    public List<QualityRuleEntity> findAll() {
        try {
            LOGGER.debug("Find all quality rules");
            return this.qualityRuleRepository.findAll().stream().map(this::convert).collect(Collectors.toList());
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to find all quality rules", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find all quality rules", ex);
        }
    }

    @Override
    public List<QualityRuleEntity> findByReference(QualityRuleReferenceType referenceType, String referenceId) {
        try {
            LOGGER.debug("Find quality rules for {} [{}]", (Object)referenceType, (Object)referenceId);
            return this.qualityRuleRepository.findByReference(this.repoQualityRuleReferenceType(referenceType), referenceId).stream().map(this::convert).toList();
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to find quality rules for {} [{}]", new Object[]{referenceType, referenceId, ex});
            throw new TechnicalManagementException("An error occurs while trying to find quality rules for reference" + referenceType + " " + referenceId, ex);
        }
    }

    @Override
    public QualityRuleEntity create(ExecutionContext executionContext, NewQualityRuleEntity newEntity, QualityRuleReferenceType referenceType, String referenceId) {
        try {
            QualityRule qualityRule = this.convert(newEntity, referenceType, referenceId);
            QualityRule createdQualityRule = (QualityRule)this.qualityRuleRepository.create((Object)qualityRule);
            this.auditService.createAuditLog(executionContext, Collections.singletonMap(Audit.AuditProperties.QUALITY_RULE, createdQualityRule.getId()), (Audit.AuditEvent)QualityRule.AuditEvent.QUALITY_RULE_CREATED, qualityRule.getCreatedAt(), null, qualityRule);
            return this.convert(createdQualityRule);
        }
        catch (TechnicalException e) {
            LOGGER.error("An error occurs while trying to create a quality rule {}", (Object)newEntity, (Object)e);
            throw new TechnicalManagementException("An error occurs while trying to create a quality rule " + newEntity, e);
        }
    }

    @Override
    public QualityRuleEntity update(ExecutionContext executionContext, UpdateQualityRuleEntity updateEntity) {
        try {
            QualityRule qualityRule = this.qualityRuleRepository.findById((Object)updateEntity.getId()).filter(qr -> qr.getReferenceType() == QualityRule.ReferenceType.ENVIRONMENT && qr.getReferenceId().equalsIgnoreCase(executionContext.getEnvironmentId())).orElseThrow(() -> new QualityRuleNotFoundException(updateEntity.getId()));
            QualityRule updatedQualityRule = (QualityRule)this.qualityRuleRepository.update((Object)this.convert(updateEntity, qualityRule));
            this.auditService.createAuditLog(executionContext, Collections.singletonMap(Audit.AuditProperties.QUALITY_RULE, updatedQualityRule.getId()), (Audit.AuditEvent)QualityRule.AuditEvent.QUALITY_RULE_UPDATED, updatedQualityRule.getUpdatedAt(), qualityRule, updatedQualityRule);
            return this.convert(updatedQualityRule);
        }
        catch (TechnicalException e) {
            LOGGER.error("An error occurs while trying to update quality rule {}", (Object)updateEntity, (Object)e);
            throw new TechnicalManagementException("An error occurs while trying to update quality rule " + updateEntity, e);
        }
    }

    @Override
    public void delete(ExecutionContext executionContext, String qualityRule) {
        try {
            Optional<QualityRule> qualityRuleOptional = this.qualityRuleRepository.findById((Object)qualityRule).filter(qr -> qr.getReferenceType() == QualityRule.ReferenceType.ENVIRONMENT && qr.getReferenceId().equalsIgnoreCase(executionContext.getEnvironmentId()));
            if (qualityRuleOptional.isPresent()) {
                this.qualityRuleRepository.delete((Object)qualityRule);
                this.apiQualityRuleRepository.deleteByQualityRule(qualityRule);
                this.auditService.createAuditLog(executionContext, Collections.singletonMap(Audit.AuditProperties.QUALITY_RULE, qualityRule), (Audit.AuditEvent)QualityRule.AuditEvent.QUALITY_RULE_DELETED, new Date(), null, qualityRuleOptional.get());
            }
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to delete quality rule {}", (Object)qualityRule, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to delete quality rule " + qualityRule, ex);
        }
    }

    private QualityRuleEntity convert(QualityRule qualityRule) {
        return QualityRuleEntity.builder().id(qualityRule.getId()).referenceType(QualityRuleReferenceType.valueOf((String)qualityRule.getReferenceType().name())).referenceId(qualityRule.getReferenceId()).name(qualityRule.getName()).description(qualityRule.getDescription()).weight(qualityRule.getWeight()).createdAt(qualityRule.getCreatedAt()).updatedAt(qualityRule.getUpdatedAt()).build();
    }

    private QualityRule convert(NewQualityRuleEntity qualityRuleEntity, QualityRuleReferenceType referenceType, String referenceId) {
        Date now = new Date();
        return QualityRule.builder().id(UuidString.generateRandom()).referenceType(this.repoQualityRuleReferenceType(referenceType)).referenceId(referenceId).name(qualityRuleEntity.getName()).description(qualityRuleEntity.getDescription()).weight(qualityRuleEntity.getWeight()).createdAt(now).updatedAt(now).build();
    }

    private QualityRule convert(UpdateQualityRuleEntity qualityRuleEntity, QualityRule qr) {
        return QualityRule.builder().id(qualityRuleEntity.getId()).referenceType(qr.getReferenceType()).referenceId(qr.getReferenceId()).name(qualityRuleEntity.getName()).description(qualityRuleEntity.getDescription()).weight(qualityRuleEntity.getWeight()).createdAt(qr.getCreatedAt()).updatedAt(new Date()).build();
    }

    private QualityRule.ReferenceType repoQualityRuleReferenceType(QualityRuleReferenceType referenceType) {
        return QualityRule.ReferenceType.valueOf((String)referenceType.name());
    }
}

