/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.crud_service.api_key;

import io.gravitee.apim.core.api_key.crud_service.ApiKeyCrudService;
import io.gravitee.apim.core.api_key.model.ApiKeyEntity;
import io.gravitee.apim.infra.adapter.ApiKeyAdapter;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiKeyRepository;
import io.gravitee.repository.management.model.ApiKey;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ApiKeyCrudServiceImpl
implements ApiKeyCrudService {
    private final ApiKeyRepository apiKeyRepository;

    public ApiKeyCrudServiceImpl(@Lazy ApiKeyRepository apiKeyRepository) {
        this.apiKeyRepository = apiKeyRepository;
    }

    @Override
    public ApiKeyEntity update(ApiKeyEntity apiKey) {
        try {
            ApiKey result = this.apiKeyRepository.update(ApiKeyAdapter.INSTANCE.fromEntity(apiKey));
            return ApiKeyAdapter.INSTANCE.toEntity(result);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException("An error occurs while trying to update the api key: " + apiKey.getId(), e);
        }
    }
}

