/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.search.lucene.searcher;

import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.common.Sortable;
import io.gravitee.rest.api.service.impl.search.SearchResult;
import io.gravitee.rest.api.service.impl.search.lucene.DocumentSearcher;
import io.gravitee.rest.api.service.impl.search.lucene.analyzer.CustomWhitespaceAnalyzer;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.QueryParserBase;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopScoreDocCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractDocumentSearcher
implements DocumentSearcher {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static final String FIELD_ID = "id";
    protected static final String FIELD_TYPE = "type";
    protected static final String FIELD_API_TYPE_VALUE = "api";
    protected Analyzer analyzer = new CustomWhitespaceAnalyzer();
    @Autowired
    protected IndexWriter indexWriter;

    protected static void increaseMaxClauseCountIfNecessary(int size) {
        if (size > IndexSearcher.getMaxClauseCount()) {
            IndexSearcher.setMaxClauseCount((int)size);
        }
    }

    protected SearchResult search(Query query) throws TechnicalException {
        return this.search(query, null, null, FIELD_ID);
    }

    protected SearchResult search(Query query, Sortable sortable) throws TechnicalException {
        return this.search(query, sortable, null, FIELD_ID);
    }

    public SearchResult searchReference(Query query) throws TechnicalException {
        return this.search(query, null, null, "reference_id");
    }

    protected SearchResult search(Query query, Sortable sort, Pageable pageable) throws TechnicalException {
        return this.search(query, sort, pageable, FIELD_ID);
    }

    protected SearchResult search(Query query, Sortable sort, Pageable pageable, String fieldReference) throws TechnicalException {
        this.logger.debug("Searching for: {}", (Object)query.toString());
        try {
            Object topDocs;
            IndexSearcher searcher = this.getIndexSearcher();
            if (pageable != null) {
                TopScoreDocCollector collector = TopScoreDocCollector.create((int)1000, (int)1000);
                searcher.search(query, (Collector)collector);
                topDocs = collector.topDocs((pageable.getPageNumber() - 1) * pageable.getPageSize(), pageable.getPageSize());
            } else {
                topDocs = sort != null ? searcher.search(query, Integer.MAX_VALUE, this.convert(sort)) : searcher.search(query, Integer.MAX_VALUE);
            }
            LinkedHashSet<String> results = new LinkedHashSet<String>();
            this.logger.debug("Found {} total matching documents", (Object)topDocs.totalHits);
            for (ScoreDoc doc : topDocs.scoreDocs) {
                String reference = searcher.doc(doc.doc).get(fieldReference);
                results.add(reference);
            }
            return new SearchResult(results, topDocs.totalHits.value);
        }
        catch (IOException ioe) {
            this.logger.error("An error occurs while getting documents from search result", (Throwable)ioe);
            throw new TechnicalException("An error occurs while getting documents from search result", (Throwable)ioe);
        }
    }

    protected Sort convert(Sortable sort) {
        if (sort != null) {
            return new Sort(new SortField[]{new SortField(sort.getField() + "_sorted", SortField.Type.STRING, !sort.isAscOrder())});
        }
        return null;
    }

    private IndexSearcher getIndexSearcher() throws IOException {
        return new IndexSearcher((IndexReader)DirectoryReader.open((IndexWriter)this.indexWriter));
    }

    protected Optional<Query> buildFilterQuery(String apiReferenceField, Map<String, Object> filters) {
        Object values;
        if (filters == null || filters.isEmpty()) {
            return Optional.empty();
        }
        BooleanQuery.Builder filtersQuery = new BooleanQuery.Builder();
        if (filters.containsKey(FIELD_API_TYPE_VALUE) && Collection.class.isAssignableFrom((values = filters.get(FIELD_API_TYPE_VALUE)).getClass())) {
            Collection valuesAsCollection = (Collection)values;
            AbstractDocumentSearcher.increaseMaxClauseCountIfNecessary(valuesAsCollection.size());
            BooleanQuery.Builder filterApisQuery = new BooleanQuery.Builder();
            ((Collection)values).forEach(value -> filterApisQuery.add((Query)new TermQuery(new Term(apiReferenceField, (String)value)), BooleanClause.Occur.SHOULD));
            if (valuesAsCollection.size() > 0) {
                filtersQuery.add((Query)filterApisQuery.build(), BooleanClause.Occur.MUST);
            }
        }
        boolean[] hasClause = new boolean[]{false};
        filters.forEach((field, value) -> {
            if (!Collection.class.isAssignableFrom(value.getClass())) {
                filtersQuery.add((Query)new TermQuery(new Term(field, QueryParserBase.escape((String)((String)value)))), BooleanClause.Occur.MUST);
                hasClause[0] = true;
            }
        });
        if (hasClause[0]) {
            filtersQuery.add((Query)filtersQuery.build(), BooleanClause.Occur.MUST);
        }
        return Optional.of(filtersQuery.build());
    }
}

