/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.json.jackson;

import com.fasterxml.jackson.databind.json.JsonMapper;
import io.gravitee.apim.core.json.JsonProcessingException;
import io.gravitee.apim.core.json.JsonSerializer;
import io.gravitee.apim.infra.json.jackson.JsonMapperFactory;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonJsonSerializer
implements JsonSerializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JacksonJsonSerializer.class);
    private final JsonMapper mapper;

    public JacksonJsonSerializer() {
        this(JsonMapperFactory.build());
    }

    public JacksonJsonSerializer(JsonMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public String serialize(Object object) throws JsonProcessingException {
        try {
            return this.mapper.writeValueAsString(object);
        }
        catch (com.fasterxml.jackson.core.JsonProcessingException e) {
            log.debug("Fail to serialize json: {}", object, (Object)e);
            throw new JsonProcessingException("Fail to serialize object", e);
        }
    }
}

